/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.renderer.c3.client.charts.map.geojson.impl;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.dashbuilder.renderer.c3.client.charts.map.geojson.CountriesGeoJsonService;
import org.dashbuilder.renderer.c3.client.charts.map.geojson.GeoJsonLoader;
import org.dashbuilder.renderer.c3.client.jsbinding.geojson.Feature;
import org.dashbuilder.renderer.c3.client.jsbinding.geojson.FeatureCollection;
import org.uberfire.client.views.pfly.widgets.D3;

public class CountriesGeoJsonServiceImpl
implements CountriesGeoJsonService {
    static final String COUNTRY_NAME_PROPERTY = "name";
    static final String LAT_LONG_REGEX = "\\s*(\\-?\\d+(\\.\\d+)?),\\s*(\\-?\\d+(\\.\\d+)?)\\s*";
    @Inject
    GeoJsonLoader geoJsonLoader;
    D3 d3;
    private FeatureCollection featureCollection;

    @PostConstruct
    public void setup() {
        this.featureCollection = this.geoJsonLoader.load();
        this.d3 = D3.Builder.get();
    }

    @Override
    public Feature[] getCountries() {
        return this.featureCollection.getFeatures();
    }

    @Override
    public String getCountryName(Feature country) {
        Object name;
        Object object = name = country == null ? null : country.getProperties().get(COUNTRY_NAME_PROPERTY);
        if (name != null) {
            return name.toString();
        }
        return "";
    }

    @Override
    public String getCountryNameByCode(String code) {
        return Arrays.stream(this.featureCollection.getFeatures()).filter(f -> f.getId().equalsIgnoreCase(code)).map(this::getCountryName).findFirst().orElse("");
    }

    @Override
    public Optional<Map.Entry<String, Double>> findEntry(Map<String, Double> data, Feature feature) {
        if (this.usesLocation(data)) {
            return this.entriesByLocation(data, feature).findAny();
        }
        return this.entryByCountry(data, feature);
    }

    @Override
    public Optional<Double> findValue(Map<String, Double> data, Feature feature) {
        if (this.usesLocation(data)) {
            return this.valueByLocation(data, feature);
        }
        return this.findEntry(data, feature).flatMap(e -> Optional.ofNullable(e.getValue()));
    }

    @Override
    public Optional<Feature> findCountry(String idNameOrLocation) {
        if (idNameOrLocation.matches(LAT_LONG_REGEX)) {
            return this.countryByLocation(idNameOrLocation);
        }
        return this.countryByIdOrName(idNameOrLocation);
    }

    public Optional<Feature> countryByIdOrName(String idOrName) {
        return Arrays.stream(this.featureCollection.getFeatures()).filter(f -> {
            String countryName = this.getCountryName((Feature)f);
            return idOrName.equalsIgnoreCase(f.getId()) || idOrName.equalsIgnoreCase(countryName);
        }).findFirst();
    }

    public Optional<Feature> countryByLocation(String location) {
        return Arrays.stream(this.featureCollection.getFeatures()).filter(f -> this.containsLocation(location, (Feature)f)).findFirst();
    }

    public Optional<Map.Entry<String, Double>> entryByCountry(Map<String, Double> data, Feature value) {
        if (value == null) {
            return Optional.empty();
        }
        String countryID = value.getId();
        String countryName = this.getCountryName(value);
        return data.entrySet().stream().filter(k -> ((String)k.getKey()).equalsIgnoreCase(countryID) || ((String)k.getKey()).equalsIgnoreCase(countryName)).findFirst();
    }

    public Optional<Double> valueByCountry(Map<String, Double> data, Feature value) {
        return this.entryByCountry(data, value).flatMap(e -> Optional.ofNullable(e.getValue()));
    }

    public Stream<Map.Entry<String, Double>> entriesByLocation(Map<String, Double> data, Feature feature) {
        return data.entrySet().stream().filter(e -> ((String)e.getKey()).matches(LAT_LONG_REGEX)).filter(e -> this.containsLocation((String)e.getKey(), feature));
    }

    public Optional<Double> valueByLocation(Map<String, Double> data, Feature feature) {
        List values = this.entriesByLocation(data, feature).map(Map.Entry::getValue).collect(Collectors.toList());
        if (values.isEmpty()) {
            return Optional.empty();
        }
        Double value = 0.0;
        for (Double v : values) {
            value = value + v;
        }
        return Optional.of(value);
    }

    protected boolean containsLocation(String latitudeLongitudeStr, Feature feature) {
        if (latitudeLongitudeStr == null || !latitudeLongitudeStr.matches(LAT_LONG_REGEX)) {
            return false;
        }
        Double[] latLong = this.extractLatLongInfo(latitudeLongitudeStr);
        Double[] longLat = new Double[]{latLong[1], latLong[0]};
        return this.d3.geoContains((Object)feature, longLat);
    }

    protected Double[] extractLatLongInfo(String value) {
        return (Double[])Stream.of(value.replaceAll("\\s", "").split(",")).map(Double::parseDouble).toArray(Double[]::new);
    }

    private boolean usesLocation(Map<String, Double> data) {
        if (data.isEmpty()) {
            return false;
        }
        return data.keySet().iterator().next().matches(LAT_LONG_REGEX);
    }
}

