/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.renderer.c3.client;

import java.util.List;
import java.util.Set;
import org.dashbuilder.common.client.widgets.FilterLabel;
import org.dashbuilder.common.client.widgets.FilterLabelSet;
import org.dashbuilder.dataset.DataColumn;
import org.dashbuilder.dataset.group.Interval;
import org.dashbuilder.displayer.ColumnSettings;
import org.dashbuilder.displayer.client.AbstractGwtDisplayer;

public abstract class C3AbstractDisplayer<V extends View>
extends AbstractGwtDisplayer<V> {
    protected FilterLabelSet filterLabelSet;

    public C3AbstractDisplayer(FilterLabelSet filterLabelSet) {
        this.filterLabelSet = filterLabelSet;
        this.filterLabelSet.setOnClearAllCommand(this::onFilterClearAll);
    }

    protected void createVisualization() {
        ((View)this.getView()).setFilterLabelSet(this.filterLabelSet);
        this.updateVisualization();
    }

    protected void updateVisualization() {
        ((View)this.getView()).setSize(this.displayerSettings.getChartWidth(), this.displayerSettings.getChartHeight());
        if (this.dataSet.getRowCount() == 0) {
            ((View)this.getView()).noData();
        } else {
            this.updateFilterStatus();
            this.updateVisualizationWithData();
        }
    }

    protected abstract void updateVisualizationWithData();

    void onFilterClearAll() {
        super.filterReset();
        if (!this.displayerSettings.isFilterSelfApplyEnabled()) {
            this.updateVisualization();
        }
    }

    void onFilterLabelRemoved(String columnId, int row) {
        super.filterUpdate(columnId, row);
        if (!this.displayerSettings.isFilterSelfApplyEnabled()) {
            this.updateVisualization();
        }
    }

    protected void addToSelection(int row) {
        String columnId = ((DataColumn)this.dataSet.getColumns().get(0)).getId();
        Integer maxSelections = this.displayerSettings.isFilterSelfApplyEnabled() ? null : Integer.valueOf(this.dataSet.getRowCount());
        this.filterUpdate(columnId, row, maxSelections);
        if (!this.displayerSettings.isFilterSelfApplyEnabled()) {
            this.updateVisualization();
        }
    }

    protected void updateFilterStatus() {
        this.filterLabelSet.clear();
        Set columnFilters = this.filterColumns();
        if (this.displayerSettings.isFilterEnabled() && !columnFilters.isEmpty()) {
            for (String columnId : columnFilters) {
                List selectedValues = this.filterIntervals(columnId);
                DataColumn column = this.dataSet.getColumnById(columnId);
                for (Interval interval : selectedValues) {
                    String formattedValue = this.formatInterval(interval, column);
                    FilterLabel filterLabel = this.filterLabelSet.addLabel(formattedValue);
                    filterLabel.setOnRemoveCommand(() -> this.onFilterLabelRemoved(columnId, interval.getIndex()));
                }
            }
        }
    }

    protected String evaluateValueToString(Object mightBeNull, ColumnSettings settings) {
        String value = this.columnValueToString(mightBeNull);
        return this.getEvaluator().evalExpression(value, settings.getValueExpression());
    }

    protected String columnValueToString(Object mightBeNull) {
        return mightBeNull == null ? "" : mightBeNull.toString();
    }

    public static interface View<P extends C3AbstractDisplayer>
    extends AbstractGwtDisplayer.View<P> {
        public void noData();

        public void setSize(int var1, int var2);

        public void setFilterLabelSet(FilterLabelSet var1);

        public void showTitle(String var1);
    }
}

