/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.renderer.c3.client;

import com.google.gwt.dom.client.Element;
import elemental2.dom.DomGlobal;
import elemental2.dom.MutationObserver;
import elemental2.dom.MutationObserverInit;
import elemental2.dom.Node;
import jsinterop.base.Js;
import org.dashbuilder.renderer.c3.client.C3AbstractDisplayerView;
import org.dashbuilder.renderer.c3.client.C3Displayer;
import org.dashbuilder.renderer.c3.client.jsbinding.C3;
import org.dashbuilder.renderer.c3.client.jsbinding.C3Chart;
import org.dashbuilder.renderer.c3.client.jsbinding.C3ChartConf;
import org.dashbuilder.renderer.c3.client.resources.i18n.C3DisplayerConstants;
import org.dashbuilder.renderer.c3.mutationobserver.MutationObserverFactory;

public abstract class C3DisplayerView<P extends C3Displayer>
extends C3AbstractDisplayerView<P>
implements C3Displayer.View<P> {
    protected C3Chart chart;

    @Override
    public void init(P presenter) {
        super.init(presenter);
    }

    @Override
    public void updateChart(C3ChartConf conf) {
        this.displayerPanel.clear();
        conf.setBindto(this.displayerPanel.getElement());
        this.chart = C3.generate(conf);
    }

    @Override
    public String getGroupsTitle() {
        return C3DisplayerConstants.INSTANCE.common_Categories();
    }

    @Override
    public String getColumnsTitle() {
        return C3DisplayerConstants.INSTANCE.common_Series();
    }

    @Override
    public void setBackgroundColor(String color) {
        ((Element)this.chart.getElement().getElementsByTagName("svg").getItem(0)).getStyle().setBackgroundColor(color);
    }

    @Override
    public void setResizable(int maxWidth, int maxHeight) {
        this.displayerPanel.setWidth("100%");
        this.displayerPanel.getElement().getStyle().setProperty("maxWidth", maxWidth + "px");
        this.displayerPanel.getElement().getStyle().setProperty("maxHeight", maxHeight + "px");
        this.registerMutationObserver();
    }

    private void registerMutationObserver() {
        MutationObserver observer = new MutationObserver((records, obs) -> {
            Node elementalNode = (Node)Js.cast((Object)this.displayerPanel.getElement());
            if (DomGlobal.document.body.contains(elementalNode)) {
                if (this.chart != null) {
                    this.chart.flush();
                }
                obs.disconnect();
            }
            return null;
        });
        MutationObserverInit options = new MutationObserverFactory().mutationObserverInit();
        options.setChildList(true);
        observer.observe((Node)DomGlobal.document.body, options);
    }
}

