/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.renderer.c3.client;

import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.dashbuilder.displayer.DisplayerSettings;
import org.dashbuilder.displayer.DisplayerSubType;
import org.dashbuilder.displayer.DisplayerType;
import org.dashbuilder.displayer.client.AbstractRendererLibrary;
import org.dashbuilder.displayer.client.Displayer;
import org.dashbuilder.renderer.c3.client.C3AbstractDisplayer;
import org.dashbuilder.renderer.c3.client.C3Displayer;
import org.dashbuilder.renderer.c3.client.charts.area.C3AreaChartDisplayer;
import org.dashbuilder.renderer.c3.client.charts.bar.C3BarChartDisplayer;
import org.dashbuilder.renderer.c3.client.charts.bubble.C3BubbleChartDisplayer;
import org.dashbuilder.renderer.c3.client.charts.line.C3LineChartDisplayer;
import org.dashbuilder.renderer.c3.client.charts.map.D3MapDisplayer;
import org.dashbuilder.renderer.c3.client.charts.meter.C3MeterChartDisplayer;
import org.dashbuilder.renderer.c3.client.charts.pie.C3PieChartDisplayer;
import org.dashbuilder.renderer.c3.client.exports.ResourcesInjector;
import org.jboss.errai.ioc.client.container.SyncBeanManager;

@ApplicationScoped
public class C3Renderer
extends AbstractRendererLibrary {
    public static final String UUID = "c3";
    @Inject
    protected SyncBeanManager beanManager;
    private static List<DisplayerType> SUPPORTED_TYPES = Arrays.asList(DisplayerType.LINECHART, DisplayerType.BARCHART, DisplayerType.PIECHART, DisplayerType.AREACHART, DisplayerType.BUBBLECHART, DisplayerType.METERCHART, DisplayerType.MAP);

    @PostConstruct
    public void prepare() {
        ResourcesInjector.ensureC3Injected();
    }

    public String getUUID() {
        return UUID;
    }

    public String getName() {
        return "C3 Charts";
    }

    public List<DisplayerSubType> getSupportedSubtypes(DisplayerType displayerType) {
        switch (displayerType) {
            case LINECHART: {
                return Arrays.asList(DisplayerSubType.LINE, DisplayerSubType.SMOOTH);
            }
            case BARCHART: {
                return Arrays.asList(DisplayerSubType.BAR, DisplayerSubType.BAR_STACKED, DisplayerSubType.COLUMN, DisplayerSubType.COLUMN_STACKED);
            }
            case PIECHART: {
                return Arrays.asList(DisplayerSubType.PIE, DisplayerSubType.DONUT, DisplayerSubType.PIE_3D);
            }
            case AREACHART: {
                return Arrays.asList(DisplayerSubType.AREA, DisplayerSubType.AREA_STACKED);
            }
            case MAP: {
                return Arrays.asList(DisplayerSubType.MAP_MARKERS, DisplayerSubType.MAP_REGIONS);
            }
        }
        return Collections.emptyList();
    }

    public Displayer lookupDisplayer(DisplayerSettings displayerSettings) {
        C3AbstractDisplayer displayer;
        DisplayerType displayerType = displayerSettings.getType();
        DisplayerSubType subtype = displayerSettings.getSubtype();
        switch (displayerType) {
            case LINECHART: {
                displayer = this.getLineChartForSubType(subtype);
                break;
            }
            case BARCHART: {
                displayer = this.createBarChartForSubType(subtype);
                break;
            }
            case PIECHART: {
                displayer = this.getPieChartForSubType(subtype);
                break;
            }
            case AREACHART: {
                displayer = this.getAreaChartForSubType(subtype);
                break;
            }
            case BUBBLECHART: {
                displayer = (C3AbstractDisplayer)((Object)this.beanManager.lookupBean(C3BubbleChartDisplayer.class, new Annotation[0]).newInstance());
                break;
            }
            case METERCHART: {
                displayer = (C3AbstractDisplayer)((Object)this.beanManager.lookupBean(C3MeterChartDisplayer.class, new Annotation[0]).newInstance());
                break;
            }
            case MAP: {
                displayer = this.createMapChartForSubType(subtype);
                break;
            }
            default: {
                return null;
            }
        }
        return displayer;
    }

    private D3MapDisplayer createMapChartForSubType(DisplayerSubType subtype) {
        ResourcesInjector.ensureD3GeoProjectionInjected();
        D3MapDisplayer displayer = (D3MapDisplayer)((Object)this.beanManager.lookupBean(D3MapDisplayer.class, new Annotation[0]).newInstance());
        displayer = subtype == DisplayerSubType.MAP_MARKERS ? displayer.markers() : displayer.regions();
        return displayer;
    }

    private C3Displayer createBarChartForSubType(DisplayerSubType subtype) {
        C3BarChartDisplayer displayer;
        switch (subtype) {
            case BAR: {
                displayer = ((C3BarChartDisplayer)((Object)this.beanManager.lookupBean(C3BarChartDisplayer.class, new Annotation[0]).newInstance())).rotated();
                break;
            }
            case BAR_STACKED: {
                displayer = ((C3BarChartDisplayer)((Object)this.beanManager.lookupBean(C3BarChartDisplayer.class, new Annotation[0]).newInstance())).stackedAndRotated();
                break;
            }
            case COLUMN: {
                displayer = ((C3BarChartDisplayer)((Object)this.beanManager.lookupBean(C3BarChartDisplayer.class, new Annotation[0]).newInstance())).notRotated();
                break;
            }
            case COLUMN_STACKED: {
                displayer = ((C3BarChartDisplayer)((Object)this.beanManager.lookupBean(C3BarChartDisplayer.class, new Annotation[0]).newInstance())).stacked();
                break;
            }
            default: {
                displayer = ((C3BarChartDisplayer)((Object)this.beanManager.lookupBean(C3BarChartDisplayer.class, new Annotation[0]).newInstance())).rotated();
            }
        }
        return displayer;
    }

    private C3Displayer getLineChartForSubType(DisplayerSubType subtype) {
        C3LineChartDisplayer displayer = (C3LineChartDisplayer)((Object)this.beanManager.lookupBean(C3LineChartDisplayer.class, new Annotation[0]).newInstance());
        if (subtype == DisplayerSubType.SMOOTH) {
            displayer = displayer.smooth();
        }
        return displayer;
    }

    private C3Displayer getPieChartForSubType(DisplayerSubType subtype) {
        C3PieChartDisplayer displayer = (C3PieChartDisplayer)((Object)this.beanManager.lookupBean(C3PieChartDisplayer.class, new Annotation[0]).newInstance());
        if (subtype == DisplayerSubType.DONUT) {
            displayer = displayer.donut();
        }
        return displayer;
    }

    private C3Displayer getAreaChartForSubType(DisplayerSubType subtype) {
        C3AreaChartDisplayer areaChartDisplayer = (C3AreaChartDisplayer)((Object)this.beanManager.lookupBean(C3AreaChartDisplayer.class, new Annotation[0]).newInstance());
        if (subtype == DisplayerSubType.AREA_STACKED) {
            areaChartDisplayer = areaChartDisplayer.stacked();
        }
        return areaChartDisplayer;
    }

    public List<DisplayerType> getSupportedTypes() {
        return SUPPORTED_TYPES;
    }

    public boolean isDefault(DisplayerType type) {
        return SUPPORTED_TYPES.contains(type);
    }
}

