/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.renderer.c3.client.charts.map.widgets;

import elemental2.dom.DomGlobal;
import elemental2.dom.Element;
import elemental2.dom.HTMLDivElement;
import elemental2.dom.HTMLElement;
import elemental2.dom.Node;
import java.util.IntSummaryStatistics;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.dashbuilder.displayer.MapColorScheme;
import org.dashbuilder.renderer.c3.client.charts.map.D3MapConf;
import org.dashbuilder.renderer.c3.client.charts.map.geojson.CountriesGeoJsonService;
import org.dashbuilder.renderer.c3.client.charts.map.widgets.MapTooltip;
import org.dashbuilder.renderer.c3.client.jsbinding.d3.D3PathGenerator;
import org.dashbuilder.renderer.c3.client.jsbinding.d3.D3Projection;
import org.dashbuilder.renderer.c3.client.jsbinding.geojson.Feature;
import org.jboss.errai.common.client.api.elemental2.IsElement;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.uberfire.client.views.pfly.widgets.D3;

@Templated
@Dependent
public class D3Map
implements IsElement {
    private static final int D3_COLOR_SCHEME_TOTAL = 7;
    private static final int RADIUS_PROPORTION = 20;
    private static final int MIN_RADIUS = 2;
    private int width;
    private int height;
    private D3MapConf conf;
    private D3.Scale colorScale;
    private CountriesGeoJsonService countriesGeoJsonService;
    private Map<String, Double> data;
    @Inject
    private MapTooltip mapTooltip;
    @Inject
    private HTMLDivElement mapContainer;
    D3 d3 = D3.Builder.get();
    private String[] colorsScheme;

    @PostConstruct
    public void init() {
        this.addTooltipElement();
    }

    public HTMLElement getElement() {
        return this.mapContainer;
    }

    public void generateMap(int width, int height, D3MapConf conf) {
        this.mapContainer.innerHTML = "";
        this.width = width;
        this.height = height;
        this.conf = conf;
        this.countriesGeoJsonService = conf.getCountriesGeoJsonService();
        this.data = conf.getData();
        this.colorsScheme = this.getScheme(conf.getColorScheme())[7];
        Element mapSVG = DomGlobal.document.createElementNS("http://www.w3.org/2000/svg", "svg");
        D3.Selection d3Selection = this.d3.select((Object)mapSVG);
        D3PathGenerator pathGenerator = this.createPathGenerator();
        IntSummaryStatistics statistics = this.data.values().stream().mapToInt(v -> v.intValue()).summaryStatistics();
        Object[] domain = new Integer[]{statistics.getMin(), statistics.getMax()};
        this.colorScale = this.d3.scaleQuantize().domain(domain).range((Object[])this.colorsScheme);
        D3 map = this.createMap(d3Selection, pathGenerator);
        if (conf.isRegions()) {
            this.fillRegions(map);
        }
        if (conf.isMarkers()) {
            this.addMarkers(d3Selection, pathGenerator);
        }
        if (conf.isShowLegend()) {
            this.createLegend((D3)d3Selection);
        }
        this.mapContainer.appendChild((Node)mapSVG);
    }

    private String[][] getScheme(MapColorScheme colorScheme) {
        switch (colorScheme) {
            case BLUE: {
                return this.d3.getSchemeBlues();
            }
            case GREEN: {
                return this.d3.getSchemeGreens();
            }
            case RED: {
                return this.d3.getSchemeReds();
            }
        }
        return this.d3.getSchemeGreens();
    }

    private D3 createMap(D3.Selection d3Selection, D3PathGenerator pathGenerator) {
        Object[] countriesFeatures = this.countriesGeoJsonService.getCountries();
        return d3Selection.attr("width", (Object)this.width).attr("height", (Object)this.height).style("background", (Object)this.conf.getBackgroundColor()).append("g").attr("class", (Object)"countries").selectAll("path").data(countriesFeatures).enter().append("path").attr("d", (Object)pathGenerator);
    }

    private void createLegend(D3 d3Selection) {
        int titleSize = 5;
        int legendSquareSize = 12;
        int legendSize = titleSize + legendSquareSize * this.colorsScheme.length;
        AtomicInteger rectPos = new AtomicInteger();
        AtomicInteger textPos = new AtomicInteger(legendSquareSize);
        String translate = "translate(0, " + (this.height - legendSize - 2) + ")";
        D3 legendGroup = d3Selection.append("g").attr("transform", (Object)translate);
        legendGroup.append("text").attr("class", (Object)"map-legend-caption").attr("x", (Object)0).attr("y", (Object)(titleSize * -1)).text(this.conf.getTitle());
        D3 legendValuesGroup = legendGroup.append("g");
        legendValuesGroup.selectAll("rect").data(this.colorScale.range()).enter().append("rect").attr("height", (Object)legendSquareSize).attr("width", (Object)legendSquareSize).attr("y", (d, i, el) -> rectPos.getAndAdd(legendSquareSize)).attr("fill", (d, i, el) -> d).append("svg:title").text((d, i, el) -> String.join((CharSequence)" - ", this.getFormattedBoundaryValues(d)));
        legendValuesGroup.selectAll("text").data(this.colorScale.range()).enter().append("text").attr("class", (Object)"map-legend-val").attr("x", (Object)(legendSquareSize + 2)).attr("y", (d, i, el) -> textPos.getAndAdd(legendSquareSize)).text((d, i, el) -> this.buildLegendValue(d, i));
    }

    private void fillRegions(D3 map) {
        Feature[] countriesFeatures = this.countriesGeoJsonService.getCountries();
        map.style("fill", (d, i, el) -> {
            Optional<Double> val = this.countriesGeoJsonService.findValue(this.data, countriesFeatures[i]);
            this.d3.select((Object)el[i]).attr("class", (Object)"fill-region");
            if (val.isPresent()) {
                return this.colorScale.call(this.colorScale, new Object[]{val.get()});
            }
            return null;
        }).on("mouseenter", (d, i, el) -> {
            Optional<Double> val = this.countriesGeoJsonService.findValue(this.data, countriesFeatures[i]);
            String countryName = this.countriesGeoJsonService.getCountryName(countriesFeatures[i]);
            this.mapTooltip.show(countryName, this.conf.getTitle(), val, this.conf.getFormatter());
            return null;
        }).on("mousemove", (d, i, el) -> {
            this.mapTooltip.move();
            return null;
        }).on("mouseleave", (d, i, el) -> {
            this.mapTooltip.hide();
            return null;
        }).on("click", (d, i, el) -> {
            this.countriesGeoJsonService.findEntry(this.data, countriesFeatures[i]).ifPresent(v -> this.conf.getPathClickHandler().accept((String)v.getKey()));
            return null;
        });
    }

    private void addMarkers(D3.Selection d3Selection, D3PathGenerator pathGenerator) {
        int maxRadius = this.width / 20;
        if (maxRadius < 2) {
            maxRadius = 3;
        }
        D3.Scale radiusScale = this.d3.scaleSqrt().domain(this.colorScale.domain()).range((Object[])new Integer[]{2, maxRadius});
        Object[] countriesNames = this.data.keySet().toArray();
        d3Selection.append("g").selectAll("circle").data(countriesNames).enter().append("circle").attr("class", (Object)"data-circle").style("fill", (d, i, el) -> {
            double val = this.data.get(d);
            return this.colorScale.call(this.colorScale, new Object[]{val});
        }).attr("r", (d, i, el) -> {
            Optional<Feature> path = this.countriesGeoJsonService.findCountry((String)d);
            if (path.isPresent()) {
                double val = this.data.get(d);
                return radiusScale.call(radiusScale, new Object[]{val});
            }
            return 0;
        }).attr("transform", (d, i, el) -> {
            String translate = "";
            Optional<Feature> path = this.countriesGeoJsonService.findCountry((String)d);
            if (path.isPresent()) {
                double[] center = pathGenerator.centroid(path.get());
                translate = "translate(" + center[0] + ", " + center[1] + ")";
            }
            return translate;
        }).on("mouseenter", (d, i, el) -> {
            Optional<Double> valOp = Optional.ofNullable(this.data.get(d));
            this.mapTooltip.show((String)d, this.conf.getTitle(), valOp, this.conf.getFormatter());
            return null;
        }).on("mousemove", (d, i, el) -> {
            this.mapTooltip.move();
            return null;
        }).on("mouseleave", (d, i, el) -> {
            this.mapTooltip.hide();
            return null;
        }).on("click", (d, i, el) -> {
            this.conf.getPathClickHandler().accept((String)d);
            return null;
        });
    }

    private D3PathGenerator createPathGenerator() {
        double w = this.width;
        double h = this.height;
        D3Projection projection = D3Projection.Builder.get().geoNaturalEarth2().scale(w / 5.5).translate(new double[]{w / 2.0, h / 2.0});
        return D3PathGenerator.Builder.get().geoPath().projection(projection);
    }

    private void addTooltipElement() {
        boolean elementNotAdded;
        HTMLElement tooltipElement = this.mapTooltip.getElement();
        boolean bl = elementNotAdded = DomGlobal.document.getElementById(tooltipElement.id) == null;
        if (elementNotAdded) {
            DomGlobal.document.body.appendChild((Node)tooltipElement);
        }
    }

    private String buildLegendValue(Object d, int index) {
        String[] values = this.getFormattedBoundaryValues(d);
        int totalLegendColors = this.colorScale.range().length;
        if (values[0].equals(values[1])) {
            return values[0];
        }
        if (index + 1 == totalLegendColors) {
            return "> " + values[0];
        }
        return "< " + values[1];
    }

    private String[] getFormattedBoundaryValues(Object color) {
        Object[] values = this.colorScale.invertExtent(color);
        String minStr = String.valueOf(values[0]);
        String maxStr = String.valueOf(values[1]);
        double max = Double.parseDouble(maxStr);
        double min = Double.parseDouble(minStr);
        return new String[]{this.conf.getFormatter().apply(min), this.conf.getFormatter().apply(max)};
    }
}

