/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.renderer.c3.client.charts.map.geojson.impl;

import java.util.HashMap;
import java.util.Optional;
import jsinterop.base.JsPropertyMap;
import org.dashbuilder.renderer.c3.client.charts.map.geojson.GeoJsonLoader;
import org.dashbuilder.renderer.c3.client.charts.map.geojson.impl.CountriesGeoJsonServiceImpl;
import org.dashbuilder.renderer.c3.client.jsbinding.geojson.Feature;
import org.dashbuilder.renderer.c3.client.jsbinding.geojson.FeatureCollection;
import org.dashbuilder.renderer.c3.client.jsbinding.geojson.Geometry;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.uberfire.client.views.pfly.widgets.D3;

@RunWith(value=MockitoJUnitRunner.class)
public class CountriesGeoJsonServiceImplTest {
    private static final String COUNTRY_LOCATION = "2.0, 1.0";
    private static final Double[] LONG_LAT = new Double[]{1.0, 2.0};
    private static final String COUNTRY_CODE = "ID";
    private static final String COUNTRY_NAME = "Name";
    @Mock
    GeoJsonLoader geoJsonLoader;
    @Mock
    JsPropertyMap<Object> properties;
    @Mock
    Feature feature;
    @Mock
    FeatureCollection featureCollection;
    @Mock
    Geometry geometry;
    @Mock
    D3 d3;
    @InjectMocks
    CountriesGeoJsonServiceImpl countriesGeoJsonServiceImpl;

    @Before
    public void setup() {
        Mockito.when((Object)this.properties.get("name")).thenReturn((Object)COUNTRY_NAME);
        Mockito.when((Object)this.feature.getProperties()).thenReturn(this.properties);
        Mockito.when((Object)this.feature.getId()).thenReturn((Object)COUNTRY_CODE);
        Mockito.when((Object)this.featureCollection.getFeatures()).thenReturn((Object)new Feature[]{this.feature});
    }

    @Test
    public void getCountryNameTest() {
        String countryName = this.countriesGeoJsonServiceImpl.getCountryName(this.feature);
        Assert.assertEquals((Object)COUNTRY_NAME, (Object)countryName);
        countryName = this.countriesGeoJsonServiceImpl.getCountryName(null);
        Assert.assertTrue((boolean)countryName.isEmpty());
    }

    @Test
    public void getCountryNameByCodeTest() {
        String countryName = this.countriesGeoJsonServiceImpl.getCountryNameByCode(COUNTRY_CODE);
        Assert.assertEquals((Object)COUNTRY_NAME, (Object)countryName);
        countryName = this.countriesGeoJsonServiceImpl.getCountryNameByCode("123");
        Assert.assertTrue((boolean)countryName.isEmpty());
        countryName = this.countriesGeoJsonServiceImpl.getCountryNameByCode(null);
        Assert.assertTrue((boolean)countryName.isEmpty());
    }

    @Test
    public void countryByIdOrNameTest() {
        Optional countryByIdOrName = this.countriesGeoJsonServiceImpl.countryByIdOrName(COUNTRY_CODE);
        Assert.assertTrue((boolean)countryByIdOrName.isPresent());
        Assert.assertEquals((Object)this.feature, countryByIdOrName.get());
        countryByIdOrName = this.countriesGeoJsonServiceImpl.countryByIdOrName(COUNTRY_NAME);
        Assert.assertTrue((boolean)countryByIdOrName.isPresent());
        Assert.assertEquals((Object)this.feature, countryByIdOrName.get());
        countryByIdOrName = this.countriesGeoJsonServiceImpl.countryByIdOrName("123");
        Assert.assertTrue((!countryByIdOrName.isPresent() ? 1 : 0) != 0);
    }

    @Test
    public void entryByCountryTest() {
        HashMap<String, Double> data = new HashMap<String, Double>();
        data.put(COUNTRY_NAME, 1.0);
        Optional entryByCountry = this.countriesGeoJsonServiceImpl.entryByCountry(data, this.feature);
        Assert.assertTrue((boolean)entryByCountry.isPresent());
        entryByCountry = this.countriesGeoJsonServiceImpl.entryByCountry(data, null);
        Assert.assertTrue((!entryByCountry.isPresent() ? 1 : 0) != 0);
        entryByCountry = this.countriesGeoJsonServiceImpl.entryByCountry(new HashMap(), this.feature);
        Assert.assertTrue((!entryByCountry.isPresent() ? 1 : 0) != 0);
    }

    @Test
    public void valueByCountryTest() {
        Double val = 1.0;
        HashMap<String, Double> data = new HashMap<String, Double>();
        data.put(COUNTRY_NAME, val);
        Optional valueByCountry = this.countriesGeoJsonServiceImpl.valueByCountry(data, this.feature);
        Assert.assertTrue((boolean)valueByCountry.isPresent());
        Assert.assertEquals((Object)val, valueByCountry.get());
        valueByCountry = this.countriesGeoJsonServiceImpl.valueByCountry(data, null);
        Assert.assertFalse((boolean)valueByCountry.isPresent());
        valueByCountry = this.countriesGeoJsonServiceImpl.valueByCountry(new HashMap(), null);
        Assert.assertFalse((boolean)valueByCountry.isPresent());
    }

    @Test
    public void entryByLocationTest() {
        Mockito.when((Object)this.d3.geoContains(ArgumentMatchers.any(), (Double[])ArgumentMatchers.any())).thenReturn((Object)true);
        HashMap<String, Double> data = new HashMap<String, Double>();
        data.put(COUNTRY_LOCATION, 1.0);
        Optional entryByLocation = this.countriesGeoJsonServiceImpl.entriesByLocation(data, this.feature).findFirst();
        Assert.assertTrue((boolean)entryByLocation.isPresent());
        ((D3)Mockito.verify((Object)this.d3)).geoContains(ArgumentMatchers.any(), (Double[])ArgumentMatchers.any());
        Mockito.when((Object)this.d3.geoContains(ArgumentMatchers.any(), (Double[])ArgumentMatchers.any())).thenReturn((Object)false);
        entryByLocation = this.countriesGeoJsonServiceImpl.entriesByLocation(data, null).findFirst();
        Assert.assertFalse((boolean)entryByLocation.isPresent());
        entryByLocation = this.countriesGeoJsonServiceImpl.entriesByLocation(new HashMap(), this.feature).findFirst();
        Assert.assertFalse((boolean)entryByLocation.isPresent());
        Mockito.when((Object)this.d3.geoContains(ArgumentMatchers.any(), (Double[])ArgumentMatchers.any())).thenReturn((Object)false);
        entryByLocation = this.countriesGeoJsonServiceImpl.entriesByLocation(data, this.feature).findFirst();
        Assert.assertFalse((boolean)entryByLocation.isPresent());
    }

    @Test
    public void valueByLocationTest() {
        Mockito.when((Object)this.d3.geoContains(ArgumentMatchers.any(), (Double[])ArgumentMatchers.any())).thenReturn((Object)true);
        Double val = 1.0;
        HashMap<String, Double> data = new HashMap<String, Double>();
        data.put(COUNTRY_LOCATION, val);
        Optional valueByLocation = this.countriesGeoJsonServiceImpl.valueByLocation(data, this.feature);
        Assert.assertTrue((boolean)valueByLocation.isPresent());
        Assert.assertEquals((Object)val, valueByLocation.get());
        ((D3)Mockito.verify((Object)this.d3)).geoContains((Object)this.feature, LONG_LAT);
        Mockito.when((Object)this.d3.geoContains(ArgumentMatchers.any(), (Double[])ArgumentMatchers.any())).thenReturn((Object)false);
        valueByLocation = this.countriesGeoJsonServiceImpl.valueByLocation(data, null);
        Assert.assertFalse((boolean)valueByLocation.isPresent());
        valueByLocation = this.countriesGeoJsonServiceImpl.valueByLocation(new HashMap(), null);
        Assert.assertFalse((boolean)valueByLocation.isPresent());
    }

    @Test
    public void findCountryWithLocationTest() {
        Mockito.when((Object)this.d3.geoContains(ArgumentMatchers.any(), (Double[])ArgumentMatchers.any())).thenReturn((Object)true);
        HashMap<String, Double> data = new HashMap<String, Double>();
        data.put(COUNTRY_LOCATION, 1.0);
        Optional findCountry = this.countriesGeoJsonServiceImpl.findCountry(COUNTRY_LOCATION);
        Assert.assertTrue((boolean)findCountry.isPresent());
        Assert.assertEquals((Object)COUNTRY_CODE, (Object)((Feature)findCountry.get()).getId());
        Assert.assertEquals((Object)COUNTRY_NAME, (Object)this.countriesGeoJsonServiceImpl.getCountryName((Feature)findCountry.get()));
        ((D3)Mockito.verify((Object)this.d3)).geoContains((Object)this.feature, LONG_LAT);
    }

    @Test
    public void findCountryWithCountryNameTest() {
        HashMap<String, Double> data = new HashMap<String, Double>();
        data.put(COUNTRY_NAME, 1.0);
        Optional findCountry = this.countriesGeoJsonServiceImpl.findCountry(COUNTRY_NAME);
        Assert.assertTrue((boolean)findCountry.isPresent());
        Assert.assertEquals((Object)COUNTRY_CODE, (Object)((Feature)findCountry.get()).getId());
        Assert.assertEquals((Object)COUNTRY_NAME, (Object)this.countriesGeoJsonServiceImpl.getCountryName((Feature)findCountry.get()));
        ((D3)Mockito.verify((Object)this.d3, (VerificationMode)Mockito.times((int)0))).geoContains(ArgumentMatchers.any(), (Double[])ArgumentMatchers.any());
    }
}

