/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.renderer.c3.client;

import java.lang.annotation.Annotation;
import org.dashbuilder.displayer.DisplayerSettings;
import org.dashbuilder.displayer.DisplayerSubType;
import org.dashbuilder.displayer.DisplayerType;
import org.dashbuilder.renderer.c3.client.C3Renderer;
import org.dashbuilder.renderer.c3.client.charts.area.C3AreaChartDisplayer;
import org.dashbuilder.renderer.c3.client.charts.bar.C3BarChartDisplayer;
import org.dashbuilder.renderer.c3.client.charts.bubble.C3BubbleChartDisplayer;
import org.dashbuilder.renderer.c3.client.charts.line.C3LineChartDisplayer;
import org.dashbuilder.renderer.c3.client.charts.meter.C3MeterChartDisplayer;
import org.dashbuilder.renderer.c3.client.charts.pie.C3PieChartDisplayer;
import org.jboss.errai.ioc.client.container.SyncBeanDef;
import org.jboss.errai.ioc.client.container.SyncBeanManager;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class C3RendererTest {
    @Mock
    SyncBeanManager beanManager;
    @InjectMocks
    C3Renderer renderer;
    @Mock
    private SyncBeanDef<C3AreaChartDisplayer> areaChartDisplayerBeanDef;
    @Mock
    private SyncBeanDef<C3BarChartDisplayer> barChartDisplayerBeanDef;
    @Mock
    private SyncBeanDef<C3LineChartDisplayer> lineChartDisplayerBeanDef;
    @Mock
    private SyncBeanDef<C3PieChartDisplayer> pieChartDisplayerBeanDef;
    @Mock
    private SyncBeanDef<C3BubbleChartDisplayer> bubbleChartDisplayerBeanDef;
    @Mock
    private SyncBeanDef<C3MeterChartDisplayer> meterChartDisplayerBeanDef;
    @Mock
    private C3AreaChartDisplayer c3AreaChartDisplayer;
    @Mock
    private C3BarChartDisplayer c3BarChartDisplayer;
    @Mock
    private C3LineChartDisplayer c3LineChartDisplayer;
    @Mock
    private C3PieChartDisplayer c3PieChartDisplayer;
    @Mock
    private C3BubbleChartDisplayer c3BubbleChartDisplayer;
    @Mock
    private C3MeterChartDisplayer c3MeterChartDisplayer;
    private DisplayerSettings settings;

    @Before
    public void prepareTypes() {
        Mockito.when((Object)this.beanManager.lookupBean(C3AreaChartDisplayer.class, new Annotation[0])).thenReturn(this.areaChartDisplayerBeanDef);
        Mockito.when((Object)((C3AreaChartDisplayer)this.areaChartDisplayerBeanDef.newInstance())).thenReturn((Object)this.c3AreaChartDisplayer);
        Mockito.when((Object)this.beanManager.lookupBean(C3BarChartDisplayer.class, new Annotation[0])).thenReturn(this.barChartDisplayerBeanDef);
        Mockito.when((Object)((C3BarChartDisplayer)this.barChartDisplayerBeanDef.newInstance())).thenReturn((Object)this.c3BarChartDisplayer);
        Mockito.when((Object)this.beanManager.lookupBean(C3LineChartDisplayer.class, new Annotation[0])).thenReturn(this.lineChartDisplayerBeanDef);
        Mockito.when((Object)((C3LineChartDisplayer)this.lineChartDisplayerBeanDef.newInstance())).thenReturn((Object)this.c3LineChartDisplayer);
        Mockito.when((Object)this.beanManager.lookupBean(C3PieChartDisplayer.class, new Annotation[0])).thenReturn(this.pieChartDisplayerBeanDef);
        Mockito.when((Object)((C3PieChartDisplayer)this.pieChartDisplayerBeanDef.newInstance())).thenReturn((Object)this.c3PieChartDisplayer);
        Mockito.when((Object)this.beanManager.lookupBean(C3BubbleChartDisplayer.class, new Annotation[0])).thenReturn(this.bubbleChartDisplayerBeanDef);
        Mockito.when((Object)((C3BubbleChartDisplayer)this.bubbleChartDisplayerBeanDef.newInstance())).thenReturn((Object)this.c3BubbleChartDisplayer);
        Mockito.when((Object)this.beanManager.lookupBean(C3MeterChartDisplayer.class, new Annotation[0])).thenReturn(this.meterChartDisplayerBeanDef);
        Mockito.when((Object)((C3MeterChartDisplayer)this.meterChartDisplayerBeanDef.newInstance())).thenReturn((Object)this.c3MeterChartDisplayer);
        this.settings = (DisplayerSettings)Mockito.mock(DisplayerSettings.class);
    }

    @Test
    public void lookupAreaChartTest() {
        Mockito.when((Object)this.settings.getType()).thenReturn((Object)DisplayerType.AREACHART);
        Mockito.when((Object)this.settings.getSubtype()).thenReturn((Object)DisplayerSubType.AREA_STACKED);
        this.renderer.lookupDisplayer(this.settings);
        ((C3AreaChartDisplayer)Mockito.verify((Object)this.c3AreaChartDisplayer)).stacked();
    }

    @Test
    public void lookupBarChartColumnStacked() {
        Mockito.when((Object)this.settings.getType()).thenReturn((Object)DisplayerType.BARCHART);
        Mockito.when((Object)this.settings.getSubtype()).thenReturn((Object)DisplayerSubType.COLUMN_STACKED);
        this.renderer.lookupDisplayer(this.settings);
        ((C3BarChartDisplayer)Mockito.verify((Object)this.c3BarChartDisplayer)).stacked();
    }

    @Test
    public void lookuBarChartColumn() {
        Mockito.when((Object)this.settings.getType()).thenReturn((Object)DisplayerType.BARCHART);
        Mockito.when((Object)this.settings.getSubtype()).thenReturn((Object)DisplayerSubType.COLUMN);
        this.renderer.lookupDisplayer(this.settings);
        ((C3BarChartDisplayer)Mockito.verify((Object)this.c3BarChartDisplayer)).notRotated();
    }

    @Test
    public void lookupBarChartStacked() {
        Mockito.when((Object)this.settings.getType()).thenReturn((Object)DisplayerType.BARCHART);
        Mockito.when((Object)this.settings.getSubtype()).thenReturn((Object)DisplayerSubType.BAR_STACKED);
        this.renderer.lookupDisplayer(this.settings);
        ((C3BarChartDisplayer)Mockito.verify((Object)this.c3BarChartDisplayer)).stackedAndRotated();
    }

    @Test
    public void lookupBarChartBar() {
        Mockito.when((Object)this.settings.getType()).thenReturn((Object)DisplayerType.BARCHART);
        Mockito.when((Object)this.settings.getSubtype()).thenReturn((Object)DisplayerSubType.BAR);
        this.renderer.lookupDisplayer(this.settings);
        ((C3BarChartDisplayer)Mockito.verify((Object)this.c3BarChartDisplayer)).rotated();
    }

    @Test
    public void lookupLineChart() {
        Mockito.when((Object)this.settings.getType()).thenReturn((Object)DisplayerType.LINECHART);
        Mockito.when((Object)this.settings.getSubtype()).thenReturn((Object)DisplayerSubType.LINE);
        this.renderer.lookupDisplayer(this.settings);
        ((C3LineChartDisplayer)Mockito.verify((Object)this.c3LineChartDisplayer, (VerificationMode)Mockito.times((int)0))).smooth();
    }

    @Test
    public void lookupLineChartSmooth() {
        Mockito.when((Object)this.settings.getType()).thenReturn((Object)DisplayerType.LINECHART);
        Mockito.when((Object)this.settings.getSubtype()).thenReturn((Object)DisplayerSubType.SMOOTH);
        this.renderer.lookupDisplayer(this.settings);
        ((C3LineChartDisplayer)Mockito.verify((Object)this.c3LineChartDisplayer)).smooth();
    }

    @Test
    public void lookupPieChart() {
        Mockito.when((Object)this.settings.getType()).thenReturn((Object)DisplayerType.PIECHART);
        Mockito.when((Object)this.settings.getSubtype()).thenReturn((Object)DisplayerSubType.PIE);
        this.renderer.lookupDisplayer(this.settings);
        ((C3PieChartDisplayer)Mockito.verify((Object)this.c3PieChartDisplayer, (VerificationMode)Mockito.times((int)0))).donut();
    }

    @Test
    public void lookupPieChartDonut() {
        Mockito.when((Object)this.settings.getType()).thenReturn((Object)DisplayerType.PIECHART);
        Mockito.when((Object)this.settings.getSubtype()).thenReturn((Object)DisplayerSubType.DONUT);
        this.renderer.lookupDisplayer(this.settings);
        ((C3PieChartDisplayer)Mockito.verify((Object)this.c3PieChartDisplayer)).donut();
    }

    @Test
    public void lookupBubbleChart() {
        Mockito.when((Object)this.settings.getType()).thenReturn((Object)DisplayerType.BUBBLECHART);
        this.renderer.lookupDisplayer(this.settings);
        ((SyncBeanDef)Mockito.verify(this.bubbleChartDisplayerBeanDef)).newInstance();
    }

    @Test
    public void lookupMeterChart() {
        Mockito.when((Object)this.settings.getType()).thenReturn((Object)DisplayerType.METERCHART);
        this.renderer.lookupDisplayer(this.settings);
        ((SyncBeanDef)Mockito.verify(this.meterChartDisplayerBeanDef)).newInstance();
    }
}

