/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.renderer.google.client;

import com.googlecode.gwt.charts.client.ChartPackage;
import com.googlecode.gwt.charts.client.ColumnType;
import com.googlecode.gwt.charts.client.DataTable;
import com.googlecode.gwt.charts.client.format.DateFormat;
import com.googlecode.gwt.charts.client.format.DateFormatOptions;
import com.googlecode.gwt.charts.client.format.NumberFormat;
import com.googlecode.gwt.charts.client.format.NumberFormatOptions;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.dashbuilder.dataset.DataColumn;
import org.dashbuilder.displayer.ColumnSettings;
import org.dashbuilder.displayer.client.AbstractDisplayer;
import org.dashbuilder.displayer.client.Displayer;
import org.dashbuilder.renderer.google.client.GoogleRenderer;

public abstract class GoogleDisplayer
extends AbstractDisplayer {
    protected GoogleRenderer googleRenderer;
    protected DataTable googleTable = null;

    public GoogleDisplayer setRenderer(GoogleRenderer googleRenderer) {
        this.googleRenderer = googleRenderer;
        return this;
    }

    public void draw() {
        if (this.googleRenderer == null) {
            this.afterError("Google renderer not set");
        } else if (!this.isDrawn()) {
            ArrayList<Displayer> displayerList = new ArrayList<Displayer>();
            displayerList.add((Displayer)this);
            this.googleRenderer.draw(displayerList);
        }
    }

    void ready() {
        super.draw();
    }

    protected abstract ChartPackage getPackage();

    public DataTable createTable() {
        DataColumn dataColumn;
        int i;
        this.googleTable = DataTable.create();
        this.googleTable.addRows(this.dataSet.getRowCount());
        List columns = this.dataSet.getColumns();
        for (i = 0; i < columns.size(); ++i) {
            dataColumn = (DataColumn)columns.get(i);
            String columnId = dataColumn.getId();
            org.dashbuilder.dataset.ColumnType columnType = dataColumn.getColumnType();
            ColumnSettings columnSettings = this.displayerSettings.getColumnSettings(dataColumn);
            this.googleTable.addColumn(this.getColumnType(dataColumn), columnSettings.getColumnName(), columnId);
            List columnValues = dataColumn.getValues();
            for (int j = 0; j < columnValues.size(); ++j) {
                Object value = columnValues.get(j);
                if (org.dashbuilder.dataset.ColumnType.DATE.equals((Object)columnType)) {
                    if (value == null) {
                        this.googleTable.setValue(j, i, new Date());
                        continue;
                    }
                    this.googleTable.setValue(j, i, (Date)value);
                    continue;
                }
                if (org.dashbuilder.dataset.ColumnType.NUMBER.equals((Object)columnType)) {
                    if (value == null) {
                        this.googleTable.setValue(j, i, 0.0);
                        continue;
                    }
                    value = super.applyExpression(value.toString(), columnSettings.getValueExpression());
                    this.googleTable.setValue(j, i, Double.parseDouble(value.toString()));
                    continue;
                }
                value = super.formatValue(value, dataColumn);
                this.googleTable.setValue(j, i, value.toString());
            }
        }
        for (i = 0; i < this.googleTable.getNumberOfColumns(); ++i) {
            dataColumn = (DataColumn)columns.get(i);
            ColumnType type = this.googleTable.getColumnType(i);
            ColumnSettings columnSettings = this.displayerSettings.getColumnSettings(dataColumn);
            String pattern = columnSettings.getValuePattern();
            if (ColumnType.DATE.equals((Object)type)) {
                DateFormatOptions dateFormatOptions = DateFormatOptions.create();
                dateFormatOptions.setPattern(pattern);
                DateFormat dateFormat = DateFormat.create((DateFormatOptions)dateFormatOptions);
                dateFormat.format(this.googleTable, i);
                continue;
            }
            if (!ColumnType.NUMBER.equals((Object)type)) continue;
            NumberFormatOptions numberFormatOptions = NumberFormatOptions.create();
            numberFormatOptions.setPattern(pattern);
            NumberFormat numberFormat = NumberFormat.create((NumberFormatOptions)numberFormatOptions);
            numberFormat.format(this.googleTable, i);
        }
        return this.googleTable;
    }

    public ColumnType getColumnType(DataColumn dataColumn) {
        org.dashbuilder.dataset.ColumnType type = dataColumn.getColumnType();
        if (org.dashbuilder.dataset.ColumnType.LABEL.equals((Object)type)) {
            return ColumnType.STRING;
        }
        if (org.dashbuilder.dataset.ColumnType.TEXT.equals((Object)type)) {
            return ColumnType.STRING;
        }
        if (org.dashbuilder.dataset.ColumnType.NUMBER.equals((Object)type)) {
            return ColumnType.NUMBER;
        }
        if (org.dashbuilder.dataset.ColumnType.DATE.equals((Object)type)) {
            return ColumnType.DATE;
        }
        return ColumnType.STRING;
    }
}

