/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.renderer.google.client;

import org.dashbuilder.dataset.ColumnType;
import org.dashbuilder.dataset.filter.ColumnFilter;
import org.dashbuilder.dataset.filter.FilterFactory;
import org.dashbuilder.dataset.group.AggregateFunctionType;
import org.dashbuilder.dataset.sort.SortOrder;
import org.dashbuilder.displayer.DisplayerSettings;
import org.dashbuilder.displayer.DisplayerSettingsFactory;
import org.dashbuilder.displayer.impl.BarChartSettingsBuilderImpl;
import org.dashbuilder.renderer.google.client.GoogleBarChartDisplayer;
import org.dashbuilder.renderer.google.client.GoogleDisplayerTest;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class GoogleDisplayerDataTest
extends GoogleDisplayerTest {
    DisplayerSettings byYear = ((BarChartSettingsBuilderImpl)((BarChartSettingsBuilderImpl)((BarChartSettingsBuilderImpl)((BarChartSettingsBuilderImpl)((BarChartSettingsBuilderImpl)((BarChartSettingsBuilderImpl)DisplayerSettingsFactory.newBarChartSettings().dataset("expenses")).group("CREATION_DATE")).column("CREATION_DATE")).column("AMOUNT", AggregateFunctionType.SUM)).filterOn(false, true, true)).sort("CREATION_DATE", SortOrder.ASCENDING)).buildSettings();
    DisplayerSettings noData = ((BarChartSettingsBuilderImpl)((BarChartSettingsBuilderImpl)((BarChartSettingsBuilderImpl)((BarChartSettingsBuilderImpl)((BarChartSettingsBuilderImpl)DisplayerSettingsFactory.newBarChartSettings().dataset("expenses")).filter("EXPENSES_ID", new ColumnFilter[]{FilterFactory.isNull()})).group("CREATION_DATE")).column("CREATION_DATE")).column("AMOUNT", AggregateFunctionType.SUM)).buildSettings();

    @Test
    public void testDataPush() {
        GoogleBarChartDisplayer barChart = this.createBarChartDisplayer(this.byYear);
        barChart.ready();
        GoogleBarChartDisplayer.View view = barChart.getView();
        ((GoogleBarChartDisplayer.View)Mockito.verify((Object)view)).dataClear();
        ((GoogleBarChartDisplayer.View)Mockito.verify((Object)view)).dataAddColumn(ColumnType.LABEL, "CREATION_DATE", "CREATION_DATE");
        ((GoogleBarChartDisplayer.View)Mockito.verify((Object)view)).dataAddColumn((ColumnType)Mockito.eq((Object)ColumnType.NUMBER), Mockito.anyString(), Mockito.anyString());
        ((GoogleBarChartDisplayer.View)Mockito.verify((Object)view)).dataRowCount(4);
        ((GoogleBarChartDisplayer.View)Mockito.verify((Object)view, (VerificationMode)Mockito.times((int)4))).dataSetValue(Mockito.anyInt(), Mockito.anyInt(), Mockito.anyString());
        ((GoogleBarChartDisplayer.View)Mockito.verify((Object)view, (VerificationMode)Mockito.times((int)4))).dataSetValue(Mockito.anyInt(), Mockito.anyInt(), ((Double)Mockito.any(Double.class)).doubleValue());
        ((GoogleBarChartDisplayer.View)Mockito.verify((Object)view)).dataFormatNumberColumn(Mockito.anyString(), Mockito.eq((int)1));
    }

    @Test
    public void testNoData() {
        GoogleBarChartDisplayer barChart = this.createBarChartDisplayer(this.noData);
        barChart.ready();
        GoogleBarChartDisplayer.View view = barChart.getView();
        ((GoogleBarChartDisplayer.View)Mockito.verify((Object)view)).nodata();
        ((GoogleBarChartDisplayer.View)Mockito.verify((Object)view, (VerificationMode)Mockito.never())).dataClear();
        ((GoogleBarChartDisplayer.View)Mockito.verify((Object)view, (VerificationMode)Mockito.never())).dataAddColumn((ColumnType)Mockito.any(ColumnType.class), Mockito.anyString(), Mockito.anyString());
        ((GoogleBarChartDisplayer.View)Mockito.verify((Object)view, (VerificationMode)Mockito.never())).dataRowCount(Mockito.anyInt());
        ((GoogleBarChartDisplayer.View)Mockito.verify((Object)view, (VerificationMode)Mockito.never())).dataSetValue(Mockito.anyInt(), Mockito.anyInt(), Mockito.anyString());
    }
}

