/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.renderer.google.client;

import com.googlecode.gwt.charts.client.ChartLoader;
import com.googlecode.gwt.charts.client.ChartPackage;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.dashbuilder.displayer.DisplayerSettings;
import org.dashbuilder.displayer.DisplayerSubType;
import org.dashbuilder.displayer.DisplayerType;
import org.dashbuilder.displayer.client.AbstractRendererLibrary;
import org.dashbuilder.displayer.client.Displayer;
import org.dashbuilder.renderer.google.client.GoogleAreaChartDisplayer;
import org.dashbuilder.renderer.google.client.GoogleBarChartDisplayer;
import org.dashbuilder.renderer.google.client.GoogleBubbleChartDisplayer;
import org.dashbuilder.renderer.google.client.GoogleDisplayer;
import org.dashbuilder.renderer.google.client.GoogleDisplayerView;
import org.dashbuilder.renderer.google.client.GoogleLineChartDisplayer;
import org.dashbuilder.renderer.google.client.GoogleMapDisplayer;
import org.dashbuilder.renderer.google.client.GoogleMeterChartDisplayer;
import org.dashbuilder.renderer.google.client.GooglePieChartDisplayer;
import org.dashbuilder.renderer.google.client.GoogleTableDisplayer;
import org.jboss.errai.ioc.client.container.SyncBeanManager;

@ApplicationScoped
public class GoogleRenderer
extends AbstractRendererLibrary {
    public static final String UUID = "gwtcharts";
    private static Map<DisplayerType, ChartPackage> _packageTypes = new HashMap<DisplayerType, ChartPackage>();
    private List<DisplayerType> _supportedTypes = Arrays.asList(DisplayerType.BARCHART, DisplayerType.PIECHART, DisplayerType.AREACHART, DisplayerType.LINECHART, DisplayerType.BUBBLECHART, DisplayerType.METERCHART, DisplayerType.TABLE, DisplayerType.MAP);
    @Inject
    protected SyncBeanManager beanManager;

    public String getUUID() {
        return UUID;
    }

    public String getName() {
        return "GWT Charts";
    }

    public List<DisplayerType> getSupportedTypes() {
        return this._supportedTypes;
    }

    public List<DisplayerSubType> getSupportedSubtypes(DisplayerType displayerType) {
        switch (displayerType) {
            case BARCHART: {
                return Arrays.asList(DisplayerSubType.BAR, DisplayerSubType.BAR_STACKED, DisplayerSubType.COLUMN, DisplayerSubType.COLUMN_STACKED);
            }
            case PIECHART: {
                return Arrays.asList(DisplayerSubType.PIE, DisplayerSubType.PIE_3D, DisplayerSubType.DONUT);
            }
            case AREACHART: {
                return Arrays.asList(DisplayerSubType.AREA, DisplayerSubType.AREA_STACKED);
            }
            case LINECHART: {
                return Arrays.asList(DisplayerSubType.LINE, DisplayerSubType.SMOOTH);
            }
            case MAP: {
                return Arrays.asList(DisplayerSubType.MAP_REGIONS, DisplayerSubType.MAP_MARKERS);
            }
        }
        return Arrays.asList(new DisplayerSubType[0]);
    }

    public Displayer lookupDisplayer(DisplayerSettings displayerSettings) {
        GoogleDisplayer displayer;
        DisplayerType displayerType = displayerSettings.getType();
        switch (displayerType) {
            case BARCHART: {
                displayer = (GoogleDisplayer)((Object)this.beanManager.lookupBean(GoogleBarChartDisplayer.class, new Annotation[0]).newInstance());
                break;
            }
            case PIECHART: {
                displayer = (GoogleDisplayer)((Object)this.beanManager.lookupBean(GooglePieChartDisplayer.class, new Annotation[0]).newInstance());
                break;
            }
            case AREACHART: {
                displayer = (GoogleDisplayer)((Object)this.beanManager.lookupBean(GoogleAreaChartDisplayer.class, new Annotation[0]).newInstance());
                break;
            }
            case LINECHART: {
                displayer = (GoogleDisplayer)((Object)this.beanManager.lookupBean(GoogleLineChartDisplayer.class, new Annotation[0]).newInstance());
                break;
            }
            case BUBBLECHART: {
                displayer = (GoogleDisplayer)((Object)this.beanManager.lookupBean(GoogleBubbleChartDisplayer.class, new Annotation[0]).newInstance());
                break;
            }
            case METERCHART: {
                displayer = (GoogleDisplayer)((Object)this.beanManager.lookupBean(GoogleMeterChartDisplayer.class, new Annotation[0]).newInstance());
                break;
            }
            case TABLE: {
                displayer = (GoogleDisplayer)((Object)this.beanManager.lookupBean(GoogleTableDisplayer.class, new Annotation[0]).newInstance());
                break;
            }
            case MAP: {
                displayer = (GoogleDisplayer)((Object)this.beanManager.lookupBean(GoogleMapDisplayer.class, new Annotation[0]).newInstance());
                break;
            }
            default: {
                return null;
            }
        }
        ((GoogleDisplayerView)displayer.getView()).setRenderer(this);
        return displayer;
    }

    public void draw(final List<Displayer> displayerList) {
        EnumSet<ChartPackage> packageList = EnumSet.noneOf(ChartPackage.class);
        for (Displayer displayer : displayerList) {
            try {
                GoogleDisplayer googleDisplayer = (GoogleDisplayer)displayer;
                packageList.add(_packageTypes.get(googleDisplayer.getDisplayerSettings().getType()));
            }
            catch (ClassCastException googleDisplayer) {}
        }
        ChartPackage[] packageArray = new ChartPackage[packageList.size()];
        int i = 0;
        for (ChartPackage pkg : packageList) {
            packageArray[i++] = pkg;
        }
        ChartLoader chartLoader = new ChartLoader(packageArray);
        chartLoader.loadApi(new Runnable(){

            @Override
            public void run() {
                for (Displayer displayer : displayerList) {
                    try {
                        GoogleDisplayer googleDisplayer = (GoogleDisplayer)displayer;
                        googleDisplayer.ready();
                    }
                    catch (ClassCastException classCastException) {}
                }
            }
        });
    }

    public boolean isOffline() {
        return false;
    }

    static {
        _packageTypes.put(DisplayerType.BARCHART, ChartPackage.CORECHART);
        _packageTypes.put(DisplayerType.PIECHART, ChartPackage.CORECHART);
        _packageTypes.put(DisplayerType.AREACHART, ChartPackage.CORECHART);
        _packageTypes.put(DisplayerType.LINECHART, ChartPackage.CORECHART);
        _packageTypes.put(DisplayerType.BUBBLECHART, ChartPackage.CORECHART);
        _packageTypes.put(DisplayerType.METERCHART, ChartPackage.GAUGE);
        _packageTypes.put(DisplayerType.TABLE, ChartPackage.TABLE);
        _packageTypes.put(DisplayerType.MAP, ChartPackage.GEOCHART);
    }
}

