/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.renderer.google.client;

import org.dashbuilder.dataset.filter.ColumnFilter;
import org.dashbuilder.dataset.filter.FilterFactory;
import org.dashbuilder.dataset.sort.SortOrder;
import org.dashbuilder.displayer.DisplayerSettings;
import org.dashbuilder.displayer.DisplayerSettingsFactory;
import org.dashbuilder.displayer.impl.TableDisplayerSettingsBuilderImpl;
import org.dashbuilder.renderer.google.client.GoogleDisplayerTest;
import org.dashbuilder.renderer.google.client.GoogleTableDisplayer;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.Silent.class)
public class GoogleTableDisplayerTest
extends GoogleDisplayerTest {
    @Test
    public void testTableDraw() {
        DisplayerSettings allRows = ((TableDisplayerSettingsBuilderImpl)DisplayerSettingsFactory.newTableSettings().dataset("expenses")).tableOrderDefault("DEPARTMENT", SortOrder.DESCENDING).tableOrderEnabled(true).tablePageSize(10).tableWidth(1000).buildSettings();
        GoogleTableDisplayer table = this.createTableDisplayer(allRows);
        GoogleTableDisplayer.View tableView = table.getView();
        table.ready();
        ((GoogleTableDisplayer.View)Mockito.verify((Object)tableView)).setWidth(1000);
        ((GoogleTableDisplayer.View)Mockito.verify((Object)tableView)).setSortEnabled(true);
        ((GoogleTableDisplayer.View)Mockito.verify((Object)tableView)).setPageSize(10);
        ((GoogleTableDisplayer.View)Mockito.verify((Object)tableView)).setTotalRows(50);
        ((GoogleTableDisplayer.View)Mockito.verify((Object)tableView)).setTotalPages(5);
        ((GoogleTableDisplayer.View)Mockito.verify((Object)tableView)).setPagerEnabled(true);
        ((GoogleTableDisplayer.View)Mockito.verify((Object)tableView)).drawTable();
    }

    @Test
    public void testEmptyTableDraw() {
        DisplayerSettings allRows = ((TableDisplayerSettingsBuilderImpl)((TableDisplayerSettingsBuilderImpl)DisplayerSettingsFactory.newTableSettings().dataset("expenses")).filter("EXPENSES_ID", new ColumnFilter[]{FilterFactory.isNull()})).tablePageSize(10).buildSettings();
        GoogleTableDisplayer table = this.createTableDisplayer(allRows);
        GoogleTableDisplayer.View tableView = table.getView();
        table.ready();
        ((GoogleTableDisplayer.View)Mockito.verify((Object)tableView)).setPageSize(10);
        ((GoogleTableDisplayer.View)Mockito.verify((Object)tableView)).setTotalRows(0);
        ((GoogleTableDisplayer.View)Mockito.verify((Object)tableView)).setTotalPages(1);
        ((GoogleTableDisplayer.View)Mockito.verify((Object)tableView)).setPagerEnabled(false);
        ((GoogleTableDisplayer.View)Mockito.verify((Object)tableView)).nodata();
    }

    @Test
    public void testTablePager() {
        DisplayerSettings allRows = ((TableDisplayerSettingsBuilderImpl)DisplayerSettingsFactory.newTableSettings().dataset("expenses")).tablePageSize(10).buildSettings();
        GoogleTableDisplayer table = this.createTableDisplayer(allRows);
        GoogleTableDisplayer.View tableView = table.getView();
        table.ready();
        ((GoogleTableDisplayer.View)Mockito.verify((Object)tableView)).setPageSize(10);
        ((GoogleTableDisplayer.View)Mockito.verify((Object)tableView)).setTotalRows(50);
        ((GoogleTableDisplayer.View)Mockito.verify((Object)tableView)).setTotalPages(5);
        ((GoogleTableDisplayer.View)Mockito.verify((Object)tableView)).setCurrentPage(1);
        ((GoogleTableDisplayer.View)Mockito.verify((Object)tableView)).setPagerEnabled(true);
        ((GoogleTableDisplayer.View)Mockito.verify((Object)tableView)).drawTable();
        Mockito.reset((Object[])new GoogleTableDisplayer.View[]{tableView});
        table.gotoPage(-1);
        Assert.assertEquals((long)table.getCurrentPage(), (long)1L);
        Mockito.verifyZeroInteractions((Object[])new Object[]{tableView});
        Mockito.reset((Object[])new GoogleTableDisplayer.View[]{tableView});
        table.gotoPage(11);
        Assert.assertEquals((long)table.getCurrentPage(), (long)1L);
        Mockito.verifyZeroInteractions((Object[])new Object[]{tableView});
        Mockito.reset((Object[])new GoogleTableDisplayer.View[]{tableView});
        table.gotoPage(5);
        ((GoogleTableDisplayer.View)Mockito.verify((Object)tableView)).setCurrentPage(5);
        Assert.assertEquals((long)table.getCurrentPage(), (long)5L);
        ((GoogleTableDisplayer.View)Mockito.verify((Object)tableView)).drawTable();
    }

    @Test
    public void testTableSort() {
        DisplayerSettings allRows = ((TableDisplayerSettingsBuilderImpl)DisplayerSettingsFactory.newTableSettings().dataset("expenses")).tablePageSize(10).tableOrderDefault("EXPENSES_ID", SortOrder.DESCENDING).buildSettings();
        GoogleTableDisplayer table = this.createTableDisplayer(allRows);
        GoogleTableDisplayer.View tableView = table.getView();
        table.ready();
        Assert.assertEquals((Object)table.getDataSetHandler().getLastDataSet().getValueAt(0, 0), (Object)50.0);
        allRows.setTableSortEnabled(false);
        table = this.createTableDisplayer(allRows);
        tableView = table.getView();
        table.ready();
        Mockito.reset((Object[])new GoogleTableDisplayer.View[]{tableView});
        table.sortBy("EXPENSES_ID");
        ((GoogleTableDisplayer.View)Mockito.verify((Object)tableView, (VerificationMode)Mockito.never())).drawTable();
        Assert.assertEquals((Object)table.getDataSetHandler().getLastDataSet().getValueAt(0, 0), (Object)50.0);
        allRows.setTableSortEnabled(true);
        table = this.createTableDisplayer(allRows);
        tableView = table.getView();
        table.ready();
        Mockito.reset((Object[])new GoogleTableDisplayer.View[]{tableView});
        table.sortBy("EXPENSES_ID");
        ((GoogleTableDisplayer.View)Mockito.verify((Object)tableView)).setCurrentPage(1);
        ((GoogleTableDisplayer.View)Mockito.verify((Object)tableView)).drawTable();
        Assert.assertEquals((Object)table.getDataSetHandler().getLastDataSet().getValueAt(0, 0), (Object)1.0);
    }
}

