/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.renderer.lienzo.client;

import com.ait.lienzo.charts.client.AbstractChart;
import com.ait.lienzo.charts.client.axis.Axis;
import com.ait.lienzo.charts.client.axis.CategoryAxis;
import com.ait.lienzo.charts.client.axis.NumericAxis;
import com.ait.lienzo.charts.client.resizer.ChartResizeEvent;
import com.ait.lienzo.charts.client.resizer.ChartResizeEventHandler;
import com.ait.lienzo.charts.client.xy.XYChartData;
import com.ait.lienzo.charts.client.xy.XYChartSerie;
import com.ait.lienzo.charts.client.xy.bar.BarChart;
import com.ait.lienzo.charts.client.xy.bar.event.DataReloadedEvent;
import com.ait.lienzo.charts.client.xy.bar.event.DataReloadedEventHandler;
import com.ait.lienzo.charts.client.xy.bar.event.ValueSelectedEvent;
import com.ait.lienzo.charts.client.xy.bar.event.ValueSelectedHandler;
import com.ait.lienzo.charts.shared.core.types.ChartOrientation;
import com.ait.lienzo.client.core.shape.Group;
import com.ait.lienzo.shared.core.types.ColorName;
import com.ait.lienzo.shared.core.types.IColor;
import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.ui.Widget;
import org.dashbuilder.dataset.ColumnType;
import org.dashbuilder.dataset.DataColumn;
import org.dashbuilder.dataset.DataSetLookupConstraints;
import org.dashbuilder.displayer.ColumnSettings;
import org.dashbuilder.displayer.DisplayerAttributeDef;
import org.dashbuilder.displayer.DisplayerAttributeGroupDef;
import org.dashbuilder.displayer.DisplayerConstraints;
import org.dashbuilder.renderer.lienzo.client.LienzoDisplayer;

public class LienzoBarChartDisplayer
extends LienzoDisplayer {
    private static final ColorName[] DEFAULT_SERIE_COLORS = new ColorName[]{ColorName.DEEPSKYBLUE, ColorName.RED, ColorName.YELLOWGREEN};
    protected BarChart chart = null;
    private boolean isConfigured = false;

    @Override
    public AbstractChart createVisualization() {
        XYChartData chartData = this.createChartData();
        this.chart = new BarChart(new DataReloadedEventHandler(){

            public void onDataReloaded(DataReloadedEvent event) {
                GWT.log((String)"LienzoBarChartDisplayer - onDataReloaded");
                LienzoBarChartDisplayer.this.configureBarChart(event.getChart());
            }
        });
        this.chart.setData(chartData);
        return this.chart;
    }

    private void configureBarChart(BarChart chart) {
        if (this.isConfigured) {
            return;
        }
        chart.setOrientation(this.isHorizontal() ? ChartOrientation.HORIZONTAL : ChartOrientation.VERTICAL);
        ((Group)((Group)chart.setX(0.0)).setY(0.0)).setName(this.displayerSettings.getTitle());
        chart.setWidth((double)this.getChartWidth());
        chart.setHeight((double)this.getChartHeight());
        chart.setMarginLeft((double)this.displayerSettings.getChartMarginLeft());
        chart.setMarginRight((double)this.displayerSettings.getChartMarginRight());
        chart.setMarginTop((double)this.displayerSettings.getChartMarginTop());
        chart.setMarginBotom((double)this.displayerSettings.getChartMarginBottom());
        chart.setFontFamily("Verdana");
        chart.setFontStyle("bold");
        chart.setFontSize(8);
        chart.setShowTitle(this.displayerSettings.isTitleVisible());
        chart.setShowCategoriesAxisTitle(false);
        chart.setShowValuesAxisTitle(false);
        chart.setResizable(this.displayerSettings.isResizable());
        chart.setAnimated(true);
        if (this.displayerSettings.isFilterEnabled()) {
            chart.addValueSelectedHandler((ValueSelectedHandler)new BarValueSelectedHandler());
        }
        if (this.displayerSettings.isResizable()) {
            chart.addChartResizeEventHandler(new ChartResizeEventHandler(){

                public void onChartResize(ChartResizeEvent event) {
                    LienzoBarChartDisplayer.this.resizePanel((int)event.getWidth(), (int)event.getHeight());
                }
            });
        }
        CategoryAxis categoryAxis = new CategoryAxis(this.displayerSettings.getXAxisTitle());
        NumericAxis numericAxis = new NumericAxis(this.displayerSettings.getYAxisTitle());
        chart.setCategoriesAxis(categoryAxis);
        chart.setValuesAxis((Axis)numericAxis);
        chart.build();
        this.isConfigured = true;
    }

    protected boolean isHorizontal() {
        return true;
    }

    @Override
    protected void updateVisualization() {
        this.filterPanel.clear();
        Widget filterReset = super.createCurrentSelectionWidget();
        if (filterReset != null) {
            this.filterPanel.add(filterReset);
        }
        if (this.dataSet.getRowCount() == 0) {
            this.mainPanel.add(super.createNoDataMsgPanel());
            this.chart = null;
        } else {
            CategoryAxis categoryAxis = new CategoryAxis(this.displayerSettings.getXAxisTitle());
            this.chart.setCategoriesAxis(categoryAxis);
            XYChartData newData = this.createChartData();
            newData.setCategoryAxisProperty(this.categoriesColumn.getId());
            this.chart.setData(newData);
        }
    }

    protected XYChartData createChartData() {
        XYChartData chartData = new XYChartData(this.lienzoTable);
        DataColumn categoriesColumn = this.getCategoriesColumn();
        DataColumn[] valuesColumns = this.getValuesColumns();
        if (categoriesColumn != null) {
            chartData.setCategoryAxisProperty(categoriesColumn.getId());
            if (valuesColumns != null) {
                for (int i = 0; i < valuesColumns.length; ++i) {
                    DataColumn dataColumn = valuesColumns[i];
                    String columnId = dataColumn.getId();
                    ColumnSettings columnSettings = this.displayerSettings.getColumnSettings(dataColumn);
                    String columnName = columnSettings.getColumnName();
                    XYChartSerie series = new XYChartSerie(columnName, this.getSeriesColor(i), columnId);
                    chartData.addSerie(series);
                }
            } else {
                GWT.log((String)"No values columns specified.");
            }
        } else {
            GWT.log((String)"No categories column specified.");
        }
        return chartData;
    }

    public DisplayerConstraints createDisplayerConstraints() {
        DataSetLookupConstraints lookupConstraints = (DataSetLookupConstraints)((DataSetLookupConstraints)((DataSetLookupConstraints)((DataSetLookupConstraints)((DataSetLookupConstraints)new DataSetLookupConstraints().setGroupRequired(true).setGroupColumn(true).setMaxColumns(10)).setMinColumns(2)).setExtraColumnsAllowed(true)).setExtraColumnsType(ColumnType.NUMBER)).setGroupsTitle("Categories").setColumnsTitle("Series").setColumnTypes((ColumnType[][])new ColumnType[][]{{ColumnType.LABEL, ColumnType.NUMBER}});
        return new DisplayerConstraints(lookupConstraints).supportsAttribute(DisplayerAttributeDef.TYPE).supportsAttribute(DisplayerAttributeDef.RENDERER).supportsAttribute((DisplayerAttributeDef)DisplayerAttributeGroupDef.COLUMNS_GROUP).supportsAttribute((DisplayerAttributeDef)DisplayerAttributeGroupDef.FILTER_GROUP).supportsAttribute((DisplayerAttributeDef)DisplayerAttributeGroupDef.REFRESH_GROUP).supportsAttribute((DisplayerAttributeDef)DisplayerAttributeGroupDef.GENERAL_GROUP).supportsAttribute(DisplayerAttributeDef.CHART_WIDTH).supportsAttribute(DisplayerAttributeDef.CHART_HEIGHT).supportsAttribute(DisplayerAttributeDef.CHART_RESIZABLE).supportsAttribute(DisplayerAttributeDef.CHART_MAX_WIDTH).supportsAttribute(DisplayerAttributeDef.CHART_MAX_HEIGHT).supportsAttribute(DisplayerAttributeDef.CHART_BGCOLOR).supportsAttribute((DisplayerAttributeDef)DisplayerAttributeGroupDef.CHART_MARGIN_GROUP).supportsAttribute((DisplayerAttributeDef)DisplayerAttributeGroupDef.CHART_LEGEND_GROUP).supportsAttribute((DisplayerAttributeDef)DisplayerAttributeGroupDef.AXIS_GROUP);
    }

    private IColor getSeriesColor(int index) {
        int defaultColorsSize = DEFAULT_SERIE_COLORS.length;
        if (index >= defaultColorsSize) {
            return (IColor)ColorName.getValues().get(90 + index * 2);
        }
        return DEFAULT_SERIE_COLORS[index];
    }

    public class BarValueSelectedHandler
    implements ValueSelectedHandler {
        public void onValueSelected(ValueSelectedEvent event) {
            GWT.log((String)("filtering by serie [" + event.getSeries() + "], column [" + event.getColumn() + "] and row [" + event.getRow() + "]"));
            LienzoBarChartDisplayer.this.filterUpdate(event.getColumn(), event.getRow());
        }
    }
}

