/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.renderer.lienzo.client;

import com.ait.lienzo.charts.client.AbstractChart;
import com.ait.lienzo.charts.client.model.DataTable;
import com.ait.lienzo.charts.client.model.DataTableColumn;
import com.ait.lienzo.client.core.shape.IPrimitive;
import com.ait.lienzo.client.core.shape.Layer;
import com.ait.lienzo.client.widget.LienzoPanel;
import com.github.gwtbootstrap.client.ui.Label;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.Anchor;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.dashbuilder.dataset.ColumnType;
import org.dashbuilder.dataset.DataColumn;
import org.dashbuilder.dataset.DataSet;
import org.dashbuilder.dataset.client.DataSetClientServiceError;
import org.dashbuilder.dataset.client.DataSetReadyCallback;
import org.dashbuilder.dataset.group.Interval;
import org.dashbuilder.displayer.client.AbstractDisplayer;
import org.dashbuilder.displayer.client.Displayer;

public abstract class LienzoDisplayer
extends AbstractDisplayer {
    private static final int PANEL_MARGIN = 50;
    private static final String PIXEL = "px";
    protected FlowPanel mainPanel = new FlowPanel();
    protected FlowPanel filterPanel = new FlowPanel();
    protected final LienzoPanel panel = new LienzoPanel();
    protected final Layer layer = new Layer();
    protected final com.google.gwt.user.client.ui.Label label = new com.google.gwt.user.client.ui.Label();
    protected DataSet dataSet;
    protected DataTable lienzoTable = null;
    protected DataColumn categoriesColumn = null;

    public LienzoDisplayer() {
        this.initWidget((Widget)this.mainPanel);
    }

    public void draw() {
        if (!this.isDrawn()) {
            if (this.displayerSettings == null) {
                GWT.log((String)"ERROR: DisplayerSettings property not set");
            } else if (this.dataSetHandler == null) {
                GWT.log((String)"ERROR: DataSetHandler property not set");
            } else {
                try {
                    String initMsg = "Initializing";
                    GWT.log((String)(initMsg + " ..."));
                    this.mainPanel.clear();
                    this.beforeDataSetLookup();
                    this.dataSetHandler.lookupDataSet(new DataSetReadyCallback(){

                        public void callback(DataSet result) {
                            LienzoDisplayer.this.dataSet = result;
                            LienzoDisplayer.this.afterDataSetLookup(result);
                            LienzoDisplayer.this.mainPanel.add((Widget)LienzoDisplayer.this.filterPanel);
                            if (LienzoDisplayer.this.dataSet.getRowCount() == 0) {
                                LienzoDisplayer.this.mainPanel.add(LienzoDisplayer.this.createNoDataMsgPanel());
                            } else {
                                LienzoDisplayer.this.resizePanel(LienzoDisplayer.this.getWidth(), LienzoDisplayer.this.getHeight());
                                LienzoDisplayer.this.layer.setTransformable(true);
                                LienzoDisplayer.this.panel.add(LienzoDisplayer.this.layer);
                                LienzoDisplayer.this.mainPanel.add((Widget)LienzoDisplayer.this.filterPanel);
                                LienzoDisplayer.this.mainPanel.add((Widget)LienzoDisplayer.this.panel);
                                AbstractChart chart = LienzoDisplayer.this.createVisualization();
                                LienzoDisplayer.this.layer.clear();
                                LienzoDisplayer.this.layer.add((IPrimitive)chart);
                                LienzoDisplayer.this.layer.draw();
                            }
                            LienzoDisplayer.this.afterDraw();
                        }

                        public void notFound() {
                            GWT.log((String)"ERROR: Data set not found.");
                        }

                        public boolean onError(DataSetClientServiceError error) {
                            LienzoDisplayer.this.afterError((Displayer)LienzoDisplayer.this, error);
                            return false;
                        }
                    });
                }
                catch (Exception e) {
                    GWT.log((String)("ERROR: " + e.getMessage()));
                }
            }
        }
    }

    public void redraw() {
        if (!this.isDrawn()) {
            this.draw();
        } else {
            try {
                this.beforeDataSetLookup();
                this.dataSetHandler.lookupDataSet(new DataSetReadyCallback(){

                    public void callback(DataSet result) {
                        LienzoDisplayer.this.dataSet = result;
                        LienzoDisplayer.this.afterDataSetLookup(result);
                        LienzoDisplayer.this.updateVisualization();
                        LienzoDisplayer.this.afterRedraw();
                    }

                    public void notFound() {
                        GWT.log((String)"ERROR: Data set not found.");
                    }

                    public boolean onError(DataSetClientServiceError error) {
                        LienzoDisplayer.this.afterError((Displayer)LienzoDisplayer.this, error);
                        return false;
                    }
                });
            }
            catch (Exception e) {
                GWT.log((String)("ERROR: " + e.getMessage()));
            }
        }
    }

    public void close() {
        this.mainPanel.clear();
        this.afterClose();
    }

    protected void resizePanel(int w, int h) {
        String _w = w + 50 + PIXEL;
        String _h = h + 50 + PIXEL;
        this.panel.setSize(_w, _h);
    }

    protected abstract AbstractChart createVisualization();

    protected abstract void updateVisualization();

    protected void beforeDataSetLookup() {
    }

    protected void afterDataSetLookup(DataSet dataSet) {
        this.lienzoTable = this.createTable();
        this.categoriesColumn = this.getCategoriesColumn();
    }

    protected DataTable createTable() {
        DataTable lienzoTable = new DataTable();
        List columns = this.dataSet.getColumns();
        if (columns != null && !columns.isEmpty()) {
            for (int i = 0; i < columns.size(); ++i) {
                DataColumn dataColumn = (DataColumn)columns.get(i);
                List columnValues = dataColumn.getValues();
                ColumnType columnType = dataColumn.getColumnType();
                String columnId = dataColumn.getId();
                lienzoTable.addColumn(columnId, this.getColumnType(dataColumn));
                for (int j = 0; j < columnValues.size(); ++j) {
                    Object value = columnValues.get(j);
                    if (ColumnType.LABEL.equals((Object)columnType)) {
                        value = super.formatValue(value, dataColumn);
                    }
                    this.addTableValue(lienzoTable, columnType, value, columnId);
                }
            }
        }
        return lienzoTable;
    }

    public void addTableValue(DataTable lTable, ColumnType type, Object value, String columnId) {
        if (ColumnType.DATE.equals((Object)type)) {
            if (value == null) {
                lTable.addValue(columnId, new Date());
            } else {
                lTable.addValue(columnId, (Date)value);
            }
        } else if (ColumnType.NUMBER.equals((Object)type)) {
            if (value == null) {
                lTable.addValue(columnId, 0.0);
            } else {
                lTable.addValue(columnId, Double.parseDouble(value.toString()));
            }
        } else {
            lTable.addValue(columnId, value.toString());
        }
    }

    public DataTableColumn.DataTableColumnType getColumnType(DataColumn dataColumn) {
        ColumnType type = dataColumn.getColumnType();
        if (ColumnType.LABEL.equals((Object)type)) {
            return DataTableColumn.DataTableColumnType.STRING;
        }
        if (ColumnType.TEXT.equals((Object)type)) {
            return DataTableColumn.DataTableColumnType.STRING;
        }
        if (ColumnType.NUMBER.equals((Object)type)) {
            return DataTableColumn.DataTableColumnType.NUMBER;
        }
        if (ColumnType.DATE.equals((Object)type)) {
            return DataTableColumn.DataTableColumnType.DATE;
        }
        return DataTableColumn.DataTableColumnType.STRING;
    }

    protected DataColumn getCategoriesColumn() {
        List columns = this.dataSet.getColumns();
        if (columns != null && !columns.isEmpty()) {
            return (DataColumn)columns.get(0);
        }
        return null;
    }

    protected DataColumn[] getValuesColumns() {
        List columns = this.dataSet.getColumns();
        if (columns != null && !columns.isEmpty()) {
            DataColumn[] result = new DataColumn[columns.size() - 1];
            if (columns != null && !columns.isEmpty()) {
                for (int i = 1; i < columns.size(); ++i) {
                    DataColumn dataColumn;
                    result[i - 1] = dataColumn = (DataColumn)columns.get(i);
                }
            }
            return result;
        }
        return null;
    }

    protected int getChartWidth() {
        return this.displayerSettings.getChartWidth();
    }

    protected int getChartHeight() {
        return this.displayerSettings.getChartHeight();
    }

    private int getWidth() {
        int width = this.displayerSettings.isResizable() ? this.displayerSettings.getChartMaxWidth() : this.displayerSettings.getChartWidth();
        int left = this.displayerSettings.getChartMarginLeft();
        int right = this.displayerSettings.getChartMarginRight();
        return this.displayerSettings.getChartWidth() + right + left;
    }

    private int getHeight() {
        int height = this.displayerSettings.isResizable() ? this.displayerSettings.getChartMaxHeight() : this.displayerSettings.getChartHeight();
        int top = this.displayerSettings.getChartMarginTop();
        int bottom = this.displayerSettings.getChartMarginBottom();
        return this.displayerSettings.getChartHeight() + top + bottom;
    }

    protected Widget createNoDataMsgPanel() {
        return new Label("NO DATA");
    }

    protected Widget createCurrentSelectionWidget() {
        if (!this.displayerSettings.isFilterEnabled()) {
            return null;
        }
        Set columnFilters = this.filterColumns();
        if (columnFilters.isEmpty()) {
            return null;
        }
        HorizontalPanel panel = new HorizontalPanel();
        panel.getElement().setAttribute("cellpadding", "2");
        for (String columnId : columnFilters) {
            List selectedValues = this.filterIntervals(columnId);
            DataColumn column = this.dataSet.getColumnById(columnId);
            for (Interval interval : selectedValues) {
                String formattedValue = this.formatInterval(interval, column);
                panel.add((Widget)new Label(formattedValue));
            }
        }
        Anchor anchor = new Anchor("Reset");
        panel.add((Widget)anchor);
        anchor.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                LienzoDisplayer.this.filterReset();
                LienzoDisplayer.this.updateVisualization();
            }
        });
        return panel;
    }
}

