/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.renderer.lienzo.client;

import com.ait.lienzo.charts.client.AbstractChart;
import com.ait.lienzo.charts.client.pie.PieChart;
import com.ait.lienzo.charts.client.pie.PieChartData;
import com.ait.lienzo.charts.client.pie.event.DataReloadedEvent;
import com.ait.lienzo.charts.client.pie.event.DataReloadedEventHandler;
import com.ait.lienzo.charts.client.pie.event.ValueSelectedEvent;
import com.ait.lienzo.charts.client.pie.event.ValueSelectedHandler;
import com.ait.lienzo.charts.client.resizer.ChartResizeEvent;
import com.ait.lienzo.charts.client.resizer.ChartResizeEventHandler;
import com.ait.lienzo.client.core.shape.Group;
import com.ait.lienzo.shared.core.types.ColorName;
import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.ui.Widget;
import org.dashbuilder.dataset.ColumnType;
import org.dashbuilder.dataset.DataColumn;
import org.dashbuilder.dataset.DataSetLookupConstraints;
import org.dashbuilder.displayer.DisplayerAttributeDef;
import org.dashbuilder.displayer.DisplayerAttributeGroupDef;
import org.dashbuilder.displayer.DisplayerConstraints;
import org.dashbuilder.renderer.lienzo.client.LienzoDisplayer;

public class LienzoPieChartDisplayer
extends LienzoDisplayer {
    private static final ColorName[] DEFAULT_SERIE_COLORS = new ColorName[]{ColorName.DEEPSKYBLUE, ColorName.RED, ColorName.YELLOWGREEN};
    protected PieChart chart = null;
    private boolean isConfigured = false;

    @Override
    public AbstractChart createVisualization() {
        PieChartData chartData = this.createChartData();
        this.chart = new PieChart(new DataReloadedEventHandler(){

            public void onDataReloaded(DataReloadedEvent event) {
                LienzoPieChartDisplayer.this.configurePieChart(event.getChart());
            }
        });
        this.chart.setData(chartData);
        return this.chart;
    }

    private void configurePieChart(PieChart chart) {
        if (this.isConfigured) {
            return;
        }
        ((Group)chart.setX(0.0)).setY(0.0);
        chart.setName(this.displayerSettings.getTitle());
        chart.setWidth((double)this.getChartWidth());
        chart.setHeight((double)this.getChartHeight());
        chart.setMarginLeft((double)this.displayerSettings.getChartMarginLeft());
        chart.setMarginRight((double)this.displayerSettings.getChartMarginRight());
        chart.setMarginTop((double)this.displayerSettings.getChartMarginTop());
        chart.setMarginBotom((double)this.displayerSettings.getChartMarginBottom());
        chart.setFontFamily("Verdana");
        chart.setFontStyle("bold");
        chart.setFontSize(8);
        chart.setShowTitle(this.displayerSettings.isTitleVisible());
        chart.setResizable(this.displayerSettings.isResizable());
        chart.setAnimated(true);
        if (this.displayerSettings.isFilterEnabled()) {
            chart.addValueSelectedHandler((ValueSelectedHandler)new PieValueSelectedHandler());
        }
        if (this.displayerSettings.isResizable()) {
            chart.addChartResizeEventHandler(new ChartResizeEventHandler(){

                public void onChartResize(ChartResizeEvent event) {
                    LienzoPieChartDisplayer.this.resizePanel((int)event.getWidth(), (int)event.getHeight());
                }
            });
        }
        chart.build();
        this.isConfigured = true;
    }

    @Override
    protected void updateVisualization() {
        this.filterPanel.clear();
        Widget filterReset = super.createCurrentSelectionWidget();
        if (filterReset != null) {
            this.filterPanel.add(filterReset);
        }
        if (this.dataSet.getRowCount() == 0) {
            this.mainPanel.add(super.createNoDataMsgPanel());
            this.chart = null;
        } else {
            PieChartData newData = this.createChartData();
            this.chart.setData(newData);
        }
    }

    protected PieChartData createChartData() {
        DataColumn categoriesColumn = this.getCategoriesColumn();
        DataColumn[] valuesColumns = this.getValuesColumns();
        PieChartData chartData = new PieChartData(this.lienzoTable, categoriesColumn.getId(), valuesColumns[0].getId());
        return chartData;
    }

    public DisplayerConstraints createDisplayerConstraints() {
        DataSetLookupConstraints lookupConstraints = (DataSetLookupConstraints)((DataSetLookupConstraints)((DataSetLookupConstraints)((DataSetLookupConstraints)new DataSetLookupConstraints().setGroupRequired(true).setGroupColumn(true).setMaxColumns(2)).setMinColumns(2)).setExtraColumnsAllowed(false)).setGroupsTitle("Categories").setColumnsTitle("Values").setColumnTypes((ColumnType[][])new ColumnType[][]{{ColumnType.LABEL, ColumnType.NUMBER}});
        return new DisplayerConstraints(lookupConstraints).supportsAttribute(DisplayerAttributeDef.TYPE).supportsAttribute(DisplayerAttributeDef.RENDERER).supportsAttribute((DisplayerAttributeDef)DisplayerAttributeGroupDef.COLUMNS_GROUP).supportsAttribute((DisplayerAttributeDef)DisplayerAttributeGroupDef.FILTER_GROUP).supportsAttribute((DisplayerAttributeDef)DisplayerAttributeGroupDef.REFRESH_GROUP).supportsAttribute((DisplayerAttributeDef)DisplayerAttributeGroupDef.GENERAL_GROUP).supportsAttribute((DisplayerAttributeDef)DisplayerAttributeGroupDef.CHART_GROUP);
    }

    public class PieValueSelectedHandler
    implements ValueSelectedHandler {
        public void onValueSelected(ValueSelectedEvent event) {
            GWT.log((String)("filtering by column [" + event.getColumn() + "], row [" + event.getRow() + "]"));
            LienzoPieChartDisplayer.this.filterUpdate(event.getColumn(), event.getRow());
        }
    }
}

