/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.renderer.lienzo.client;

import com.ait.lienzo.charts.client.core.AbstractChart;
import com.ait.lienzo.charts.client.core.axis.Axis;
import com.ait.lienzo.charts.client.core.axis.CategoryAxis;
import com.ait.lienzo.charts.client.core.axis.NumericAxis;
import com.ait.lienzo.charts.client.core.resizer.ChartResizeEvent;
import com.ait.lienzo.charts.client.core.resizer.ChartResizeEventHandler;
import com.ait.lienzo.charts.client.core.xy.XYChart;
import com.ait.lienzo.charts.client.core.xy.XYChartData;
import com.ait.lienzo.charts.client.core.xy.XYChartSeries;
import com.ait.lienzo.charts.client.core.xy.event.ValueSelectedEvent;
import com.ait.lienzo.charts.client.core.xy.event.ValueSelectedHandler;
import com.ait.lienzo.charts.shared.core.types.ChartOrientation;
import com.ait.lienzo.client.core.animation.AnimationTweener;
import com.ait.lienzo.client.core.shape.IPrimitive;
import com.ait.lienzo.client.core.shape.Layer;
import com.ait.lienzo.client.widget.LienzoPanel;
import com.ait.lienzo.shared.core.types.ColorName;
import com.ait.lienzo.shared.core.types.IColor;
import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.Widget;
import org.dashbuilder.dataset.ColumnType;
import org.dashbuilder.dataset.DataColumn;
import org.dashbuilder.dataset.DataSetLookupConstraints;
import org.dashbuilder.displayer.ColumnSettings;
import org.dashbuilder.displayer.DisplayerAttributeDef;
import org.dashbuilder.displayer.DisplayerAttributeGroupDef;
import org.dashbuilder.displayer.DisplayerConstraints;
import org.dashbuilder.renderer.lienzo.client.LienzoDisplayer;

public abstract class LienzoXYChartDisplayer<T extends XYChart>
extends LienzoDisplayer {
    protected static final ColorName[] DEFAULT_SERIE_COLORS = new ColorName[]{ColorName.DEEPSKYBLUE, ColorName.RED, ColorName.YELLOWGREEN};
    protected T chart = null;
    protected FlowPanel filterPanel = new FlowPanel();
    protected final LienzoPanel chartPanel = new LienzoPanel();
    protected final Layer layer = new Layer();

    public abstract T createChart();

    public abstract void reloadChart(XYChartData var1);

    public DisplayerConstraints createDisplayerConstraints() {
        DataSetLookupConstraints lookupConstraints = (DataSetLookupConstraints)((DataSetLookupConstraints)((DataSetLookupConstraints)((DataSetLookupConstraints)((DataSetLookupConstraints)new DataSetLookupConstraints().setGroupRequired(true).setGroupColumn(true).setMaxColumns(10)).setMinColumns(2)).setExtraColumnsAllowed(true)).setExtraColumnsType(ColumnType.NUMBER)).setGroupsTitle("Categories").setColumnsTitle("Series").setColumnTypes((ColumnType[][])new ColumnType[][]{{ColumnType.LABEL, ColumnType.NUMBER}});
        return new DisplayerConstraints(lookupConstraints).supportsAttribute(DisplayerAttributeDef.TYPE).supportsAttribute(DisplayerAttributeDef.RENDERER).supportsAttribute((DisplayerAttributeDef)DisplayerAttributeGroupDef.COLUMNS_GROUP).supportsAttribute((DisplayerAttributeDef)DisplayerAttributeGroupDef.FILTER_GROUP).supportsAttribute((DisplayerAttributeDef)DisplayerAttributeGroupDef.REFRESH_GROUP).supportsAttribute((DisplayerAttributeDef)DisplayerAttributeGroupDef.GENERAL_GROUP).supportsAttribute(DisplayerAttributeDef.CHART_WIDTH).supportsAttribute(DisplayerAttributeDef.CHART_HEIGHT).supportsAttribute(DisplayerAttributeDef.CHART_RESIZABLE).supportsAttribute(DisplayerAttributeDef.CHART_MAX_WIDTH).supportsAttribute(DisplayerAttributeDef.CHART_MAX_HEIGHT).supportsAttribute(DisplayerAttributeDef.CHART_BGCOLOR).supportsAttribute((DisplayerAttributeDef)DisplayerAttributeGroupDef.CHART_MARGIN_GROUP).supportsAttribute((DisplayerAttributeDef)DisplayerAttributeGroupDef.CHART_LEGEND_GROUP).supportsAttribute((DisplayerAttributeDef)DisplayerAttributeGroupDef.AXIS_GROUP);
    }

    protected Widget createVisualization() {
        HTML titleHtml = new HTML();
        if (this.displayerSettings.isTitleVisible()) {
            titleHtml.setText(this.displayerSettings.getTitle());
        }
        FlowPanel container = new FlowPanel();
        container.add((Widget)titleHtml);
        container.add((Widget)this.filterPanel);
        container.add((Widget)this.chartPanel);
        if (this.dataSet.getRowCount() == 0) {
            container.add(this.createNoDataMsgPanel());
        } else {
            this.resizePanel(this.getWidth(), this.getHeight());
            this.layer.setTransformable(true);
            this.chartPanel.add(this.layer);
            AbstractChart chart = this.createXYChart();
            this.layer.clear();
            this.layer.add((IPrimitive)chart);
            this.layer.draw();
        }
        return container;
    }

    public AbstractChart createXYChart() {
        XYChartData chartData = this.createChartData();
        this.chart = this.createChart();
        this.chart.setData(chartData);
        this.configureXYChart();
        return this.chart;
    }

    private void configureXYChart() {
        this.chart.setOrientation(this.isHorizontal() ? ChartOrientation.HORIZNONAL : ChartOrientation.VERTICAL);
        this.chart.setX(0.0).setY(0.0).setName(this.displayerSettings.getTitle());
        this.chart.setWidth((double)this.getChartWidth());
        this.chart.setHeight((double)this.getChartHeight());
        this.chart.setMarginLeft((double)this.displayerSettings.getChartMarginLeft());
        this.chart.setMarginRight((double)this.displayerSettings.getChartMarginRight());
        this.chart.setMarginTop((double)this.displayerSettings.getChartMarginTop());
        this.chart.setMarginBottom((double)this.displayerSettings.getChartMarginBottom());
        this.chart.setFontFamily("Verdana");
        this.chart.setFontStyle("bold");
        this.chart.setFontSize(8);
        this.chart.setShowTitle(true);
        this.chart.setShowCategoriesAxisTitle(false);
        this.chart.setShowValuesAxisTitle(false);
        this.chart.setResizable(this.displayerSettings.isResizable());
        if (this.displayerSettings.isFilterEnabled()) {
            this.chart.addValueSelectedHandler((ValueSelectedHandler)new BarValueSelectedHandler());
        }
        if (this.displayerSettings.isResizable()) {
            this.chart.addChartResizeEventHandler(new ChartResizeEventHandler(){

                public void onChartResize(ChartResizeEvent event) {
                    LienzoXYChartDisplayer.this.resizePanel((int)event.getWidth(), (int)event.getHeight());
                }
            });
        }
        CategoryAxis categoryAxis = new CategoryAxis(this.displayerSettings.getXAxisTitle());
        NumericAxis numericAxis = new NumericAxis(this.displayerSettings.getYAxisTitle());
        this.chart.setCategoriesAxis((Axis)categoryAxis);
        this.chart.setValuesAxis((Axis)numericAxis);
        this.chart.draw();
        this.chart.init(AnimationTweener.LINEAR, 500.0);
    }

    protected boolean isHorizontal() {
        return true;
    }

    protected void updateVisualization() {
        this.filterPanel.clear();
        Widget filterReset = super.createCurrentSelectionWidget();
        if (filterReset != null) {
            this.filterPanel.add(filterReset);
        }
        this.chartPanel.clear();
        if (this.dataSet.getRowCount() == 0) {
            this.chartPanel.add(super.createNoDataMsgPanel());
            this.chart = null;
        } else {
            this.chartPanel.add(this.layer);
            CategoryAxis categoryAxis = new CategoryAxis(this.displayerSettings.getXAxisTitle());
            this.chart.setCategoriesAxis((Axis)categoryAxis);
            XYChartData newData = this.createChartData();
            newData.setCategoryAxisProperty(this.categoriesColumn.getId());
            this.reloadChart(newData);
        }
    }

    protected XYChartData createChartData() {
        XYChartData chartData = new XYChartData(this.lienzoTable);
        DataColumn categoriesColumn = this.getCategoriesColumn();
        DataColumn[] valuesColumns = this.getValuesColumns();
        if (categoriesColumn != null) {
            chartData.setCategoryAxisProperty(categoriesColumn.getId());
            if (valuesColumns != null) {
                for (int i = 0; i < valuesColumns.length; ++i) {
                    DataColumn dataColumn = valuesColumns[i];
                    String columnId = dataColumn.getId();
                    ColumnSettings columnSettings = this.displayerSettings.getColumnSettings(dataColumn);
                    String columnName = columnSettings.getColumnName();
                    XYChartSeries series = new XYChartSeries(columnName, this.getSeriesColor(i), columnId);
                    chartData.addSeries(series);
                }
            } else {
                GWT.log((String)"No values columns specified.");
            }
        } else {
            GWT.log((String)"No categories column specified.");
        }
        return chartData;
    }

    protected void resizePanel(int w, int h) {
        String _w = w + 50 + "px";
        String _h = h + 50 + "px";
        this.chartPanel.setSize(_w, _h);
    }

    protected IColor getSeriesColor(int index) {
        int defaultColorsSize = DEFAULT_SERIE_COLORS.length;
        if (index >= defaultColorsSize) {
            return (IColor)ColorName.getValues().get(90 + index * 2);
        }
        return DEFAULT_SERIE_COLORS[index];
    }

    public class BarValueSelectedHandler
    implements ValueSelectedHandler {
        public void onValueSelected(ValueSelectedEvent event) {
            GWT.log((String)("filtering by serie [" + event.getSeries() + "], column [" + event.getColumn() + "] and row [" + event.getRow() + "]"));
            LienzoXYChartDisplayer.this.filterUpdate(event.getColumn(), event.getRow());
        }
    }
}

