/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.renderer.lienzo.client;

import com.ait.lienzo.charts.client.core.AbstractChart;
import com.ait.lienzo.charts.client.core.model.PieChartData;
import com.ait.lienzo.charts.client.core.pie.PieChart;
import com.ait.lienzo.charts.client.core.pie.event.ValueSelectedEvent;
import com.ait.lienzo.charts.client.core.pie.event.ValueSelectedHandler;
import com.ait.lienzo.charts.client.core.resizer.ChartResizeEvent;
import com.ait.lienzo.charts.client.core.resizer.ChartResizeEventHandler;
import com.ait.lienzo.client.core.animation.AnimationTweener;
import com.ait.lienzo.client.core.shape.IPrimitive;
import com.ait.lienzo.client.core.shape.Layer;
import com.ait.lienzo.client.widget.LienzoPanel;
import com.ait.lienzo.shared.core.types.ColorName;
import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.Widget;
import org.dashbuilder.dataset.ColumnType;
import org.dashbuilder.dataset.DataColumn;
import org.dashbuilder.dataset.DataSetLookupConstraints;
import org.dashbuilder.displayer.DisplayerAttributeDef;
import org.dashbuilder.displayer.DisplayerAttributeGroupDef;
import org.dashbuilder.displayer.DisplayerConstraints;
import org.dashbuilder.renderer.lienzo.client.LienzoDisplayer;

public class LienzoPieChartDisplayer
extends LienzoDisplayer {
    private static final ColorName[] DEFAULT_SERIE_COLORS = new ColorName[]{ColorName.DEEPSKYBLUE, ColorName.RED, ColorName.YELLOWGREEN};
    protected PieChart chart = null;
    protected FlowPanel filterPanel = new FlowPanel();
    protected final LienzoPanel chartPanel = new LienzoPanel();
    protected final Layer layer = new Layer();

    protected Widget createVisualization() {
        HTML titleHtml = new HTML();
        if (this.displayerSettings.isTitleVisible()) {
            titleHtml.setText(this.displayerSettings.getTitle());
        }
        FlowPanel container = new FlowPanel();
        container.add((Widget)titleHtml);
        container.add((Widget)this.filterPanel);
        container.add((Widget)this.chartPanel);
        if (this.dataSet.getRowCount() == 0) {
            container.add(this.createNoDataMsgPanel());
        } else {
            this.resizePanel(this.getWidth(), this.getHeight());
            this.layer.setTransformable(true);
            this.chartPanel.add(this.layer);
            AbstractChart chart = this.createPieChart();
            this.layer.clear();
            this.layer.add((IPrimitive)chart);
            this.layer.draw();
        }
        return container;
    }

    public AbstractChart createPieChart() {
        PieChartData chartData = this.createChartData();
        this.chart = new PieChart();
        this.chart.setData(chartData);
        this.configurePieChart();
        return this.chart;
    }

    private void configurePieChart() {
        ((PieChart)this.chart.setX(0.0)).setY(0.0);
        this.chart.setName(this.displayerSettings.getTitle());
        this.chart.setWidth((double)this.getChartWidth());
        this.chart.setHeight((double)this.getChartHeight());
        this.chart.setMarginLeft((double)this.displayerSettings.getChartMarginLeft());
        this.chart.setMarginRight((double)this.displayerSettings.getChartMarginRight());
        this.chart.setMarginTop((double)this.displayerSettings.getChartMarginTop());
        this.chart.setMarginBottom((double)this.displayerSettings.getChartMarginBottom());
        this.chart.setFontFamily("Verdana");
        this.chart.setFontStyle("bold");
        this.chart.setFontSize(8);
        this.chart.setShowTitle(true);
        this.chart.setResizable(this.displayerSettings.isResizable());
        if (this.displayerSettings.isFilterEnabled()) {
            this.chart.addValueSelectedHandler((ValueSelectedHandler)new PieValueSelectedHandler());
        }
        if (this.displayerSettings.isResizable()) {
            this.chart.addChartResizeEventHandler(new ChartResizeEventHandler(){

                public void onChartResize(ChartResizeEvent event) {
                    LienzoPieChartDisplayer.this.resizePanel((int)event.getWidth(), (int)event.getHeight());
                }
            });
        }
        this.chart.draw();
        this.chart.init(AnimationTweener.LINEAR, 500.0);
    }

    protected void updateVisualization() {
        this.filterPanel.clear();
        Widget filterReset = super.createCurrentSelectionWidget();
        if (filterReset != null) {
            this.filterPanel.add(filterReset);
        }
        this.chartPanel.clear();
        if (this.dataSet.getRowCount() == 0) {
            this.chartPanel.add(super.createNoDataMsgPanel());
            this.chart = null;
        } else {
            this.chartPanel.add(this.layer);
            PieChartData newData = this.createChartData();
            this.chart.reload(newData, AnimationTweener.LINEAR, 500.0);
        }
    }

    protected PieChartData createChartData() {
        DataColumn categoriesColumn = this.getCategoriesColumn();
        DataColumn[] valuesColumns = this.getValuesColumns();
        PieChartData chartData = new PieChartData(this.lienzoTable, categoriesColumn.getId(), valuesColumns[0].getId());
        return chartData;
    }

    protected void resizePanel(int w, int h) {
        String _w = w + 50 + "px";
        String _h = h + 50 + "px";
        this.chartPanel.setSize(_w, _h);
    }

    public DisplayerConstraints createDisplayerConstraints() {
        DataSetLookupConstraints lookupConstraints = (DataSetLookupConstraints)((DataSetLookupConstraints)((DataSetLookupConstraints)((DataSetLookupConstraints)new DataSetLookupConstraints().setGroupRequired(true).setGroupColumn(true).setMaxColumns(2)).setMinColumns(2)).setExtraColumnsAllowed(false)).setGroupsTitle("Categories").setColumnsTitle("Values").setColumnTypes((ColumnType[][])new ColumnType[][]{{ColumnType.LABEL, ColumnType.NUMBER}});
        return new DisplayerConstraints(lookupConstraints).supportsAttribute(DisplayerAttributeDef.TYPE).supportsAttribute(DisplayerAttributeDef.RENDERER).supportsAttribute((DisplayerAttributeDef)DisplayerAttributeGroupDef.COLUMNS_GROUP).supportsAttribute((DisplayerAttributeDef)DisplayerAttributeGroupDef.FILTER_GROUP).supportsAttribute((DisplayerAttributeDef)DisplayerAttributeGroupDef.REFRESH_GROUP).supportsAttribute((DisplayerAttributeDef)DisplayerAttributeGroupDef.GENERAL_GROUP).supportsAttribute((DisplayerAttributeDef)DisplayerAttributeGroupDef.CHART_GROUP);
    }

    public class PieValueSelectedHandler
    implements ValueSelectedHandler {
        public void onValueSelected(ValueSelectedEvent event) {
            GWT.log((String)("filtering by column [" + event.getColumn() + "], row [" + event.getRow() + "]"));
            LienzoPieChartDisplayer.this.filterUpdate(event.getColumn(), event.getRow());
        }
    }
}

