/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.renderer.lienzo.client;

import java.util.Arrays;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import org.dashbuilder.displayer.DisplayerSettings;
import org.dashbuilder.displayer.DisplayerSubType;
import org.dashbuilder.displayer.DisplayerType;
import org.dashbuilder.displayer.client.AbstractRendererLibrary;
import org.dashbuilder.displayer.client.Displayer;
import org.dashbuilder.renderer.lienzo.client.LienzoBarChartDisplayer;
import org.dashbuilder.renderer.lienzo.client.LienzoLineChartDisplayer;
import org.dashbuilder.renderer.lienzo.client.LienzoPieChartDisplayer;

@ApplicationScoped
public class LienzoRenderer
extends AbstractRendererLibrary {
    public static final String UUID = "lienzo";

    public String getUUID() {
        return UUID;
    }

    public String getName() {
        return "Lienzo";
    }

    public List<DisplayerType> getSupportedTypes() {
        return Arrays.asList(DisplayerType.BARCHART, DisplayerType.PIECHART, DisplayerType.LINECHART);
    }

    public List<DisplayerSubType> getSupportedSubtypes(DisplayerType displayerType) {
        switch (displayerType) {
            case BARCHART: {
                return Arrays.asList(DisplayerSubType.BAR, DisplayerSubType.COLUMN);
            }
            case PIECHART: {
                return Arrays.asList(DisplayerSubType.PIE);
            }
            case LINECHART: {
                return Arrays.asList(DisplayerSubType.LINE);
            }
        }
        return Arrays.asList(new DisplayerSubType[0]);
    }

    public Displayer lookupDisplayer(DisplayerSettings displayerSettings) {
        DisplayerType type = displayerSettings.getType();
        if (DisplayerType.BARCHART.equals((Object)type)) {
            return new LienzoBarChartDisplayer();
        }
        if (DisplayerType.PIECHART.equals((Object)type)) {
            return new LienzoPieChartDisplayer();
        }
        if (DisplayerType.LINECHART.equals((Object)type)) {
            return new LienzoLineChartDisplayer();
        }
        return null;
    }
}

