/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.renderer.lienzo.client;

import com.ait.lienzo.charts.client.core.AbstractChart;
import com.ait.lienzo.charts.client.core.resizer.ChartResizeEvent;
import com.ait.lienzo.charts.client.core.resizer.ChartResizeEventHandler;
import com.ait.lienzo.client.core.animation.AnimationTweener;
import com.ait.lienzo.client.core.shape.Layer;
import com.ait.lienzo.client.widget.LienzoPanel;
import com.ait.lienzo.shared.core.types.ColorName;
import com.ait.lienzo.shared.core.types.IColor;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.List;
import org.dashbuilder.dataset.ColumnType;
import org.dashbuilder.renderer.lienzo.client.LienzoDisplayer;
import org.dashbuilder.renderer.lienzo.client.LienzoDisplayerView;

public abstract class LienzoCategoriesDisplayerView<P extends LienzoDisplayer, C extends AbstractChart>
extends LienzoDisplayerView<P> {
    public static final ColorName[] DEFAULT_SERIE_COLORS = new ColorName[]{ColorName.DEEPSKYBLUE, ColorName.RED, ColorName.YELLOWGREEN};
    public static final int PANEL_MARGIN = 50;
    public static final String PIXEL = "px";
    public static final int ANIMATION_DURATION = 500;
    private C chart = null;
    private Layer layer = new Layer();
    private LienzoPanel chartPanel = new LienzoPanel();
    protected Column categoriesColumn = null;
    protected List<Column> seriesColumnList = new ArrayList<Column>();

    @Override
    public void showTitle(String title) {
        super.showTitle(title);
        this.chart.setX(0.0).setY(0.0).setName(title);
    }

    @Override
    public void drawChart() {
        this.chart = this._createChart();
        this.configureChart(this.chart);
        this.layer.setTransformable(true);
        this.layer.add(this.chart);
        this.chartPanel.add(this.layer);
        this.resizePanel(this.width, this.height);
        super.showDisplayer((Widget)this.chartPanel);
        this.layer.draw();
    }

    @Override
    public void reloadChart() {
        this._reloadChart(this.chart);
        super.showDisplayer((Widget)this.chartPanel);
    }

    protected abstract C _createChart();

    protected abstract void _reloadChart(C var1);

    protected void configureChart(C chart) {
        chart.setWidth((double)this.width);
        chart.setHeight((double)this.height);
        chart.setMarginLeft((double)this.marginLeft);
        chart.setMarginRight((double)this.marginRight);
        chart.setMarginTop((double)this.marginTop);
        chart.setMarginBottom((double)this.marginBottom);
        chart.setFontFamily(this.fontFamily);
        chart.setFontStyle(this.fontStyle);
        chart.setFontSize(this.fontSize);
        chart.setShowTitle(true);
        chart.setResizable(this.resizeEnabled);
        if (this.resizeEnabled) {
            chart.addChartResizeEventHandler(new ChartResizeEventHandler(){

                public void onChartResize(ChartResizeEvent event) {
                    LienzoCategoriesDisplayerView.this.resizePanel((int)event.getWidth(), (int)event.getHeight());
                }
            });
        }
        chart.draw();
        chart.init(AnimationTweener.LINEAR, 500.0);
    }

    protected void resizePanel(int w, int h) {
        String _w = w + 50 + PIXEL;
        String _h = h + 50 + PIXEL;
        this.chartPanel.setSize(_w, _h);
    }

    protected IColor getSeriesColor(int index) {
        int defaultColorsSize = DEFAULT_SERIE_COLORS.length;
        if (index >= defaultColorsSize) {
            return (IColor)ColorName.getValues().get(90 + index * 2);
        }
        return DEFAULT_SERIE_COLORS[index];
    }

    @Override
    public void dataClear() {
        super.dataClear();
        this.categoriesColumn = null;
        this.seriesColumnList.clear();
    }

    @Override
    public void dataAddColumn(String columnId, String columnName, ColumnType columnType) {
        super.dataAddColumn(columnId, columnName, columnType);
        Column newColumn = new Column(columnId, columnName, columnType);
        if (this.categoriesColumn == null) {
            this.categoriesColumn = newColumn;
        } else {
            this.seriesColumnList.add(newColumn);
        }
    }

    class Column {
        String columnId;
        String columnName;
        ColumnType columnType;

        public Column(String columnId, String columnName, ColumnType columnType) {
            this.columnId = columnId;
            this.columnName = columnName;
            this.columnType = columnType;
        }
    }
}

