/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.renderer.lienzo.client;

import com.ait.lienzo.charts.client.core.axis.Axis;
import com.ait.lienzo.charts.client.core.axis.CategoryAxis;
import com.ait.lienzo.charts.client.core.axis.NumericAxis;
import com.ait.lienzo.charts.client.core.xy.XYChart;
import com.ait.lienzo.charts.client.core.xy.XYChartData;
import com.ait.lienzo.charts.client.core.xy.XYChartSeries;
import com.ait.lienzo.charts.client.core.xy.event.ValueSelectedEvent;
import com.ait.lienzo.charts.client.core.xy.event.ValueSelectedHandler;
import com.ait.lienzo.charts.shared.core.types.ChartOrientation;
import com.google.gwt.core.client.GWT;
import org.dashbuilder.renderer.lienzo.client.LienzoCategoriesDisplayerView;
import org.dashbuilder.renderer.lienzo.client.LienzoXYChartDisplayer;

public abstract class LienzoXYChartDisplayerView<P extends LienzoXYChartDisplayer, C extends XYChart>
extends LienzoCategoriesDisplayerView<P, C>
implements LienzoXYChartDisplayer.View<P> {
    protected String xAxisTitle = null;
    protected String yAxisTitle = null;
    protected boolean showXLabels = false;
    protected boolean showYLabels = false;
    protected boolean horizontal = false;

    @Override
    public void setShowXLabels(boolean showXLabels) {
        this.showXLabels = showXLabels;
    }

    @Override
    public void setShowYLabels(boolean showYLabels) {
        this.showYLabels = showYLabels;
    }

    @Override
    public void setXAxisTitle(String xAxisTitle) {
        this.xAxisTitle = xAxisTitle;
    }

    @Override
    public void setYAxisTitle(String yAxisTitle) {
        this.yAxisTitle = yAxisTitle;
    }

    @Override
    public void setHorizontal(boolean horizontal) {
        this.horizontal = horizontal;
    }

    @Override
    protected void configureChart(C chart) {
        chart.setOrientation(this.horizontal ? ChartOrientation.HORIZNONAL : ChartOrientation.VERTICAL);
        chart.setShowCategoriesAxisTitle(this.showXLabels);
        chart.setShowValuesAxisTitle(this.showYLabels);
        CategoryAxis categoryAxis = new CategoryAxis(this.xAxisTitle);
        NumericAxis numericAxis = new NumericAxis(this.yAxisTitle);
        chart.setCategoriesAxis((Axis)categoryAxis);
        chart.setValuesAxis((Axis)numericAxis);
        if (this.filterEnabled) {
            chart.addValueSelectedHandler(new ValueSelectedHandler(){

                public void onValueSelected(ValueSelectedEvent event) {
                    GWT.log((String)("filtering by serie [" + event.getSeries() + "], column [" + event.getColumn() + "] and row [" + event.getRow() + "]"));
                    ((LienzoXYChartDisplayer)LienzoXYChartDisplayerView.this.getPresenter()).onCategorySelected(event.getColumn(), event.getRow());
                }
            });
        }
        super.configureChart(chart);
    }

    protected XYChartData createChartData() {
        XYChartData chartData = new XYChartData(this.getDataTable());
        if (this.categoriesColumn != null) {
            if (!this.seriesColumnList.isEmpty()) {
                chartData.setCategoryAxisProperty(this.categoriesColumn.columnId);
                for (int i = 0; i < this.seriesColumnList.size(); ++i) {
                    LienzoCategoriesDisplayerView.Column dataColumn = (LienzoCategoriesDisplayerView.Column)this.seriesColumnList.get(i);
                    String columnId = dataColumn.columnId;
                    String columnName = dataColumn.columnName;
                    XYChartSeries series = new XYChartSeries(columnName, this.getSeriesColor(i), columnId);
                    chartData.addSeries(series);
                }
            } else {
                GWT.log((String)"No values columns specified.");
            }
        } else {
            GWT.log((String)"No categories column specified.");
        }
        return chartData;
    }
}

