/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.backend.services.impl;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.enterprise.event.Event;
import org.dashbuilder.backend.navigation.RuntimeNavigationBuilder;
import org.dashbuilder.backend.services.impl.RuntimeModelParserImpl;
import org.dashbuilder.navigation.impl.NavTreeBuilder;
import org.dashbuilder.shared.event.NewDataSetContentEvent;
import org.dashbuilder.shared.model.DataSetContent;
import org.dashbuilder.shared.model.DataSetContentType;
import org.dashbuilder.shared.model.RuntimeModel;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.InjectMocks;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.uberfire.ext.layout.editor.api.editor.LayoutTemplate;

@RunWith(value=MockitoJUnitRunner.class)
public class RuntimeModelParserImplTest {
    @Mock
    Event<NewDataSetContentEvent> newDataSetContentEventSource;
    @Mock
    RuntimeNavigationBuilder navigationBuilder;
    @InjectMocks
    RuntimeModelParserImpl parser;

    @Test
    public void testEmptyImport() throws IOException {
        Mockito.when((Object)this.navigationBuilder.build((Optional)Matchers.any(), (List)Matchers.any())).thenReturn((Object)new NavTreeBuilder().build());
        InputStream emptyImport = this.getClass().getResourceAsStream("/empty.zip");
        RuntimeModel runtimeModel = this.parser.retrieveRuntimeModel(emptyImport);
        ((Event)Mockito.verify(this.newDataSetContentEventSource, (VerificationMode)Mockito.times((int)0))).fire(Matchers.any());
        Assert.assertTrue((boolean)runtimeModel.getLayoutTemplates().isEmpty());
        Assert.assertTrue((boolean)runtimeModel.getNavTree().getRootItems().isEmpty());
    }

    @Test
    public void testValidImport() throws IOException {
        this.parser.init();
        InputStream validImport = this.getClass().getResourceAsStream("/valid_import.zip");
        RuntimeModel runtimeModel = this.parser.parse(validImport);
        ArgumentCaptor navigationContent = ArgumentCaptor.forClass(Optional.class);
        ((RuntimeNavigationBuilder)Mockito.verify((Object)this.navigationBuilder)).build((Optional)navigationContent.capture(), (List)Matchers.any());
        Assert.assertEquals((Object)"{}", ((Optional)navigationContent.getValue()).get());
        List layoutTemplates = runtimeModel.getLayoutTemplates();
        Assert.assertEquals((long)1L, (long)layoutTemplates.size());
        LayoutTemplate layoutTemplate = (LayoutTemplate)layoutTemplates.get(0);
        Assert.assertEquals((Object)"life_expectancy", (Object)layoutTemplate.getName());
        Assert.assertEquals((long)3L, (long)layoutTemplate.getVersion());
        ArgumentCaptor datasetContents = ArgumentCaptor.forClass(NewDataSetContentEvent.class);
        ((Event)Mockito.verify(this.newDataSetContentEventSource)).fire(datasetContents.capture());
        NewDataSetContentEvent newDataSetContentEvent = (NewDataSetContentEvent)datasetContents.getValue();
        Assert.assertEquals((long)2L, (long)newDataSetContentEvent.getContent().size());
        List datasets = newDataSetContentEvent.getContent();
        Assert.assertEquals((long)2L, (long)datasets.size());
        Assert.assertEquals((Object)"e26a81a1-5636-493c-96e0-51bc32322b17", (Object)((DataSetContent)datasets.get(0)).getId());
        Assert.assertEquals((Object)"e26a81a1-5636-493c-96e0-51bc32322b17", (Object)((DataSetContent)datasets.get(1)).getId());
        Predicate<DataSetContent> csvMatcher = ds -> ds.getContentType().equals((Object)DataSetContentType.CSV);
        Predicate<DataSetContent> defMatcher = ds -> ds.getContentType().equals((Object)DataSetContentType.DEFINITION);
        Assert.assertTrue((boolean)datasets.stream().anyMatch(csvMatcher));
        Assert.assertTrue((boolean)datasets.stream().anyMatch(defMatcher));
        String dsContent = datasets.stream().filter(defMatcher).findAny().get().getContent();
        String csvContent = datasets.stream().filter(csvMatcher).findAny().get().getContent();
        Assert.assertEquals((Object)this.getFileContent("/ds.dset"), (Object)dsContent);
        Assert.assertEquals((Object)this.getFileContent("/ds.csv"), (Object)csvContent);
    }

    private String getFileContent(String resource) throws IOException {
        Path csvActualPath = Paths.get(this.getClass().getResource(resource).getFile(), new String[0]);
        return Files.readAllLines(csvActualPath).stream().collect(Collectors.joining(System.lineSeparator()));
    }
}

