/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.client.screens;

import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.dashbuilder.client.navbar.AppNavBar;
import org.dashbuilder.client.screens.DashboardsListScreen;
import org.dashbuilder.client.screens.RouterScreen;
import org.dashbuilder.client.screens.RuntimeScreen;
import org.dashbuilder.shared.model.DashbuilderRuntimeMode;
import org.dashbuilder.shared.model.RuntimeModel;
import org.dashbuilder.shared.model.RuntimeServiceResponse;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.uberfire.client.mvp.PlaceManager;

@RunWith(value=GwtMockitoTestRunner.class)
public class RouterScreenTest {
    @Mock
    PlaceManager placeManager;
    @Mock
    AppNavBar appNavBar;
    @Mock
    RuntimeScreen runtimeScreen;
    @Mock
    DashboardsListScreen dashboardsListScreen;
    @InjectMocks
    RouterScreen routerScreen;

    @Test
    public void testRouteToRuntimePerspective() {
        RuntimeModel runtimeModel = (RuntimeModel)Mockito.mock(RuntimeModel.class);
        RuntimeServiceResponse response = new RuntimeServiceResponse(DashbuilderRuntimeMode.SINGLE_IMPORT, Optional.of(runtimeModel), Collections.emptyList());
        this.routerScreen.route(response);
        ((RuntimeScreen)Mockito.verify((Object)this.runtimeScreen)).loadDashboards((RuntimeModel)Matchers.eq((Object)runtimeModel));
        ((PlaceManager)Mockito.verify((Object)this.placeManager)).goTo((String)Matchers.eq((Object)"RuntimePerspective"));
    }

    @Test
    public void testRouteToEmptyPerspective() {
        RuntimeServiceResponse response = new RuntimeServiceResponse(DashbuilderRuntimeMode.SINGLE_IMPORT, Optional.empty(), Collections.emptyList());
        this.routerScreen.route(response);
        ((PlaceManager)Mockito.verify((Object)this.placeManager)).goTo((String)Matchers.eq((Object)"EmptyPerspective"));
    }

    @Test
    public void testRouteToDashboardsListPerspective() {
        List<String> models = Arrays.asList("m1", "m2");
        RuntimeServiceResponse response = new RuntimeServiceResponse(DashbuilderRuntimeMode.MULTIPLE_IMPORT, Optional.empty(), models);
        this.routerScreen.route(response);
        ((DashboardsListScreen)Mockito.verify((Object)this.dashboardsListScreen)).loadList((List)Matchers.eq(models));
        ((PlaceManager)Mockito.verify((Object)this.placeManager)).goTo((String)Matchers.eq((Object)"DashboardsListPerspective"));
    }
}

