/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.backend.services.impl;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.Map;
import org.dashbuilder.backend.services.impl.RuntimeModelRegistryImpl;
import org.dashbuilder.shared.model.DashbuilderRuntimeMode;
import org.dashbuilder.shared.model.RuntimeModel;
import org.dashbuilder.shared.service.ImportValidationService;
import org.dashbuilder.shared.service.RuntimeModelParser;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.AdditionalMatchers;
import org.mockito.InjectMocks;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.uberfire.apache.commons.io.FilenameUtils;

@RunWith(value=MockitoJUnitRunner.class)
public class RuntimeModelRegistryImplTest {
    @Mock
    ImportValidationService importValidationService;
    @Mock
    Map<String, RuntimeModel> runtimeModels;
    @Mock
    RuntimeModelParser parser;
    @InjectMocks
    RuntimeModelRegistryImpl registry;
    private Path tempFile;
    private Path tempFile2;

    @Before
    public void init() throws IOException {
        this.tempFile = Files.createTempFile("test", ".zip", new FileAttribute[0]);
        this.tempFile2 = Files.createTempFile("test", ".zip", new FileAttribute[0]);
    }

    @After
    public void cleanup() throws IOException {
        Files.deleteIfExists(this.tempFile);
        Files.deleteIfExists(this.tempFile2);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testRegisterFileEmpty() {
        this.registry.registerFile("");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testRegisterFileNull() {
        this.registry.registerFile(null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testRegisterFileNotExist() {
        this.registry.registerFile("file");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testRegisterFileInvalid() throws IOException {
        String file = this.tempFile.toString();
        Mockito.when((Object)this.importValidationService.validate(file)).thenReturn((Object)false);
        this.registry.registerFile(file);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testRegisterFileNotAcceptingImports() throws IOException {
        String file = this.tempFile.toString();
        Mockito.when((Object)this.importValidationService.validate(file)).thenReturn((Object)true);
        this.registry.setMode(DashbuilderRuntimeMode.STATIC);
        this.registry.registerFile(file);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testRegisterFileParsingError() throws IOException {
        String file = this.tempFile.toString();
        String importId = FilenameUtils.getBaseName((String)this.tempFile.toFile().getPath());
        Mockito.when((Object)this.runtimeModels.isEmpty()).thenReturn((Object)true);
        Mockito.when((Object)this.importValidationService.validate(file)).thenReturn((Object)true);
        Mockito.when((Object)this.parser.parse((String)Matchers.eq((Object)importId), (InputStream)Matchers.any())).thenThrow(new Throwable[]{new RuntimeException()});
        this.registry.registerFile(file);
    }

    @Test
    public void testRegisterFileSuccess() throws IOException {
        String file = this.tempFile.toString();
        String importId = FilenameUtils.getBaseName((String)this.tempFile.toFile().getPath());
        RuntimeModel runtimeModel = (RuntimeModel)Mockito.mock(RuntimeModel.class);
        Mockito.when((Object)this.runtimeModels.isEmpty()).thenReturn((Object)true);
        Mockito.when((Object)this.importValidationService.validate(file)).thenReturn((Object)true);
        Mockito.when((Object)this.parser.parse((String)Matchers.eq((Object)importId), (InputStream)Matchers.any())).thenReturn((Object)runtimeModel);
        this.registry.registerFile(file);
        ((Map)Mockito.verify(this.runtimeModels)).put(Matchers.eq((Object)importId), Matchers.eq((Object)runtimeModel));
    }

    @Test
    public void testRegisterFileSuccessMultiMode() throws IOException {
        String file1 = this.tempFile.toString();
        String file2 = this.tempFile2.toString();
        String importId1 = FilenameUtils.getBaseName((String)this.tempFile.toFile().getPath());
        String importId2 = FilenameUtils.getBaseName((String)this.tempFile2.toFile().getPath());
        RuntimeModel runtimeModel1 = (RuntimeModel)Mockito.mock(RuntimeModel.class);
        RuntimeModel runtimeModel2 = (RuntimeModel)Mockito.mock(RuntimeModel.class);
        Mockito.when((Object)this.runtimeModels.isEmpty()).thenReturn((Object)true);
        Mockito.when((Object)this.importValidationService.validate((String)AdditionalMatchers.or((Object)Matchers.eq((Object)file1), (Object)Matchers.eq((Object)file2)))).thenReturn((Object)true);
        Mockito.when((Object)this.parser.parse((String)Matchers.eq((Object)importId1), (InputStream)Matchers.any())).thenReturn((Object)runtimeModel1);
        Mockito.when((Object)this.parser.parse((String)Matchers.eq((Object)importId2), (InputStream)Matchers.any())).thenReturn((Object)runtimeModel2);
        this.registry.setMode(DashbuilderRuntimeMode.MULTIPLE_IMPORT);
        this.registry.registerFile(file1);
        ((Map)Mockito.verify(this.runtimeModels)).put(Matchers.eq((Object)importId1), Matchers.eq((Object)runtimeModel1));
        this.registry.registerFile(file2);
        ((Map)Mockito.verify(this.runtimeModels)).put(Matchers.eq((Object)importId2), Matchers.eq((Object)runtimeModel2));
    }

    @Test
    public void testSingle() {
        RuntimeModel model1 = (RuntimeModel)Mockito.mock(RuntimeModel.class);
        Mockito.when(this.runtimeModels.values()).thenReturn(Collections.singleton(model1));
        Assert.assertEquals((Object)model1, this.registry.single().get());
    }

    @Test
    public void testGetInMultipleMode() {
        this.registry.setMode(DashbuilderRuntimeMode.MULTIPLE_IMPORT);
        String id = "ID";
        this.registry.get(id);
        ((Map)Mockito.verify(this.runtimeModels)).get(Matchers.eq((Object)id));
    }

    @Test
    public void testGetWithSingleMode() {
        this.registry.setMode(DashbuilderRuntimeMode.SINGLE_IMPORT);
        String id = "ID";
        RuntimeModel model1 = (RuntimeModel)Mockito.mock(RuntimeModel.class);
        Mockito.when(this.runtimeModels.values()).thenReturn(Collections.singleton(model1));
        Assert.assertEquals((Object)model1, this.registry.single().get());
        ((Map)Mockito.verify(this.runtimeModels, (VerificationMode)Mockito.times((int)0))).get(Matchers.eq((Object)id));
        ((Map)Mockito.verify(this.runtimeModels)).values();
    }
}

