/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.client.screens;

import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.Arrays;
import java.util.List;
import org.dashbuilder.client.screens.RuntimeScreen;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.ext.layout.editor.api.editor.LayoutTemplate;

@RunWith(value=GwtMockitoTestRunner.class)
public class RuntimeScreenTest {
    @Mock
    PlaceManager placeManager;
    @InjectMocks
    RuntimeScreen runtimeScreen;

    @Test
    public void testGoToIndexWithIndexPage() {
        String randomPage = "randomPage";
        List<LayoutTemplate> templates = Arrays.asList(new LayoutTemplate(randomPage), new LayoutTemplate("index"));
        this.runtimeScreen.goToIndex(templates);
        ((PlaceManager)Mockito.verify((Object)this.placeManager)).goTo("index");
        ((PlaceManager)Mockito.verify((Object)this.placeManager, (VerificationMode)Mockito.times((int)0))).goTo(randomPage);
    }

    @Test
    public void testGoToIndexWithSinglePage() {
        String randomPage = "randomPage";
        List<LayoutTemplate> templates = Arrays.asList(new LayoutTemplate(randomPage));
        this.runtimeScreen.goToIndex(templates);
        ((PlaceManager)Mockito.verify((Object)this.placeManager)).goTo(randomPage);
    }

    @Test
    public void testGoToIndexWithoutIndex() {
        List<LayoutTemplate> templates = Arrays.asList(new LayoutTemplate("page1"), new LayoutTemplate("page2"));
        this.runtimeScreen.goToIndex(templates);
        ((PlaceManager)Mockito.verify((Object)this.placeManager, (VerificationMode)Mockito.times((int)0))).goTo(ArgumentMatchers.anyString());
    }
}

