/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.backend.navigation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.dashbuilder.backend.navigation.RuntimeNavigationBuilder;
import org.dashbuilder.navigation.NavGroup;
import org.dashbuilder.navigation.NavItem;
import org.dashbuilder.navigation.NavItemContext;
import org.dashbuilder.navigation.NavTree;
import org.dashbuilder.navigation.impl.NavTreeBuilder;
import org.dashbuilder.navigation.workbench.NavWorkbenchCtx;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.uberfire.ext.layout.editor.api.editor.LayoutTemplate;

public class RuntimeNavigationBuilderTest {
    private static final String ITEM = "item1";
    private static final String GROUP = "group";
    private static final String EMPTY_GROUP = "emptyGroup";
    RuntimeNavigationBuilder runtimeNavigationBuilder;

    @Before
    public void init() {
        this.runtimeNavigationBuilder = new RuntimeNavigationBuilder();
    }

    @Test
    public void groupPruneTest() {
        NavTreeBuilder builder = new NavTreeBuilder();
        LayoutTemplate lt = new LayoutTemplate("lt1");
        String NOT_PRUNED_GROUP = "notemptygroup";
        String EMPTYCHILDGROUP = "emptychildgroup";
        String EMPTYONANONEMPTY = "empty_on_a_not_empty";
        builder.group(EMPTY_GROUP, "empty", "", false);
        builder.group("emptychildgroup", "", "", false);
        builder.endGroup();
        builder.endGroup();
        builder.group("notemptygroup", "notemptygroup", "", false);
        builder.item(ITEM, ITEM, "", false, (NavItemContext)NavWorkbenchCtx.perspective((String)lt.getName()));
        builder.group("empty_on_a_not_empty", "empty_on_a_not_empty", "", false);
        builder.endGroup();
        builder.endGroup();
        ArrayList<LayoutTemplate> templates = new ArrayList<LayoutTemplate>();
        templates.add(lt);
        NavTree originalTree = builder.build();
        Assert.assertEquals((long)2L, (long)originalTree.getRootItems().size());
        Assert.assertNotNull((Object)originalTree.getItemById("empty_on_a_not_empty"));
        Assert.assertNotNull((Object)originalTree.getItemById(EMPTY_GROUP));
        Assert.assertNotNull((Object)originalTree.getItemById("emptychildgroup"));
        NavTree runtimeTree = this.runtimeNavigationBuilder.buildRuntimeTree(originalTree, templates);
        Assert.assertNull((Object)runtimeTree.getItemById("empty_on_a_not_empty"));
        Assert.assertNull((Object)runtimeTree.getItemById(EMPTY_GROUP));
        Assert.assertNull((Object)runtimeTree.getItemById("emptychildgroup"));
        Assert.assertEquals((long)1L, (long)runtimeTree.getRootItems().size());
        NavGroup notPrunedGroup = (NavGroup)runtimeTree.getItemById("notemptygroup");
        NavItem item = runtimeTree.getItemById(ITEM);
        Assert.assertNotNull((Object)notPrunedGroup);
        Assert.assertNotNull((Object)item);
        Assert.assertEquals((Object)notPrunedGroup, (Object)item.getParent());
        Assert.assertEquals((long)1L, (long)notPrunedGroup.getChildren().size());
    }

    @Test
    public void removeItemWithoutTemplateTest() {
        NavTreeBuilder builder = new NavTreeBuilder();
        LayoutTemplate lt = new LayoutTemplate("lt1");
        String ITEM_TO_REMOVE = "item2";
        builder.group(GROUP, GROUP, "", false);
        builder.item(ITEM, ITEM, "", false, (NavItemContext)NavWorkbenchCtx.perspective((String)lt.getName()));
        builder.item("item2", "item2", "", false);
        builder.endGroup();
        NavTree originalTree = builder.build();
        Assert.assertNotNull((Object)originalTree.getItemById("item2"));
        ArrayList<LayoutTemplate> templates = new ArrayList<LayoutTemplate>();
        templates.add(lt);
        NavTree runtimeTree = this.runtimeNavigationBuilder.buildRuntimeTree(originalTree, templates);
        Assert.assertEquals((long)1L, (long)runtimeTree.getRootItems().size());
        NavGroup group = (NavGroup)runtimeTree.getItemById(GROUP);
        Assert.assertNotNull((Object)group);
        Assert.assertEquals((long)1L, (long)group.getChildren().size());
        Assert.assertNull((Object)runtimeTree.getItemById("item2"));
        Assert.assertNotNull((Object)runtimeTree.getItemById(ITEM));
    }

    @Test
    public void groupForOrphanItemsTest() {
        String ORPHAN_ITEM = "orphanitem";
        NavTreeBuilder builder = new NavTreeBuilder();
        LayoutTemplate lt = new LayoutTemplate("lt1");
        LayoutTemplate lt2 = new LayoutTemplate("orphanitem");
        String ITEM_TO_REMOVE = "item2";
        builder.group(GROUP, GROUP, "", false);
        builder.item(ITEM, ITEM, "", false, (NavItemContext)NavWorkbenchCtx.perspective((String)lt.getName()));
        builder.item("item2", "item2", "", false);
        builder.endGroup();
        List<LayoutTemplate> templates = Arrays.asList(lt, lt2);
        NavTree originalTree = builder.build();
        Assert.assertNull((Object)originalTree.getItemById("__runtime_dashboards"));
        Assert.assertEquals((long)1L, (long)originalTree.getRootItems().size());
        NavTree runtimeTree = this.runtimeNavigationBuilder.buildRuntimeTree(originalTree, templates);
        Assert.assertEquals((long)2L, (long)runtimeTree.getRootItems().size());
        NavGroup orphanItemsGroup = (NavGroup)runtimeTree.getItemById("__runtime_dashboards");
        Assert.assertNotNull((Object)orphanItemsGroup);
        Assert.assertEquals((long)1L, (long)orphanItemsGroup.getChildren().size());
        NavItem orphanItem = runtimeTree.getItemById("orphanitem");
        String resourceId = NavWorkbenchCtx.get((NavItem)orphanItem).getResourceId();
        Assert.assertEquals((Object)"orphanitem", (Object)resourceId);
        Assert.assertEquals((Object)orphanItemsGroup, (Object)orphanItem.getParent());
    }

    @Test
    public void treeForEmptyNavigationTest() {
        LayoutTemplate lt1 = new LayoutTemplate("lt1");
        LayoutTemplate lt2 = new LayoutTemplate("lt2");
        LayoutTemplate lt3 = new LayoutTemplate("lt3");
        List<LayoutTemplate> templates = Arrays.asList(lt1, lt2, lt3);
        NavTree runtimeTree = this.runtimeNavigationBuilder.build(Optional.empty(), templates);
        NavGroup orphanItemsGroup = (NavGroup)runtimeTree.getItemById("__runtime_dashboards");
        Assert.assertNotNull((Object)orphanItemsGroup);
        Assert.assertEquals((long)3L, (long)orphanItemsGroup.getChildren().size());
        Assert.assertTrue((boolean)this.containsLayoutTemplate(orphanItemsGroup, lt1));
        Assert.assertTrue((boolean)this.containsLayoutTemplate(orphanItemsGroup, lt2));
        Assert.assertTrue((boolean)this.containsLayoutTemplate(orphanItemsGroup, lt3));
    }

    private boolean containsLayoutTemplate(NavGroup group, LayoutTemplate lt) {
        return group.getChildren().stream().anyMatch(lt1 -> lt1.getName().equals(lt.getName()));
    }
}

