/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.backend;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.dashbuilder.backend.DataSetContentListener;
import org.dashbuilder.backend.services.dataset.RuntimeCSVFileStorage;
import org.dashbuilder.dataset.def.DataSetDef;
import org.dashbuilder.dataset.def.DataSetDefRegistry;
import org.dashbuilder.dataset.json.DataSetDefJSONMarshaller;
import org.dashbuilder.shared.event.NewDataSetContentEvent;
import org.dashbuilder.shared.event.RemovedRuntimeModelEvent;
import org.dashbuilder.shared.model.DataSetContent;
import org.dashbuilder.shared.model.DataSetContentType;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class DataSetContentListenerTest {
    @Mock
    DataSetDefRegistry registry;
    @Mock
    RuntimeCSVFileStorage storage;
    @Mock
    DataSetDefJSONMarshaller defMarshaller;
    @Mock
    Map<String, List<String>> runtimeModelDatasetContents;
    @InjectMocks
    DataSetContentListener datasetContentListener;

    @Test
    public void testRegister() throws Exception {
        String runtimeModelId = "TEST";
        String C1 = "C1";
        String C2 = "C2";
        String content2 = "TESTCONTENT";
        String content3 = "TESTCSV";
        List<DataSetContent> content = Arrays.asList(new DataSetContent("C1", "TESTCONTENT", DataSetContentType.DEFINITION), new DataSetContent("C2", "TESTCSV", DataSetContentType.CSV));
        List<String> contentIds = Arrays.asList("C1", "C2");
        DataSetDef def = (DataSetDef)Mockito.mock(DataSetDef.class);
        Mockito.when((Object)this.defMarshaller.fromJson(ArgumentMatchers.matches((String)"TESTCONTENT"))).thenReturn((Object)def);
        this.datasetContentListener.register(new NewDataSetContentEvent("TEST", content));
        ((Map)Mockito.verify(this.runtimeModelDatasetContents)).put("TEST", contentIds);
        ((RuntimeCSVFileStorage)Mockito.verify((Object)this.storage)).storeCSV("C2", "TESTCSV");
        ((DataSetDef)Mockito.verify((Object)def)).setUUID(ArgumentMatchers.matches((String)"C1"));
        ((DataSetDefRegistry)Mockito.verify((Object)this.registry)).registerDataSetDef(def);
    }

    @Test
    public void testUnregister() {
        String id = "ID";
        String C1 = "C1";
        List<String> registeredContent = Arrays.asList("C1");
        Mockito.when(this.runtimeModelDatasetContents.remove(ArgumentMatchers.matches((String)"ID"))).thenReturn(registeredContent);
        this.datasetContentListener.unregister(new RemovedRuntimeModelEvent("ID"));
        ((RuntimeCSVFileStorage)Mockito.verify((Object)this.storage)).deleteCSVFile(ArgumentMatchers.matches((String)"C1"));
        ((DataSetDefRegistry)Mockito.verify((Object)this.registry)).removeDataSetDef(ArgumentMatchers.matches((String)"C1"));
    }
}

