/*
 * Copyright 2021 Red Hat, Inc. and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.dashbuilder.shared.event;

import org.jboss.errai.common.client.api.annotations.MapsTo;
import org.jboss.errai.common.client.api.annotations.Portable;

/**
 * Fired only in dev mode when Runtime Models are updated
 *
 */
@Portable
public class UpdatedRuntimeModelEvent {

    /**
     * Updated runtime model ID
     */
    String runtimeModelId;
    
    public UpdatedRuntimeModelEvent() {
        // empty constructor for marshalling
    }

    public UpdatedRuntimeModelEvent(@MapsTo("id") String id) {
        this.runtimeModelId = id;
    }

    public String getRuntimeModelId() {
        return runtimeModelId;
    }

}