/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.client;

import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.dashbuilder.client.RuntimeClientLoader;
import org.dashbuilder.client.navigation.NavigationManager;
import org.dashbuilder.client.perspective.generator.RuntimePerspectiveGenerator;
import org.dashbuilder.client.plugins.RuntimePerspectivePluginManager;
import org.dashbuilder.navigation.NavTree;
import org.dashbuilder.shared.model.RuntimeModel;
import org.dashbuilder.shared.service.RuntimeModelService;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.ext.layout.editor.api.editor.LayoutTemplate;
import org.uberfire.ext.widgets.common.client.common.BusyIndicatorView;
import org.uberfire.mocks.CallerMock;
import org.uberfire.mvp.Command;

@RunWith(value=GwtMockitoTestRunner.class)
public class ClientRuntimeModelLoaderTest {
    CallerMock<RuntimeModelService> importModelServiceCaller;
    @Mock
    RuntimeModelService runtimeModelService;
    @Mock
    RuntimePerspectiveGenerator runtimePerspectiveGenerator;
    @Mock
    RuntimePerspectivePluginManager runtimePerspectivePluginManager;
    @Mock
    NavigationManager navigationManager;
    @Mock
    BusyIndicatorView loading;
    RuntimeClientLoader clientRuntimeModelLoader;

    @Before
    public void setup() {
        this.importModelServiceCaller = new CallerMock((Object)this.runtimeModelService);
        this.clientRuntimeModelLoader = new RuntimeClientLoader(this.importModelServiceCaller, this.runtimePerspectiveGenerator, this.runtimePerspectivePluginManager, this.navigationManager, this.loading);
    }

    @Test
    public void testLoadModelSuccess() {
        String modelId = "abc";
        LayoutTemplate perspective = (LayoutTemplate)Mockito.mock(LayoutTemplate.class);
        List<LayoutTemplate> perspectives = Arrays.asList(perspective);
        NavTree navTree = (NavTree)Mockito.mock(NavTree.class);
        RuntimeModel runtimeModel = new RuntimeModel(navTree, perspectives, Long.valueOf(System.currentTimeMillis()));
        Mockito.when((Object)this.runtimeModelService.getRuntimeModel((String)ArgumentMatchers.eq((Object)modelId))).thenReturn(Optional.of(runtimeModel));
        Consumer runtimeModelConsumer = (Consumer)Mockito.mock(Consumer.class);
        Command empty = (Command)Mockito.mock(Command.class);
        BiConsumer error = (BiConsumer)Mockito.mock(BiConsumer.class);
        this.clientRuntimeModelLoader.loadModel(modelId, runtimeModelConsumer, empty, error);
        ((Consumer)Mockito.verify((Object)runtimeModelConsumer)).accept(runtimeModel);
        ((RuntimePerspectiveGenerator)Mockito.verify((Object)this.runtimePerspectiveGenerator)).generatePerspective((LayoutTemplate)ArgumentMatchers.eq((Object)perspective));
        ((RuntimePerspectivePluginManager)Mockito.verify((Object)this.runtimePerspectivePluginManager)).setTemplates((List)ArgumentMatchers.eq(perspectives));
        ((NavigationManager)Mockito.verify((Object)this.navigationManager)).setDefaultNavTree(navTree);
        ((Command)Mockito.verify((Object)empty, (VerificationMode)Mockito.times((int)0))).execute();
        ((BiConsumer)Mockito.verify((Object)error, (VerificationMode)Mockito.times((int)0))).accept(ArgumentMatchers.any(), (Throwable)ArgumentMatchers.any());
    }

    @Test
    public void testLoadModelNotFound() {
        Mockito.when((Object)this.runtimeModelService.getRuntimeModel((String)ArgumentMatchers.any())).thenReturn(Optional.empty());
        Consumer runtimeModelConsumer = (Consumer)Mockito.mock(Consumer.class);
        Command empty = (Command)Mockito.mock(Command.class);
        BiConsumer error = (BiConsumer)Mockito.mock(BiConsumer.class);
        this.clientRuntimeModelLoader.loadModel("", runtimeModelConsumer, empty, error);
        ((Consumer)Mockito.verify((Object)runtimeModelConsumer, (VerificationMode)Mockito.times((int)0))).accept((RuntimeModel)ArgumentMatchers.any());
        ((Command)Mockito.verify((Object)empty, (VerificationMode)Mockito.times((int)1))).execute();
        ((BiConsumer)Mockito.verify((Object)error, (VerificationMode)Mockito.times((int)0))).accept(ArgumentMatchers.any(), (Throwable)ArgumentMatchers.any());
    }

    @Test
    public void testLoadModelError() {
        Mockito.when((Object)this.runtimeModelService.getRuntimeModel((String)ArgumentMatchers.any())).thenThrow(new Throwable[]{new RuntimeException()});
        Consumer runtimeModelConsumer = (Consumer)Mockito.mock(Consumer.class);
        Command empty = (Command)Mockito.mock(Command.class);
        BiConsumer error = (BiConsumer)Mockito.mock(BiConsumer.class);
        this.clientRuntimeModelLoader.loadModel("", runtimeModelConsumer, empty, error);
        ((Consumer)Mockito.verify((Object)runtimeModelConsumer, (VerificationMode)Mockito.times((int)0))).accept((RuntimeModel)ArgumentMatchers.any());
        ((Command)Mockito.verify((Object)empty, (VerificationMode)Mockito.times((int)0))).execute();
        ((BiConsumer)Mockito.verify((Object)error, (VerificationMode)Mockito.times((int)1))).accept(ArgumentMatchers.any(), (Throwable)ArgumentMatchers.any());
    }
}

