/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.dataset.backend;

import java.util.ArrayList;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.dashbuilder.dataset.ColumnType;
import org.dashbuilder.dataset.DataSetMetadata;
import org.dashbuilder.dataset.backend.BackendDataSetManager;
import org.dashbuilder.dataset.backend.DataSetDefGitStorage;
import org.dashbuilder.dataset.backend.EditDataSetDef;
import org.dashbuilder.dataset.backend.exception.ExceptionManager;
import org.dashbuilder.dataset.def.DataColumnDef;
import org.dashbuilder.dataset.def.DataSetDef;
import org.dashbuilder.dataset.service.DataSetDefVfsServices;
import org.jboss.errai.bus.server.annotations.Service;
import org.jboss.errai.security.shared.api.identity.User;
import org.uberfire.backend.vfs.Path;

@ApplicationScoped
@Service
public class DataSetDefVfsServicesImpl
implements DataSetDefVfsServices {
    @Inject
    protected User identity;
    @Inject
    protected DataSetDefGitStorage gitStorage;
    @Inject
    protected BackendDataSetManager dataSetManager;
    @Inject
    protected ExceptionManager exceptionManager;

    public EditDataSetDef load(Path path) {
        try {
            DataSetDef def = this.gitStorage.loadDataSetDef(path);
            if (def == null) {
                return null;
            }
            DataSetDef cloned = def.clone();
            boolean clonedAllColumns = cloned.isAllColumnsEnabled();
            List clonedColumns = cloned.getColumns();
            cloned.setAllColumnsEnabled(true);
            cloned.setColumns(null);
            DataSetMetadata _cd = this.dataSetManager.resolveProvider(cloned).getDataSetMetadata(cloned);
            ArrayList<DataColumnDef> columns = new ArrayList<DataColumnDef>();
            if (_cd.getNumberOfColumns() > 0) {
                for (int x = 0; x < _cd.getNumberOfColumns(); ++x) {
                    String cId = _cd.getColumnId(x);
                    ColumnType cType = _cd.getColumnType(x);
                    DataColumnDef cdef = new DataColumnDef(cId, cType);
                    columns.add(cdef);
                }
            }
            cloned.setAllColumnsEnabled(clonedAllColumns);
            cloned.setColumns(clonedColumns);
            return new EditDataSetDef(cloned, columns);
        }
        catch (Exception e) {
            throw this.exceptionManager.handleException(e);
        }
    }

    public Path save(DataSetDef definition, String commitMessage) {
        this.gitStorage.registerDataSetDef(definition, this.identity != null ? this.identity.getIdentifier() : "system", commitMessage);
        return definition.getVfsPath();
    }

    public Path copy(Path path, String newName, String commitMessage) {
        DataSetDef def = this.gitStorage.loadDataSetDef(path);
        if (def == null) {
            throw this.exceptionManager.handleException(new Exception("Data set definition not found: " + path.getFileName()));
        }
        DataSetDef clone = this.gitStorage.copyDataSetDef(def, newName, this.identity != null ? this.identity.getIdentifier() : "system", commitMessage);
        return clone.getVfsPath();
    }

    public void delete(Path path, String commitMessage) {
        this.gitStorage.removeDataSetDef(path, this.identity != null ? this.identity.getIdentifier() : "system", commitMessage);
    }
}

