/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.dataset.backend;

import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.dashbuilder.dataset.DataSet;
import org.dashbuilder.dataset.DataSetLookup;
import org.dashbuilder.dataset.DataSetMetadata;
import org.dashbuilder.dataset.backend.BackendDataSetManager;
import org.dashbuilder.dataset.backend.BackendUUIDGenerator;
import org.dashbuilder.dataset.backend.exception.ExceptionManager;
import org.dashbuilder.dataset.def.DataSetDef;
import org.dashbuilder.dataset.exception.DataSetLookupException;
import org.dashbuilder.dataset.service.DataSetLookupServices;
import org.jboss.errai.bus.server.annotations.Service;
import org.slf4j.Logger;

@ApplicationScoped
@Service
public class DataSetLookupServicesImpl
implements DataSetLookupServices {
    @Inject
    protected Logger log;
    @Inject
    protected ExceptionManager exceptionManager;
    @Inject
    protected BackendDataSetManager dataSetManager;
    @Inject
    protected BackendUUIDGenerator backendUUIDGenerator;

    public DataSet lookupDataSet(DataSetLookup lookup) throws Exception {
        DataSet _d = null;
        try {
            _d = this.dataSetManager.lookupDataSet(lookup);
        }
        catch (DataSetLookupException e) {
            throw this.exceptionManager.handleException((Exception)((Object)e));
        }
        return _d;
    }

    public DataSet lookupDataSet(DataSetDef def, DataSetLookup lookup) throws Exception {
        try {
            if (def.getUUID() == null) {
                String uuid = this.backendUUIDGenerator.newUuid();
                def.setUUID(uuid);
                lookup.setDataSetUUID(uuid);
            }
            return this.dataSetManager.resolveProvider(def).lookupDataSet(def, lookup);
        }
        catch (Exception e) {
            throw this.exceptionManager.handleException(e);
        }
    }

    public DataSetMetadata lookupDataSetMetadata(String uuid) throws Exception {
        DataSetMetadata _d = null;
        try {
            _d = this.dataSetManager.getDataSetMetadata(uuid);
        }
        catch (DataSetLookupException e) {
            throw this.exceptionManager.handleException((Exception)((Object)e));
        }
        return _d;
    }
}

