/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.dataset.backend;

import au.com.bytecode.opencsv.CSVWriter;
import java.io.BufferedWriter;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.apache.poi.ss.usermodel.BuiltinFormats;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.PrintSetup;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.DateFormatConverter;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.dashbuilder.dataset.DataColumn;
import org.dashbuilder.dataset.DataSet;
import org.dashbuilder.dataset.DataSetLookup;
import org.dashbuilder.dataset.backend.BackendDataSetManager;
import org.dashbuilder.dataset.backend.DataSetDefGitStorage;
import org.dashbuilder.dataset.backend.exception.ExceptionManager;
import org.dashbuilder.dataset.group.Interval;
import org.dashbuilder.dataset.service.DataSetExportServices;
import org.dashbuilder.dataset.uuid.UUIDGenerator;
import org.jboss.errai.bus.server.annotations.Service;
import org.slf4j.Logger;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.java.nio.file.Files;
import org.uberfire.java.nio.file.OpenOption;
import org.uberfire.java.nio.file.Path;

@ApplicationScoped
@Service
public class DataSetExportServicesImpl
implements DataSetExportServices {
    @Inject
    protected Logger log;
    @Inject
    protected BackendDataSetManager dataSetManager;
    @Inject
    protected DataSetDefGitStorage gitStorage;
    @Inject
    protected UUIDGenerator uuidGenerator;
    @Inject
    protected ExceptionManager exceptionManager;
    protected String DEFAULT_SEPARATOR_CHAR = ";";
    protected String DEFAULT_QUOTE_CHAR = "\"";
    protected String DEFAULT_ESCAPE_CHAR = "\\";
    protected String dateFormatPattern = "dd/MM/yyyy HH:mm:ss";
    protected String numberFormatPattern = "#,###.##########";
    protected DecimalFormat decf = new DecimalFormat(this.numberFormatPattern);
    protected DateFormat datef = new SimpleDateFormat(this.dateFormatPattern);

    public org.uberfire.backend.vfs.Path exportDataSetCSV(DataSetLookup lookup) {
        DataSet dataSet = this.dataSetManager.lookupDataSet(lookup);
        return this.exportDataSetCSV(dataSet);
    }

    public org.uberfire.backend.vfs.Path exportDataSetCSV(DataSet dataSet) {
        try {
            if (dataSet == null) {
                throw new IllegalArgumentException("Null dataSet specified!");
            }
            int columnCount = dataSet.getColumns().size();
            int rowCount = dataSet.getRowCount();
            ArrayList<String[]> lines = new ArrayList<String[]>(rowCount + 1);
            String[] line = new String[columnCount];
            for (int cc = 0; cc < columnCount; ++cc) {
                DataColumn dc = dataSet.getColumnByIndex(cc);
                line[cc] = dc.getId();
            }
            lines.add(line);
            for (int rc = 0; rc < rowCount; ++rc) {
                line = new String[columnCount];
                for (int cc = 0; cc < columnCount; ++cc) {
                    line[cc] = this.formatAsString(dataSet.getValueAt(rc, cc));
                }
                lines.add(line);
            }
            String tempCsvFile = this.uuidGenerator.newUuid() + ".csv";
            Path tempCsvPath = this.gitStorage.createTempFile(tempCsvFile);
            BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(Files.newOutputStream((Path)tempCsvPath, (OpenOption[])new OpenOption[0])));
            CSVWriter writer = new CSVWriter((Writer)bw, this.DEFAULT_SEPARATOR_CHAR.charAt(0), this.DEFAULT_QUOTE_CHAR.charAt(0), this.DEFAULT_ESCAPE_CHAR.charAt(0));
            writer.writeAll(lines);
            writer.close();
            writer.flush();
            writer.close();
            return Paths.convert((Path)tempCsvPath);
        }
        catch (Exception e) {
            throw this.exceptionManager.handleException(e);
        }
    }

    public org.uberfire.backend.vfs.Path exportDataSetExcel(DataSetLookup dataSetLookup) {
        DataSet dataSet = this.dataSetManager.lookupDataSet(dataSetLookup);
        return this.exportDataSetExcel(dataSet);
    }

    public org.uberfire.backend.vfs.Path exportDataSetExcel(DataSet dataSet) {
        try {
            int i;
            if (dataSet == null) {
                throw new IllegalArgumentException("Null dataSet specified!");
            }
            int columnCount = dataSet.getColumns().size();
            int rowCount = dataSet.getRowCount() + 1;
            int row = 0;
            SXSSFWorkbook wb = new SXSSFWorkbook(100);
            Map<String, CellStyle> styles = this.createStyles((Workbook)wb);
            Sheet sh = wb.createSheet("Sheet 1");
            sh.setDisplayGridlines(true);
            sh.setPrintGridlines(false);
            sh.setFitToPage(true);
            sh.setHorizontallyCenter(true);
            PrintSetup printSetup = sh.getPrintSetup();
            printSetup.setLandscape(true);
            Row header = sh.createRow(row++);
            header.setHeightInPoints(20.0f);
            for (i = 0; i < columnCount; ++i) {
                Cell cell = header.createCell(i);
                cell.setCellStyle(styles.get("header"));
                cell.setCellValue(dataSet.getColumnByIndex(i).getId());
            }
            while (row < rowCount) {
                Row _row = sh.createRow(row);
                for (int cellnum = 0; cellnum < columnCount; ++cellnum) {
                    Cell cell = _row.createCell(cellnum);
                    Object value = dataSet.getValueAt(row - 1, cellnum);
                    if (value instanceof Short || value instanceof Long || value instanceof Integer || value instanceof BigInteger) {
                        cell.setCellType(0);
                        cell.setCellStyle(styles.get("integer_number_cell"));
                        cell.setCellValue(((Number)value).doubleValue());
                        continue;
                    }
                    if (value instanceof Float || value instanceof Double || value instanceof BigDecimal) {
                        cell.setCellType(0);
                        cell.setCellStyle(styles.get("decimal_number_cell"));
                        cell.setCellValue(((Number)value).doubleValue());
                        continue;
                    }
                    if (value instanceof Date) {
                        cell.setCellType(1);
                        cell.setCellStyle(styles.get("date_cell"));
                        cell.setCellValue((Date)value);
                        continue;
                    }
                    if (value instanceof Interval) {
                        cell.setCellType(1);
                        cell.setCellStyle(styles.get("text_cell"));
                        cell.setCellValue(((Interval)value).getName());
                        continue;
                    }
                    cell.setCellType(1);
                    cell.setCellStyle(styles.get("text_cell"));
                    cell.setCellValue(value.toString());
                }
                ++row;
            }
            for (i = 0; i < columnCount; ++i) {
                sh.autoSizeColumn(i);
            }
            String tempXlsFile = this.uuidGenerator.newUuid() + ".xlsx";
            Path tempXlsPath = this.gitStorage.createTempFile(tempXlsFile);
            OutputStream os = Files.newOutputStream((Path)tempXlsPath, (OpenOption[])new OpenOption[0]);
            wb.write(os);
            os.flush();
            os.close();
            if (!wb.dispose()) {
                this.log.warn("Could not dispose of temporary file associated to data export!");
            }
            return Paths.convert((Path)tempXlsPath);
        }
        catch (Exception e) {
            throw this.exceptionManager.handleException(e);
        }
    }

    private String formatAsString(Object value) {
        if (value == null) {
            return "";
        }
        if (value instanceof Number) {
            return this.decf.format(value);
        }
        if (value instanceof Date) {
            return this.datef.format(value);
        }
        if (value instanceof Interval) {
            return ((Interval)value).getName();
        }
        return value.toString();
    }

    private Map<String, CellStyle> createStyles(Workbook wb) {
        HashMap<String, CellStyle> styles = new HashMap<String, CellStyle>();
        Font titleFont = wb.createFont();
        titleFont.setFontHeightInPoints((short)12);
        titleFont.setBoldweight((short)700);
        CellStyle style = wb.createCellStyle();
        style.setAlignment((short)2);
        style.setVerticalAlignment((short)1);
        style.setFillForegroundColor(IndexedColors.GREY_25_PERCENT.getIndex());
        style.setFillPattern((short)1);
        style.setFont(titleFont);
        style.setWrapText(false);
        style.setBorderBottom((short)1);
        style.setBottomBorderColor(IndexedColors.GREY_80_PERCENT.getIndex());
        styles.put("header", style);
        Font cellFont = wb.createFont();
        cellFont.setFontHeightInPoints((short)10);
        cellFont.setBoldweight((short)400);
        style = wb.createCellStyle();
        style.setAlignment((short)3);
        style.setVerticalAlignment((short)2);
        style.setFont(cellFont);
        style.setWrapText(false);
        style.setDataFormat(wb.createDataFormat().getFormat(BuiltinFormats.getBuiltinFormat((int)3)));
        styles.put("integer_number_cell", style);
        style = wb.createCellStyle();
        style.setAlignment((short)3);
        style.setVerticalAlignment((short)2);
        style.setFont(cellFont);
        style.setWrapText(false);
        style.setDataFormat(wb.createDataFormat().getFormat(BuiltinFormats.getBuiltinFormat((int)4)));
        styles.put("decimal_number_cell", style);
        style = wb.createCellStyle();
        style.setAlignment((short)1);
        style.setVerticalAlignment((short)2);
        style.setFont(cellFont);
        style.setWrapText(false);
        style.setDataFormat((short)BuiltinFormats.getBuiltinFormat((String)"text"));
        styles.put("text_cell", style);
        style = wb.createCellStyle();
        style.setAlignment((short)2);
        style.setVerticalAlignment((short)2);
        style.setFont(cellFont);
        style.setWrapText(false);
        style.setDataFormat(wb.createDataFormat().getFormat(DateFormatConverter.convert((Locale)Locale.getDefault(), (String)this.dateFormatPattern)));
        styles.put("date_cell", style);
        return styles;
    }
}

