/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.dataset.backend;

import java.io.File;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.servlet.ServletContext;
import org.dashbuilder.dataprovider.DataSetProviderType;
import org.dashbuilder.dataset.backend.BackendDataSetManager;
import org.dashbuilder.dataset.backend.BackendUUIDGenerator;
import org.dashbuilder.dataset.backend.DataSetDefDeployer;
import org.dashbuilder.dataset.backend.exception.ExceptionManager;
import org.dashbuilder.dataset.def.DataSetDef;
import org.dashbuilder.dataset.def.DataSetDefRegistry;
import org.dashbuilder.dataset.service.DataSetDefServices;
import org.jboss.errai.bus.server.annotations.Service;
import org.jboss.errai.bus.server.api.RpcContext;
import org.jboss.errai.security.shared.api.identity.User;
import org.slf4j.Logger;

@ApplicationScoped
@Service
public class DataSetDefServicesImpl
implements DataSetDefServices {
    @Inject
    protected Logger log;
    @Inject
    protected DataSetDefRegistry dataSetDefRegistry;
    @Inject
    protected BackendDataSetManager dataSetManager;
    @Inject
    protected BackendUUIDGenerator backendUUIDGenerator;
    @Inject
    protected ExceptionManager exceptionManager;
    @Inject
    protected User identity;
    @Inject
    protected DataSetDefDeployer dataSetDefDeployer;

    @PostConstruct
    protected void init() {
        String dir;
        ServletContext servletContext = RpcContext.getHttpSession().getServletContext();
        if (!this.dataSetDefDeployer.isRunning() && servletContext != null && (dir = servletContext.getRealPath("WEB-INF/datasets")) != null && new File(dir).exists()) {
            dir = dir.replaceAll("\\\\", "/");
            this.dataSetDefDeployer.deploy(dir);
        }
    }

    public List<DataSetDef> getPublicDataSetDefs() {
        return this.dataSetDefRegistry.getDataSetDefs(true);
    }

    public DataSetDef createDataSetDef(DataSetProviderType type) {
        DataSetDef result = new DataSetDef();
        if (type != null) {
            result = DataSetProviderType.createDataSetDef((DataSetProviderType)type);
        }
        result.setUUID(this.backendUUIDGenerator.newUuid());
        return result;
    }

    public String registerDataSetDef(DataSetDef definition, String comment) {
        if (definition.getUUID() == null) {
            String uuid = this.backendUUIDGenerator.newUuid();
            definition.setUUID(uuid);
        }
        this.dataSetDefRegistry.registerDataSetDef(definition, this.identity != null ? this.identity.getIdentifier() : "---", comment);
        return definition.getUUID();
    }

    public void removeDataSetDef(String uuid, String comment) {
        DataSetDef def = this.dataSetDefRegistry.getDataSetDef(uuid);
        if (def != null) {
            this.dataSetDefRegistry.removeDataSetDef(uuid, this.identity != null ? this.identity.getIdentifier() : "---", comment);
        }
    }
}

