/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.dataset.backend;

import java.io.File;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.Reader;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.dashbuilder.config.Config;
import org.dashbuilder.dataprovider.DataSetProviderRegistry;
import org.dashbuilder.dataset.backend.DataSetDefJSONMarshaller;
import org.dashbuilder.dataset.def.CSVDataSetDef;
import org.dashbuilder.dataset.def.DataSetDef;
import org.dashbuilder.dataset.def.DataSetDefRegistry;
import org.slf4j.Logger;

@ApplicationScoped
public class DataSetDefDeployer {
    @Inject
    @Config(value="")
    protected String directory;
    @Inject
    @Config(value="3000")
    protected int pollingTime;
    @Inject
    protected DataSetDefRegistry dataSetDefRegistry;
    @Inject
    protected DataSetProviderRegistry dataSetProviderRegistry;
    @Inject
    protected DataSetDefJSONMarshaller jsonMarshaller;
    @Inject
    protected Logger log;
    protected Thread watcherThread;
    FilenameFilter _deployFilter = new FilenameFilter(){

        @Override
        public boolean accept(File dir, String name) {
            return name.endsWith(".deploy");
        }
    };
    FilenameFilter _undeployFilter = new FilenameFilter(){

        @Override
        public boolean accept(File dir, String name) {
            return name.endsWith(".undeploy");
        }
    };

    public String getDirectory() {
        return this.directory;
    }

    public boolean isRunning() {
        return !StringUtils.isBlank((CharSequence)this.directory);
    }

    @PostConstruct
    protected void init() {
        if (!StringUtils.isBlank((CharSequence)this.directory)) {
            this.deploy(this.directory);
        }
    }

    @PreDestroy
    public synchronized void stop() {
        this.directory = null;
    }

    public synchronized void deploy(String dir) {
        if (this.validateDirectory(dir)) {
            this.log.info("Data sets deployment directory = " + dir);
            this.directory = dir;
            this.doDeploy();
            if (this.pollingTime > 0) {
                this.watcherThread = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        while (DataSetDefDeployer.this.directory != null) {
                            try {
                                Thread.sleep(DataSetDefDeployer.this.pollingTime);
                                DataSetDefDeployer.this.doDeploy();
                            }
                            catch (InterruptedException e) {
                                DataSetDefDeployer.this.log.error("Data set watcher thread error.", (Throwable)e);
                            }
                        }
                    }
                });
                this.watcherThread.start();
            }
        } else {
            this.log.warn("Data sets deployment directory invalid: " + dir);
            this.directory = null;
        }
    }

    protected boolean validateDirectory(String dir) {
        if (StringUtils.isBlank((CharSequence)dir)) {
            return false;
        }
        File rootDir = new File(dir);
        if (!rootDir.exists()) {
            return false;
        }
        return rootDir.isDirectory();
    }

    protected synchronized void doDeploy() {
        if (StringUtils.isBlank((CharSequence)this.directory)) {
            return;
        }
        File[] files = new File(this.directory).listFiles(this._deployFilter);
        if (files != null) {
            for (File f : files) {
                try {
                    DataSetDef existingDef;
                    f.delete();
                    File dsetFile = new File(f.getAbsolutePath().replace(".deploy", ""));
                    if (!dsetFile.exists()) continue;
                    FileReader fileReader = new FileReader(dsetFile);
                    String json = IOUtils.toString((Reader)fileReader);
                    DataSetDef def = this.jsonMarshaller.fromJson(json);
                    if (StringUtils.isBlank((CharSequence)def.getUUID())) {
                        def.setUUID(dsetFile.getName());
                    }
                    if (def instanceof CSVDataSetDef) {
                        CSVDataSetDef csvDef = (CSVDataSetDef)def;
                        File csvFile = this.getCSVFile(csvDef);
                        if (csvFile != null) {
                            csvDef.setFilePath(csvFile.getAbsolutePath());
                        } else {
                            this.log.error("Data set CSV file not found: " + f.getName());
                            continue;
                        }
                    }
                    if ((existingDef = this.dataSetDefRegistry.getDataSetDef(def.getUUID())) != null && this.jsonMarshaller.toJsonString(existingDef).equals(this.jsonMarshaller.toJsonString(def))) {
                        this.log.info("Data set already deployed: " + def.getUUID());
                        continue;
                    }
                    this.dataSetDefRegistry.registerDataSetDef(def, "system", "deploy(" + def.getUUID() + ")");
                    this.log.info("Data set deployed: " + def.getUUID());
                }
                catch (Exception e) {
                    this.log.error("Data set deployment error: " + f.getName(), (Throwable)e);
                }
            }
        }
        if ((files = new File(this.directory).listFiles(this._undeployFilter)) != null) {
            for (File f : files) {
                try {
                    f.delete();
                    String uuid = f.getName().replace(".undeploy", "");
                    DataSetDef def = this.dataSetDefRegistry.getDataSetDef(uuid);
                    if (def != null) {
                        this.dataSetDefRegistry.removeDataSetDef(uuid, "system", "undeploy(" + uuid + ")");
                        this.log.info("Data set deleted: " + def.getName());
                        continue;
                    }
                    this.log.error("Data set not found: " + uuid);
                }
                catch (Exception e) {
                    this.log.error("Data set un-deploy error: " + f.getName(), (Throwable)e);
                }
            }
        }
    }

    public File getCSVFile(CSVDataSetDef def) throws Exception {
        String path = def.getFilePath();
        if (StringUtils.isBlank((CharSequence)path)) {
            return null;
        }
        File f = new File(path);
        if (f.exists()) {
            return f;
        }
        f = new File(this.directory, path);
        if (f.exists()) {
            return f;
        }
        return null;
    }
}

