/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.dataset.service;

import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.dashbuilder.DataSetCore;
import org.dashbuilder.dataprovider.DataSetProviderType;
import org.dashbuilder.dataset.DataSetDefRegistryCDI;
import org.dashbuilder.dataset.def.DataSetDef;
import org.dashbuilder.dataset.service.DataSetDefServices;
import org.dashbuilder.dataset.uuid.UUIDGenerator;
import org.dashbuilder.exception.ExceptionManager;
import org.jboss.errai.bus.server.annotations.Service;
import org.jboss.errai.security.shared.api.identity.User;
import org.slf4j.Logger;

@ApplicationScoped
@Service
public class DataSetDefServicesImpl
implements DataSetDefServices {
    protected Logger log;
    protected User identity;
    protected ExceptionManager exceptionManager;
    protected UUIDGenerator uuidGenerator;
    protected DataSetDefRegistryCDI dataSetDefRegistry;

    public DataSetDefServicesImpl() {
    }

    @Inject
    public DataSetDefServicesImpl(Logger log, User identity, ExceptionManager exceptionManager, DataSetDefRegistryCDI dataSetDefRegistry) {
        this.log = log;
        this.identity = identity;
        this.uuidGenerator = DataSetCore.get().getUuidGenerator();
        this.dataSetDefRegistry = dataSetDefRegistry;
        this.exceptionManager = exceptionManager;
    }

    public List<DataSetDef> getPublicDataSetDefs() {
        return this.dataSetDefRegistry.getDataSetDefs(true);
    }

    public DataSetDef createDataSetDef(DataSetProviderType type) {
        DataSetDef result = new DataSetDef();
        if (type != null) {
            result = DataSetProviderType.createDataSetDef((DataSetProviderType)type);
        }
        result.setUUID(this.uuidGenerator.newUuid());
        return result;
    }

    public String registerDataSetDef(DataSetDef definition, String comment) {
        if (definition.getUUID() == null) {
            String uuid = this.uuidGenerator.newUuid();
            definition.setUUID(uuid);
        }
        this.dataSetDefRegistry.registerDataSetDef(definition, this.identity != null ? this.identity.getIdentifier() : "---", comment);
        return definition.getUUID();
    }

    public void removeDataSetDef(String uuid, String comment) {
        DataSetDef def = this.dataSetDefRegistry.getDataSetDef(uuid);
        if (def != null) {
            this.dataSetDefRegistry.removeDataSetDef(uuid, this.identity != null ? this.identity.getIdentifier() : "---", comment);
        }
    }
}

