/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.dataset.service;

import org.apache.poi.xssf.streaming.SXSSFRow;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.dashbuilder.dataset.DataSet;
import org.dashbuilder.dataset.DataSetDefRegistryCDI;
import org.dashbuilder.dataset.DataSetFactory;
import org.dashbuilder.dataset.DataSetManagerCDI;
import org.dashbuilder.dataset.service.DataSetExportServicesImpl;
import org.dashbuilder.exception.ExceptionManager;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class DataSetExportServicesTest {
    private static final String JAVA_AWT_HEADLESS_PROPERTY = "java.awt.headless";
    private static String originalJavaAwtHeadless;
    @Mock
    DataSetManagerCDI dataSetManagerM;
    @Mock
    DataSetDefRegistryCDI gitStorageM;
    @Mock
    ExceptionManager exceptionManagerM;

    @BeforeClass
    public static void setUp() {
        originalJavaAwtHeadless = System.getProperty(JAVA_AWT_HEADLESS_PROPERTY);
        System.setProperty(JAVA_AWT_HEADLESS_PROPERTY, "true");
    }

    @AfterClass
    public static void tearDown() {
        if (originalJavaAwtHeadless == null) {
            System.clearProperty(JAVA_AWT_HEADLESS_PROPERTY);
        } else {
            System.setProperty(JAVA_AWT_HEADLESS_PROPERTY, originalJavaAwtHeadless);
        }
    }

    @Test
    public void exportToExcelWorksWhenDataSetHasNulls() {
        DataSetExportServicesImpl exporter = new DataSetExportServicesImpl(this.dataSetManagerM, this.gitStorageM, this.exceptionManagerM);
        DataSet dataSetWithNulls = DataSetFactory.newDataSetBuilder().date("Date of birth").number("Age").text("Description").row(new Object[]{null, null, null}).buildDataSet();
        SXSSFWorkbook workbook = exporter.dataSetToWorkbook(dataSetWithNulls);
        Assert.assertNotNull((String)"Export of dataset containing null should succeed", (Object)workbook);
        SXSSFRow firstRow = workbook.getSheetAt(0).getRow(0);
        Assert.assertEquals((Object)"Date of birth", (Object)firstRow.getCell(0).getStringCellValue());
        Assert.assertEquals((Object)"Age", (Object)firstRow.getCell(1).getStringCellValue());
        Assert.assertEquals((Object)"Description", (Object)firstRow.getCell(2).getStringCellValue());
        SXSSFRow secondRow = workbook.getSheetAt(0).getRow(1);
        Assert.assertEquals((Object)"", (Object)secondRow.getCell(0).getStringCellValue());
        Assert.assertEquals((Object)"", (Object)secondRow.getCell(1).getStringCellValue());
        Assert.assertEquals((Object)"", (Object)secondRow.getCell(2).getStringCellValue());
    }
}

