/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.transfer;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.enterprise.event.Event;
import org.dashbuilder.dataset.DataSetDefRegistryCDI;
import org.dashbuilder.dataset.def.DataSetDef;
import org.dashbuilder.dataset.events.DataSetDefRegisteredEvent;
import org.dashbuilder.dataset.json.DataSetDefJSONMarshaller;
import org.dashbuilder.external.model.ExternalComponent;
import org.dashbuilder.external.service.ComponentLoader;
import org.dashbuilder.navigation.event.NavTreeChangedEvent;
import org.dashbuilder.navigation.storage.NavTreeStorage;
import org.dashbuilder.transfer.DataTransferExportModel;
import org.dashbuilder.transfer.DataTransferServices;
import org.dashbuilder.transfer.DataTransferServicesImpl;
import org.dashbuilder.transfer.ExportInfo;
import org.dashbuilder.transfer.LayoutComponentHelper;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.lesscss.deps.org.apache.commons.io.FileUtils;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.uberfire.ext.plugin.event.PluginAdded;
import org.uberfire.io.IOService;
import org.uberfire.io.impl.IOServiceDotFileImpl;
import org.uberfire.java.nio.IOException;
import org.uberfire.java.nio.file.DeleteOption;
import org.uberfire.java.nio.file.FileSystem;
import org.uberfire.java.nio.file.FileVisitResult;
import org.uberfire.java.nio.file.FileVisitor;
import org.uberfire.java.nio.file.Files;
import org.uberfire.java.nio.file.OpenOption;
import org.uberfire.java.nio.file.Path;
import org.uberfire.java.nio.file.Paths;
import org.uberfire.java.nio.file.SimpleFileVisitor;
import org.uberfire.java.nio.file.attribute.BasicFileAttributes;
import org.uberfire.java.nio.file.attribute.FileAttribute;
import org.uberfire.rpc.SessionInfo;
import org.uberfire.spaces.SpacesAPI;

@RunWith(value=MockitoJUnitRunner.Silent.class)
public class DataTransferServicesTest {
    private IOService ioService;
    private FileSystem datasetsFS;
    private FileSystem perspectivesFS;
    private FileSystem navigationFS;
    private FileSystem systemFS;
    private DataTransferServices dataTransferServices;
    @Mock
    private DataSetDefRegistryCDI dataSetDefRegistryCDI;
    @Mock
    private Event<DataSetDefRegisteredEvent> dataSetDefRegisteredEvent;
    @Mock
    private Event<PluginAdded> pluginAddedEvent;
    @Mock
    SessionInfo sessionInfo;
    @Mock
    private Event<NavTreeChangedEvent> navTreeChangedEvent;
    @Mock
    private NavTreeStorage navTreeStorage;
    @Mock
    DataSetDefJSONMarshaller dataSetDefJSONMarshaller;
    @Mock
    ComponentLoader externalComponentLoader;
    @Mock
    LayoutComponentHelper layoutComponentsHelper;
    Path componentsDir;

    @Before
    public void setup() {
        this.ioService = new IOServiceDotFileImpl();
        this.componentsDir = Files.createTempDirectory((String)"dashbuilder-components", (FileAttribute[])new FileAttribute[0]);
        this.datasetsFS = this.createFileSystem("datasets");
        this.perspectivesFS = this.createFileSystem("perspectives");
        this.navigationFS = this.createFileSystem("navigation");
        this.systemFS = this.createFileSystem("system");
        Mockito.when((Object)this.dataSetDefRegistryCDI.getDataSetDefJsonMarshaller()).thenReturn((Object)this.dataSetDefJSONMarshaller);
        Mockito.when((Object)this.externalComponentLoader.getExternalComponentsDir()).thenReturn((Object)this.componentsDir.toString());
        Mockito.when((Object)this.externalComponentLoader.isExternalComponentsEnabled()).thenReturn((Object)true);
        this.dataTransferServices = new DataTransferServicesImpl(this.ioService, this.datasetsFS, this.perspectivesFS, this.navigationFS, this.systemFS, this.dataSetDefRegistryCDI, this.sessionInfo, this.dataSetDefRegisteredEvent, this.pluginAddedEvent, this.navTreeChangedEvent, this.navTreeStorage, this.externalComponentLoader, this.layoutComponentsHelper);
    }

    @After
    public void cleanFileSystems() {
        this.cleanFileSystem(this.datasetsFS);
        this.cleanFileSystem(this.perspectivesFS);
        this.cleanFileSystem(this.navigationFS);
        this.cleanFileSystem(this.systemFS);
        FileUtils.deleteQuietly((File)this.componentsDir.toFile());
    }

    @Test
    public void testDoExportEmptyFileSystems() throws Exception {
        String exportPath = this.dataTransferServices.doExport(DataTransferExportModel.exportAll());
        Assert.assertTrue((boolean)exportPath.equals(this.getExpectedExportFileSystemPath()));
        Assert.assertEquals((Object)new ArrayList<String>(){
            {
                this.add(DataTransferServicesTest.this.getExpectedExportFilePath());
                this.add("/readme.md");
            }
        }, this.getFiles(this.systemFS));
        ZipInputStream zis = this.getZipInputStream();
        Assert.assertEquals((Object)new ArrayList<String>(){
            {
                this.add(DataTransferServicesTest.this.datasetsFS.getName() + "/readme.md");
                this.add(DataTransferServicesTest.this.perspectivesFS.getName() + "/readme.md");
                this.add(DataTransferServicesTest.this.navigationFS.getName() + "/readme.md");
                this.add("VERSION");
            }
        }, this.getFiles(zis));
    }

    @Test
    public void testDoExportNotEmptyFileSystems() throws Exception {
        this.createFile(this.datasetsFS, "definitions/dataset1.csv", "Test 1");
        this.createFile(this.datasetsFS, "definitions/dataset1.dset", "Test ABC");
        this.createFile(this.perspectivesFS, "page1/perspective_layout", "Test Page 1");
        this.createFile(this.perspectivesFS, "page1/perspective_layout.plugin", "Test Page 1 Plugin");
        this.createFile(this.navigationFS, "navtree.json", "{ }");
        String exportPath = this.dataTransferServices.doExport(DataTransferExportModel.exportAll());
        Assert.assertTrue((boolean)exportPath.equals(this.getExpectedExportFileSystemPath()));
        Assert.assertEquals((Object)new ArrayList<String>(){
            {
                this.add(DataTransferServicesTest.this.getExpectedExportFilePath());
                this.add("/readme.md");
            }
        }, this.getFiles(this.systemFS));
        ZipInputStream zis = this.getZipInputStream();
        Assert.assertEquals((Object)new ArrayList<String>(){
            {
                this.add(DataTransferServicesTest.this.datasetsFS.getName() + "/definitions/dataset1.csv");
                this.add(DataTransferServicesTest.this.datasetsFS.getName() + "/definitions/dataset1.dset");
                this.add(DataTransferServicesTest.this.datasetsFS.getName() + "/readme.md");
                this.add(DataTransferServicesTest.this.perspectivesFS.getName() + "/page1/perspective_layout");
                this.add(DataTransferServicesTest.this.perspectivesFS.getName() + "/page1/perspective_layout.plugin");
                this.add(DataTransferServicesTest.this.perspectivesFS.getName() + "/readme.md");
                this.add(DataTransferServicesTest.this.navigationFS.getName() + "/navtree.json");
                this.add(DataTransferServicesTest.this.navigationFS.getName() + "/readme.md");
                this.add("VERSION");
            }
        }, this.getFiles(zis));
    }

    @Test
    public void testDoExportFilteringDataSets() throws Exception {
        this.createFile(this.datasetsFS, "definitions/dataset1.csv", "");
        this.createFile(this.datasetsFS, "definitions/dataset1.dset", "");
        this.createFile(this.datasetsFS, "definitions/dataset2.dset", "");
        this.createFile(this.perspectivesFS, "page1/perspective_layout", "");
        this.createFile(this.perspectivesFS, "page1/perspective_layout.plugin", "");
        this.createFile(this.navigationFS, "navtree.json", "");
        DataSetDef def = (DataSetDef)Mockito.mock(DataSetDef.class);
        Mockito.when((Object)def.getUUID()).thenReturn((Object)"dataset1");
        DataTransferExportModel model = new DataTransferExportModel(Arrays.asList(def), Arrays.asList("page1", "page2"), true);
        String exportPath = this.dataTransferServices.doExport(model);
        Assert.assertTrue((boolean)exportPath.equals(this.getExpectedExportFileSystemPath()));
        ZipInputStream zis = this.getZipInputStream();
        Assert.assertEquals((Object)new ArrayList<String>(){
            {
                this.add(DataTransferServicesTest.this.datasetsFS.getName() + "/definitions/dataset1.csv");
                this.add(DataTransferServicesTest.this.datasetsFS.getName() + "/definitions/dataset1.dset");
                this.add(DataTransferServicesTest.this.datasetsFS.getName() + "/readme.md");
                this.add(DataTransferServicesTest.this.perspectivesFS.getName() + "/page1/perspective_layout");
                this.add(DataTransferServicesTest.this.perspectivesFS.getName() + "/page1/perspective_layout.plugin");
                this.add(DataTransferServicesTest.this.perspectivesFS.getName() + "/readme.md");
                this.add(DataTransferServicesTest.this.navigationFS.getName() + "/navtree.json");
                this.add(DataTransferServicesTest.this.navigationFS.getName() + "/readme.md");
                this.add("VERSION");
            }
        }, this.getFiles(zis));
        this.cleanFileSystems();
    }

    @Test
    public void testDoExportFilteringPages() throws Exception {
        this.createFile(this.datasetsFS, "definitions/dataset.csv", "");
        this.createFile(this.datasetsFS, "definitions/dataset.dset", "");
        this.createFile(this.perspectivesFS, "page1/perspective_layout", "");
        this.createFile(this.perspectivesFS, "page1/perspective_layout.plugin", "");
        this.createFile(this.perspectivesFS, "page2/perspective_layout", "");
        this.createFile(this.perspectivesFS, "page2/perspective_layout.plugin", "");
        this.createFile(this.navigationFS, "navtree.json", "");
        DataSetDef def = (DataSetDef)Mockito.mock(DataSetDef.class);
        Mockito.when((Object)def.getUUID()).thenReturn((Object)"dataset");
        DataTransferExportModel model = new DataTransferExportModel(Arrays.asList(def), Arrays.asList("page2"), true);
        String exportPath = this.dataTransferServices.doExport(model);
        Assert.assertTrue((boolean)exportPath.equals(this.getExpectedExportFileSystemPath()));
        ZipInputStream zis = this.getZipInputStream();
        Assert.assertEquals((Object)new ArrayList<String>(){
            {
                this.add(DataTransferServicesTest.this.datasetsFS.getName() + "/definitions/dataset.csv");
                this.add(DataTransferServicesTest.this.datasetsFS.getName() + "/definitions/dataset.dset");
                this.add(DataTransferServicesTest.this.datasetsFS.getName() + "/readme.md");
                this.add(DataTransferServicesTest.this.perspectivesFS.getName() + "/page2/perspective_layout");
                this.add(DataTransferServicesTest.this.perspectivesFS.getName() + "/page2/perspective_layout.plugin");
                this.add(DataTransferServicesTest.this.perspectivesFS.getName() + "/readme.md");
                this.add(DataTransferServicesTest.this.navigationFS.getName() + "/navtree.json");
                this.add(DataTransferServicesTest.this.navigationFS.getName() + "/readme.md");
                this.add("VERSION");
            }
        }, this.getFiles(zis));
        this.cleanFileSystems();
    }

    @Test
    public void testDoExportWithoutNavigation() throws Exception {
        this.createFile(this.datasetsFS, "definitions/dataset.csv", "");
        this.createFile(this.datasetsFS, "definitions/dataset.dset", "");
        this.createFile(this.perspectivesFS, "page1/perspective_layout", "");
        this.createFile(this.perspectivesFS, "page1/perspective_layout.plugin", "");
        this.createFile(this.navigationFS, "navtree.json", "");
        DataSetDef def = (DataSetDef)Mockito.mock(DataSetDef.class);
        Mockito.when((Object)def.getUUID()).thenReturn((Object)"dataset");
        DataTransferExportModel model = new DataTransferExportModel(Arrays.asList(def), Arrays.asList("page1"), false);
        String exportPath = this.dataTransferServices.doExport(model);
        Assert.assertTrue((boolean)exportPath.equals(this.getExpectedExportFileSystemPath()));
        ZipInputStream zis = this.getZipInputStream();
        Assert.assertEquals((Object)new ArrayList<String>(){
            {
                this.add(DataTransferServicesTest.this.datasetsFS.getName() + "/definitions/dataset.csv");
                this.add(DataTransferServicesTest.this.datasetsFS.getName() + "/definitions/dataset.dset");
                this.add(DataTransferServicesTest.this.datasetsFS.getName() + "/readme.md");
                this.add(DataTransferServicesTest.this.perspectivesFS.getName() + "/page1/perspective_layout");
                this.add(DataTransferServicesTest.this.perspectivesFS.getName() + "/page1/perspective_layout.plugin");
                this.add(DataTransferServicesTest.this.perspectivesFS.getName() + "/readme.md");
                this.add(DataTransferServicesTest.this.navigationFS.getName() + "/readme.md");
                this.add("VERSION");
            }
        }, this.getFiles(zis));
        this.cleanFileSystems();
    }

    @Test
    public void testDoExportWithComponents() throws Exception {
        Mockito.when((Object)this.layoutComponentsHelper.findComponentsInTemplates((Predicate)Matchers.any())).thenReturn(Arrays.asList("c1"));
        this.createFile(this.perspectivesFS, "page1/perspective_layout", "");
        this.createFile(this.perspectivesFS, "page1/perspective_layout.plugin", "");
        this.createComponentFile("c1", "manifest.json", "manifest");
        this.createComponentFile("c1", "index.html", "html");
        this.createComponentFile("c1", "css/style.css", "style");
        this.createComponentFile("c1", "js/index.js", "js");
        this.createComponentFile("lost", "lostfile", "ignore-me-import");
        this.createComponentFile("c2", "manifest.json", "manifest");
        this.createComponentFile("c2", "index.html", "html");
        this.createComponentFile("c2", "css/style.css", "style");
        this.createComponentFile("c2", "js/index.js", "js");
        this.dataTransferServices.doExport(DataTransferExportModel.exportAll());
        ZipInputStream zis = this.getZipInputStream();
        Object[] expectedFiles = new String[]{this.datasetsFS.getName() + "/readme.md", this.perspectivesFS.getName() + "/page1/perspective_layout", this.perspectivesFS.getName() + "/page1/perspective_layout.plugin", this.perspectivesFS.getName() + "/readme.md", this.navigationFS.getName() + "/readme.md", "dashbuilder/components/c1/js/index.js", "dashbuilder/components/c1/css/style.css", "dashbuilder/components/c1/index.html", "dashbuilder/components/c1/manifest.json", "VERSION"};
        Object[] actualList = this.getFiles(zis).toArray();
        Arrays.sort(expectedFiles);
        Arrays.sort(actualList);
        Assert.assertArrayEquals((Object[])expectedFiles, (Object[])actualList);
        this.cleanFileSystems();
    }

    @Test
    public void testDoExportIgnoringComponents() throws Exception {
        Mockito.when((Object)this.externalComponentLoader.isExternalComponentsEnabled()).thenReturn((Object)false);
        Mockito.when((Object)this.externalComponentLoader.loadExternal()).thenReturn(Arrays.asList(this.component("c1")));
        this.createFile(this.perspectivesFS, "page1/perspective_layout", "");
        this.createFile(this.perspectivesFS, "page1/perspective_layout.plugin", "");
        this.createComponentFile("c1", "manifest.json", "manifest");
        this.createComponentFile("c1", "index.html", "html");
        this.createComponentFile("c1", "css/style.css", "style");
        this.createComponentFile("c1", "js/index.js", "js");
        this.dataTransferServices.doExport(DataTransferExportModel.exportAll());
        ZipInputStream zis = this.getZipInputStream();
        Assert.assertEquals((Object)new ArrayList<String>(){
            {
                this.add(DataTransferServicesTest.this.datasetsFS.getName() + "/readme.md");
                this.add(DataTransferServicesTest.this.perspectivesFS.getName() + "/page1/perspective_layout");
                this.add(DataTransferServicesTest.this.perspectivesFS.getName() + "/page1/perspective_layout.plugin");
                this.add(DataTransferServicesTest.this.perspectivesFS.getName() + "/readme.md");
                this.add(DataTransferServicesTest.this.navigationFS.getName() + "/readme.md");
                this.add("VERSION");
            }
        }, this.getFiles(zis));
        this.cleanFileSystems();
    }

    @Test
    public void testDoExportWhenComponentsDirIsNotPresent() throws Exception {
        this.createFile(this.perspectivesFS, "page1/perspective_layout", "");
        this.createFile(this.perspectivesFS, "page1/perspective_layout.plugin", "");
        FileUtils.deleteQuietly((File)this.componentsDir.toFile());
        this.dataTransferServices.doExport(DataTransferExportModel.exportAll());
        ZipInputStream zis = this.getZipInputStream();
        Assert.assertEquals((Object)new ArrayList<String>(){
            {
                this.add(DataTransferServicesTest.this.datasetsFS.getName() + "/readme.md");
                this.add(DataTransferServicesTest.this.perspectivesFS.getName() + "/page1/perspective_layout");
                this.add(DataTransferServicesTest.this.perspectivesFS.getName() + "/page1/perspective_layout.plugin");
                this.add(DataTransferServicesTest.this.perspectivesFS.getName() + "/readme.md");
                this.add(DataTransferServicesTest.this.navigationFS.getName() + "/readme.md");
                this.add("VERSION");
            }
        }, this.getFiles(zis));
        this.cleanFileSystems();
    }

    @Test
    public void testDoImportNoZip() throws Exception {
        List filesImported = this.dataTransferServices.doImport();
        Assert.assertEquals(new ArrayList(), (Object)filesImported);
        Assert.assertEquals((Object)new ArrayList<String>(){
            {
                this.add("/readme.md");
            }
        }, this.getFiles(this.datasetsFS));
        Assert.assertEquals((Object)new ArrayList<String>(){
            {
                this.add("/readme.md");
            }
        }, this.getFiles(this.perspectivesFS));
        Assert.assertEquals((Object)new ArrayList<String>(){
            {
                this.add("/readme.md");
            }
        }, this.getFiles(this.navigationFS));
        Assert.assertEquals((Object)new ArrayList<String>(){
            {
                this.add("/readme.md");
            }
        }, this.getFiles(this.systemFS));
        ((Event)Mockito.verify(this.dataSetDefRegisteredEvent, (VerificationMode)Mockito.times((int)0))).fire(Matchers.any());
        ((Event)Mockito.verify(this.pluginAddedEvent, (VerificationMode)Mockito.times((int)0))).fire(Matchers.any());
        ((Event)Mockito.verify(this.navTreeChangedEvent, (VerificationMode)Mockito.times((int)0))).fire(Matchers.any());
    }

    @Test
    public void testDoImportEmptyZip() throws Exception {
        this.moveZipToFileSystem("/empty.zip");
        List filesImported = this.dataTransferServices.doImport();
        Assert.assertEquals(new ArrayList(), (Object)filesImported);
        Assert.assertEquals((Object)new ArrayList<String>(){
            {
                this.add("/readme.md");
            }
        }, this.getFiles(this.datasetsFS));
        Assert.assertEquals((Object)new ArrayList<String>(){
            {
                this.add("/readme.md");
            }
        }, this.getFiles(this.perspectivesFS));
        Assert.assertEquals((Object)new ArrayList<String>(){
            {
                this.add("/readme.md");
            }
        }, this.getFiles(this.navigationFS));
        Assert.assertEquals((Object)new ArrayList<String>(){
            {
                this.add("/readme.md");
            }
        }, this.getFiles(this.systemFS));
        ((Event)Mockito.verify(this.dataSetDefRegisteredEvent, (VerificationMode)Mockito.times((int)0))).fire(Matchers.any());
        ((Event)Mockito.verify(this.pluginAddedEvent, (VerificationMode)Mockito.times((int)0))).fire(Matchers.any());
        ((Event)Mockito.verify(this.navTreeChangedEvent, (VerificationMode)Mockito.times((int)0))).fire(Matchers.any());
    }

    @Test
    public void testDoImportNotEmptyZip() throws Exception {
        this.moveZipToFileSystem("/import.zip");
        List filesImported = this.dataTransferServices.doImport();
        Assert.assertEquals((Object)new ArrayList<String>(){
            {
                this.add("dashbuilder/datasets/readme.md");
                this.add("dashbuilder/datasets/definitions/eb241039-1792-4d08-9596-b6c8d27dfe6b.csv");
                this.add("dashbuilder/datasets/definitions/d1b24449-fe90-40d4-8cd7-f175b498c0bb.dset");
                this.add("dashbuilder/datasets/definitions/8060a7f1-ef03-4ce9-a0a8-266301e79ff6.dset");
                this.add("dashbuilder/datasets/definitions/eb241039-1792-4d08-9596-b6c8d27dfe6b.dset");
                this.add("dashbuilder/datasets/definitions/7e68d20d-6807-4b86-8737-1d429afe9dbc.csv");
                this.add("dashbuilder/datasets/definitions/d1b24449-fe90-40d4-8cd7-f175b498c0bb.csv");
                this.add("dashbuilder/datasets/definitions/8060a7f1-ef03-4ce9-a0a8-266301e79ff6.csv");
                this.add("dashbuilder/datasets/definitions/7e68d20d-6807-4b86-8737-1d429afe9dbc.dset");
                this.add("dashbuilder/components/c2/manifest.json");
                this.add("dashbuilder/components/c2/styles/level/styles.css");
                this.add("dashbuilder/components/c2/index.html");
                this.add("dashbuilder/components/c1/manifest.json");
                this.add("dashbuilder/components/c1/images/db_logo.png");
                this.add("dashbuilder/components/c1/scripts/index.js");
                this.add("dashbuilder/components/c1/index.html");
                this.add("dashbuilder/perspectives/page3/perspective_layout");
                this.add("dashbuilder/perspectives/page3/perspective_layout.plugin");
                this.add("dashbuilder/perspectives/readme.md");
                this.add("dashbuilder/perspectives/page4/perspective_layout");
                this.add("dashbuilder/perspectives/page4/perspective_layout.plugin");
                this.add("dashbuilder/perspectives/page2/perspective_layout");
                this.add("dashbuilder/perspectives/page2/perspective_layout.plugin");
                this.add("dashbuilder/perspectives/page1/perspective_layout");
                this.add("dashbuilder/perspectives/page1/perspective_layout.plugin");
                this.add("dashbuilder/navigation/readme.md");
                this.add("dashbuilder/navigation/navigation/navtree.json");
            }
        }, (Object)filesImported);
        Assert.assertEquals((Object)new ArrayList<String>(){
            {
                this.add("/definitions/7e68d20d-6807-4b86-8737-1d429afe9dbc.csv");
                this.add("/definitions/7e68d20d-6807-4b86-8737-1d429afe9dbc.dset");
                this.add("/definitions/8060a7f1-ef03-4ce9-a0a8-266301e79ff6.csv");
                this.add("/definitions/8060a7f1-ef03-4ce9-a0a8-266301e79ff6.dset");
                this.add("/definitions/d1b24449-fe90-40d4-8cd7-f175b498c0bb.csv");
                this.add("/definitions/d1b24449-fe90-40d4-8cd7-f175b498c0bb.dset");
                this.add("/definitions/eb241039-1792-4d08-9596-b6c8d27dfe6b.csv");
                this.add("/definitions/eb241039-1792-4d08-9596-b6c8d27dfe6b.dset");
                this.add("/readme.md");
            }
        }, this.getFiles(this.datasetsFS));
        Assert.assertEquals((Object)new ArrayList<String>(){
            {
                this.add("/page1/perspective_layout");
                this.add("/page1/perspective_layout.plugin");
                this.add("/page2/perspective_layout");
                this.add("/page2/perspective_layout.plugin");
                this.add("/page3/perspective_layout");
                this.add("/page3/perspective_layout.plugin");
                this.add("/page4/perspective_layout");
                this.add("/page4/perspective_layout.plugin");
                this.add("/readme.md");
            }
        }, this.getFiles(this.perspectivesFS));
        Assert.assertEquals((Object)new ArrayList<String>(){
            {
                this.add("/navigation/navtree.json");
                this.add("/readme.md");
            }
        }, this.getFiles(this.navigationFS));
        Assert.assertEquals((Object)new ArrayList<String>(){
            {
                this.add("/readme.md");
            }
        }, this.getFiles(this.systemFS));
        ArrayList<String> expectedComponents = new ArrayList<String>(){
            {
                this.add("c1/index.html");
                this.add("c1/scripts/index.js");
                this.add("c1/images/db_logo.png");
                this.add("c1/manifest.json");
                this.add("c2/index.html");
                this.add("c2/styles/level/styles.css");
                this.add("c2/manifest.json");
            }
        };
        expectedComponents.removeAll(this.getFiles(this.componentsDir));
        Assert.assertTrue((boolean)expectedComponents.isEmpty());
        ((Event)Mockito.verify(this.dataSetDefRegisteredEvent, (VerificationMode)Mockito.times((int)4))).fire(Matchers.any());
        ((Event)Mockito.verify(this.pluginAddedEvent, (VerificationMode)Mockito.times((int)4))).fire(Matchers.any());
        ((Event)Mockito.verify(this.navTreeChangedEvent, (VerificationMode)Mockito.times((int)1))).fire(Matchers.any());
    }

    @Test
    public void testAssetsToImport() throws Exception {
        String PAGE_ID = "page";
        String DS_CSV = "ds.csv";
        String DS = "ds.dset";
        String DS_CONTENT = "TEST_CONTENT";
        String DS_NAME = "test_dataset";
        String PAGE = "page/perspective_layout";
        String PAGE_PLUGIN = "page/perspective_layout.plugin";
        DataSetDef dataSetDef = (DataSetDef)Mockito.mock(DataSetDef.class);
        Mockito.when((Object)dataSetDef.isPublic()).thenReturn((Object)true);
        Mockito.when((Object)dataSetDef.getName()).thenReturn((Object)"test_dataset");
        Mockito.when((Object)this.dataSetDefJSONMarshaller.fromJson("TEST_CONTENT")).thenReturn((Object)dataSetDef);
        this.createFile(this.datasetsFS, "ds.dset", "TEST_CONTENT");
        this.createFile(this.datasetsFS, "ds.csv", "");
        this.createFile(this.perspectivesFS, "page/perspective_layout", "");
        this.createFile(this.perspectivesFS, "page/perspective_layout.plugin", "");
        ExportInfo exportInfo = this.dataTransferServices.exportInfo();
        Assert.assertEquals((long)1L, (long)exportInfo.getDatasetsDefinitions().size());
        Assert.assertEquals((Object)"test_dataset", (Object)((DataSetDef)exportInfo.getDatasetsDefinitions().get(0)).getName());
        Assert.assertEquals((long)1L, (long)exportInfo.getPages().size());
        Assert.assertEquals((Object)"page", exportInfo.getPages().get(0));
        this.cleanFileSystems();
    }

    @Test
    public void testAssetsToImportNoFiles() {
        ExportInfo assetsToExport = this.dataTransferServices.exportInfo();
        Assert.assertTrue((boolean)assetsToExport.getDatasetsDefinitions().isEmpty());
        Assert.assertTrue((boolean)assetsToExport.getPages().isEmpty());
    }

    private FileSystem createFileSystem(String name) {
        String path = "git://dashbuilder" + File.separator + name;
        try {
            return this.ioService.newFileSystem(URI.create(path), (Map)new HashMap<String, Object>(){
                {
                    this.put("init", Boolean.TRUE);
                }
            });
        }
        catch (Exception e) {
            return this.ioService.getFileSystem(URI.create(path));
        }
    }

    @Test
    public void testShouldNotExposePrivateDS() throws Exception {
        String DS = "ds.dset";
        String DS_CONTENT = "TEST_CONTENT";
        String DS_NAME = "test_dataset";
        DataSetDef dataSetDef = (DataSetDef)Mockito.mock(DataSetDef.class);
        Mockito.when((Object)dataSetDef.isPublic()).thenReturn((Object)false);
        Mockito.when((Object)dataSetDef.getName()).thenReturn((Object)"test_dataset");
        Mockito.when((Object)this.dataSetDefJSONMarshaller.fromJson("TEST_CONTENT")).thenReturn((Object)dataSetDef);
        this.createFile(this.datasetsFS, "ds.dset", "TEST_CONTENT");
        ExportInfo assetsToExport = this.dataTransferServices.exportInfo();
        Assert.assertTrue((boolean)assetsToExport.getDatasetsDefinitions().isEmpty());
        this.cleanFileSystems();
    }

    private Path createFile(FileSystem fs, String filename, String data) {
        Path path = (Path)fs.getRootDirectories().iterator().next();
        Path filePath = path.resolve(filename);
        this.ioService.write(filePath, data, new OpenOption[0]);
        return filePath;
    }

    private Path createComponentFile(String componentId, String filename, String data) {
        Path componentPath = this.componentsDir.resolve(componentId);
        Path componentFile = componentPath.resolve(filename);
        componentFile.getParent().toFile().mkdirs();
        this.ioService.write(componentFile, data, new OpenOption[0]);
        return componentFile;
    }

    private List<String> getFiles(Path root) {
        final ArrayList<String> files = new ArrayList<String>();
        Files.walkFileTree((Path)root, (FileVisitor)new SimpleFileVisitor<Path>(){

            public FileVisitResult visitFile(Path path, BasicFileAttributes attrs) throws IOException {
                files.add(path.toString().replaceAll(DataTransferServicesTest.this.componentsDir.toString() + "/", ""));
                return FileVisitResult.CONTINUE;
            }
        });
        return files;
    }

    private List<String> getFiles(FileSystem fs) {
        final ArrayList<String> files = new ArrayList<String>();
        Path root = (Path)fs.getRootDirectories().iterator().next();
        Files.walkFileTree((Path)root, (FileVisitor)new SimpleFileVisitor<Path>(){

            public FileVisitResult visitFile(Path path, BasicFileAttributes attrs) throws IOException {
                files.add(path.toString());
                return FileVisitResult.CONTINUE;
            }
        });
        return files;
    }

    private List<String> getFiles(ZipInputStream zis) {
        ArrayList<String> files = new ArrayList<String>();
        ZipEntry entry = null;
        try {
            while ((entry = zis.getNextEntry()) != null) {
                files.add(entry.getName());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return files;
    }

    private String getExpectedExportFilePath() {
        return File.separator + "dashbuilder-data-transfer" + File.separator + "export.zip";
    }

    private String getExpectedImportFilePath() {
        return File.separator + "dashbuilder-data-transfer" + File.separator + "import.zip";
    }

    private String getExpectedExportFileSystemPath() {
        return "git://" + this.systemFS.getName() + this.getExpectedExportFilePath();
    }

    private void moveZipToFileSystem(String path) {
        URL url = DataTransferServicesTest.class.getResource(path);
        String sourceLocation = SpacesAPI.Scheme.FILE + "://" + url.toString();
        Path source = Paths.get((URI)URI.create(sourceLocation));
        Path target = ((Path)this.systemFS.getRootDirectories().iterator().next()).resolve("dashbuilder-data-transfer").resolve("import.zip");
        this.ioService.write(target, Files.readAllBytes((Path)source), new OpenOption[0]);
    }

    private void cleanFileSystem(FileSystem fs) {
        for (String file : this.getFiles(fs)) {
            if (file.endsWith("readme.md")) continue;
            String path = "git://" + fs.getName() + file;
            this.ioService.delete(Paths.get((URI)URI.create(path)), new DeleteOption[0]);
        }
    }

    private ZipInputStream getZipInputStream() {
        Path path = Paths.get((URI)URI.create("git://" + this.systemFS.getName() + this.getExpectedExportFilePath()));
        return new ZipInputStream(new ByteArrayInputStream(this.ioService.readAllBytes(path)));
    }

    public ExternalComponent component(String id) {
        return new ExternalComponent(id, id, "", false, Collections.emptyList());
    }
}

