/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.transfer;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.dashbuilder.transfer.LayoutComponentHelper;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.uberfire.ext.layout.editor.api.PerspectiveServices;
import org.uberfire.ext.layout.editor.api.editor.LayoutColumn;
import org.uberfire.ext.layout.editor.api.editor.LayoutComponent;
import org.uberfire.ext.layout.editor.api.editor.LayoutRow;
import org.uberfire.ext.layout.editor.api.editor.LayoutTemplate;

@RunWith(value=MockitoJUnitRunner.class)
public class LayoutComponentHelperTest {
    @Mock
    PerspectiveServices perspectiveServices;
    @InjectMocks
    LayoutComponentHelper layoutComponentsHelper;

    @Test
    public void testComponentId() {
        String c1 = "c1";
        String c2 = "c2";
        LayoutTemplate lt = this.createLayoutTemplate("lt", c1, c2);
        Mockito.when((Object)this.perspectiveServices.listLayoutTemplates()).thenReturn(Collections.singletonList(lt));
        List components = this.layoutComponentsHelper.findComponentsInTemplates(p -> true);
        Assert.assertEquals((long)2L, (long)components.size());
        Assert.assertEquals((Object)components, Arrays.asList(c1, c2));
    }

    public void testNoComponentId() {
        LayoutTemplate lt = this.createLayoutTemplate("lt", new String[0]);
        Mockito.when((Object)this.perspectiveServices.listLayoutTemplates()).thenReturn(Collections.singletonList(lt));
        List components = this.layoutComponentsHelper.findComponentsInTemplates(p -> true);
        Assert.assertTrue((boolean)components.isEmpty());
    }

    public void testPageFilter() {
        String c1 = "c1";
        LayoutTemplate lt = this.createLayoutTemplate("lt", c1);
        Mockito.when((Object)this.perspectiveServices.listLayoutTemplates()).thenReturn(Collections.singletonList(lt));
        List components = this.layoutComponentsHelper.findComponentsInTemplates(p -> false);
        Assert.assertTrue((boolean)components.isEmpty());
    }

    private LayoutTemplate createLayoutTemplate(String name, String ... componentIds) {
        LayoutTemplate lt = new LayoutTemplate(name);
        LayoutRow lr = new LayoutRow();
        LayoutColumn lc = new LayoutColumn("");
        lr.add(lc);
        lt.addRow(lr);
        for (String componentId : componentIds) {
            LayoutComponent lComp = new LayoutComponent();
            lComp.addProperty("componentId", componentId);
            lc.add(lComp);
        }
        return lt;
    }
}

