/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.migration;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.dashbuilder.migration.DashbuilderDataMigration;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.uberfire.io.IOService;
import org.uberfire.io.impl.IOServiceDotFileImpl;
import org.uberfire.java.nio.file.FileSystem;
import org.uberfire.java.nio.file.FileSystemMetadata;
import org.uberfire.java.nio.file.FileVisitResult;
import org.uberfire.java.nio.file.FileVisitor;
import org.uberfire.java.nio.file.Files;
import org.uberfire.java.nio.file.OpenOption;
import org.uberfire.java.nio.file.Path;
import org.uberfire.java.nio.file.SimpleFileVisitor;
import org.uberfire.java.nio.file.attribute.BasicFileAttributes;
import org.uberfire.java.nio.fs.jgit.JGitFileSystem;
import org.uberfire.mvp.Command;

@RunWith(value=MockitoJUnitRunner.class)
public class DashbuilderDataMigrationTest {
    private DashbuilderDataMigration dashbuilderDataMigration;
    private IOService ioService;
    private FileSystem sourceFS;
    private FileSystem targetFS;

    @Before
    public void setup() {
        this.ioService = new IOServiceDotFileImpl();
        this.sourceFS = this.createFileSystem();
        this.targetFS = this.createFileSystem();
        this.dashbuilderDataMigration = (DashbuilderDataMigration)Mockito.spy((Object)new DashbuilderDataMigration(this.ioService, null, null, null, null));
    }

    @Test
    public void testMigrateNull() {
        this.checkInitialCondition();
        this.dashbuilderDataMigration.migrateDatasets(null, null);
        this.dashbuilderDataMigration.migratePerspectives(null, null);
        this.dashbuilderDataMigration.migrateNavigation(null, null);
        this.dashbuilderDataMigration.migrateDatasets(this.sourceFS, null);
        this.checkInitialCondition();
        this.dashbuilderDataMigration.migrateDatasets(null, this.targetFS);
        this.checkInitialCondition();
        this.dashbuilderDataMigration.migratePerspectives(this.sourceFS, null);
        this.checkInitialCondition();
        this.dashbuilderDataMigration.migratePerspectives(null, this.targetFS);
        this.checkInitialCondition();
        this.dashbuilderDataMigration.migrateNavigation(this.sourceFS, null);
        this.checkInitialCondition();
        this.dashbuilderDataMigration.migrateNavigation(null, this.targetFS);
        this.checkInitialCondition();
    }

    @Test
    public void testGitIsDefaultFileSystem() {
        ((DashbuilderDataMigration)Mockito.doNothing().when((Object)this.dashbuilderDataMigration)).runWithLock((Command)ArgumentMatchers.any());
        ((DashbuilderDataMigration)Mockito.doReturn((Object)true).when((Object)this.dashbuilderDataMigration)).isMigrationEnabled();
        this.dashbuilderDataMigration.init();
        ((DashbuilderDataMigration)Mockito.verify((Object)this.dashbuilderDataMigration, (VerificationMode)Mockito.times((int)1))).runWithLock((Command)ArgumentMatchers.any());
    }

    @Test
    public void testGitIsNotDefaultFileSystem() {
        ((DashbuilderDataMigration)Mockito.doReturn((Object)false).when((Object)this.dashbuilderDataMigration)).isMigrationEnabled();
        this.dashbuilderDataMigration.init();
        ((DashbuilderDataMigration)Mockito.verify((Object)this.dashbuilderDataMigration, (VerificationMode)Mockito.never())).runWithLock((Command)ArgumentMatchers.any());
    }

    @Test
    public void testMigrateEmpty() {
        this.checkInitialCondition();
        this.dashbuilderDataMigration.migrateDatasets(this.sourceFS, this.targetFS);
        this.checkInitialCondition();
        this.dashbuilderDataMigration.migratePerspectives(this.sourceFS, this.targetFS);
        this.checkInitialCondition();
        this.dashbuilderDataMigration.migrateNavigation(this.sourceFS, this.targetFS);
        this.checkInitialCondition();
    }

    @Test
    public void testMigrateDatasets() {
        this.checkInitialCondition();
        this.createFiles(this.sourceFS);
        this.dashbuilderDataMigration.migrateDatasets(this.sourceFS, this.targetFS);
        List<String> sourceFiles = this.getFiles(this.sourceFS);
        List<String> targetFiles = this.getFiles(this.targetFS);
        Assert.assertEquals((long)1L, (long)sourceFiles.size());
        Assert.assertEquals((long)8L, (long)targetFiles.size());
        Assert.assertEquals((Object)new ArrayList<String>(){
            {
                this.add("/readme.md");
            }
        }, sourceFiles);
        Assert.assertEquals((Object)new ArrayList<String>(){
            {
                this.add("/bbb.txt");
                this.add("/dataset1.csv");
                this.add("/definitions/dataset2.dset");
                this.add("/navtree.json");
                this.add("/page-abc/perspective_layout.json");
                this.add("/perspective_layout2.txt");
                this.add("/perspective_layouts/aaa.txt");
                this.add("/readme.md");
            }
        }, targetFiles);
    }

    @Test
    public void testMigratePerspectives() {
        this.checkInitialCondition();
        this.createFiles(this.sourceFS);
        this.dashbuilderDataMigration.migratePerspectives(this.sourceFS, this.targetFS);
        List<String> sourceFiles = this.getFiles(this.sourceFS);
        List<String> targetFiles = this.getFiles(this.targetFS);
        Assert.assertEquals((long)6L, (long)sourceFiles.size());
        Assert.assertEquals((long)3L, (long)targetFiles.size());
        Assert.assertEquals((Object)new ArrayList<String>(){
            {
                this.add("/bbb.txt");
                this.add("/dataset1.csv");
                this.add("/definitions/dataset2.dset");
                this.add("/navtree.json");
                this.add("/perspective_layouts/aaa.txt");
                this.add("/readme.md");
            }
        }, sourceFiles);
        Assert.assertEquals((Object)new ArrayList<String>(){
            {
                this.add("/page-abc/perspective_layout.json");
                this.add("/perspective_layout2.txt");
                this.add("/readme.md");
            }
        }, targetFiles);
    }

    @Test
    public void testMigrateNavigation() {
        this.checkInitialCondition();
        this.createFiles(this.sourceFS);
        this.dashbuilderDataMigration.migrateNavigation(this.sourceFS, this.targetFS);
        List<String> sourceFiles = this.getFiles(this.sourceFS);
        List<String> targetFiles = this.getFiles(this.targetFS);
        Assert.assertEquals((long)7L, (long)sourceFiles.size());
        Assert.assertEquals((long)2L, (long)targetFiles.size());
        Assert.assertEquals((Object)new ArrayList<String>(){
            {
                this.add("/bbb.txt");
                this.add("/dataset1.csv");
                this.add("/definitions/dataset2.dset");
                this.add("/page-abc/perspective_layout.json");
                this.add("/perspective_layout2.txt");
                this.add("/perspective_layouts/aaa.txt");
                this.add("/readme.md");
            }
        }, sourceFiles);
        Assert.assertEquals((Object)new ArrayList<String>(){
            {
                this.add("/navtree.json");
                this.add("/readme.md");
            }
        }, targetFiles);
    }

    private void checkInitialCondition() {
        List<String> sourceFiles = this.getFiles(this.sourceFS);
        List<String> targetFiles = this.getFiles(this.targetFS);
        Assert.assertEquals((long)1L, (long)sourceFiles.size());
        Assert.assertEquals((long)1L, (long)targetFiles.size());
        Assert.assertEquals((Object)new ArrayList<String>(){
            {
                this.add("/readme.md");
            }
        }, sourceFiles);
        Assert.assertEquals((Object)new ArrayList<String>(){
            {
                this.add("/readme.md");
            }
        }, targetFiles);
    }

    private List<String> getFiles(FileSystem fs) {
        final ArrayList<String> files = new ArrayList<String>();
        Path root = (Path)fs.getRootDirectories().iterator().next();
        Files.walkFileTree((Path)root, (FileVisitor)new SimpleFileVisitor<Path>(){

            public FileVisitResult visitFile(Path path, BasicFileAttributes attrs) throws org.uberfire.java.nio.IOException {
                files.add(path.toString());
                return FileVisitResult.CONTINUE;
            }
        });
        return files;
    }

    private void createFiles(FileSystem fs) {
        Path path = (Path)fs.getRootDirectories().iterator().next();
        this.ioService.write(path.resolve("dataset1.csv"), "test", new OpenOption[0]);
        this.ioService.write(path.resolve("definitions").resolve("dataset2.dset"), "test", new OpenOption[0]);
        this.ioService.write(path.resolve("navtree.json"), "test", new OpenOption[0]);
        this.ioService.write(path.resolve("perspective_layouts").resolve("aaa.txt"), "test", new OpenOption[0]);
        this.ioService.write(path.resolve("bbb.txt"), "test", new OpenOption[0]);
        this.ioService.write(path.resolve("page-abc").resolve("perspective_layout.json"), "test", new OpenOption[0]);
        this.ioService.write(path.resolve("perspective_layout2.txt"), "test", new OpenOption[0]);
    }

    private FileSystem createFileSystem() {
        return this.ioService.newFileSystem(URI.create("git://migration/temp" + new Date().getTime()), (Map)new HashMap<String, Object>(){
            {
                this.put("init", Boolean.TRUE);
            }
        });
    }

    @After
    public void cleanup() {
        for (FileSystemMetadata fsm : this.ioService.getFileSystemMetadata()) {
            URI uri = URI.create(fsm.getUri());
            if (!uri.getScheme().equals("git")) continue;
            JGitFileSystem fs = (JGitFileSystem)this.ioService.getFileSystem(uri);
            fs.getGit().getRepository().getDirectory().delete();
            this.deleteFileSystem((FileSystem)fs);
        }
    }

    private void deleteFileSystem(FileSystem fs) {
        try {
            FileUtils.deleteDirectory((File)((JGitFileSystem)fs).getGit().getRepository().getDirectory().getAbsoluteFile().getParentFile());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

