/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.transfer;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.dashbuilder.dataset.DataSetLookup;
import org.dashbuilder.dataset.def.DataSetDef;
import org.dashbuilder.displayer.DisplayerSettings;
import org.dashbuilder.displayer.json.DisplayerSettingsJSONMarshaller;
import org.dashbuilder.navigation.service.PerspectivePluginServices;
import org.dashbuilder.transfer.DataTransferExportModel;
import org.dashbuilder.transfer.ExportModelValidationServiceImpl;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.uberfire.ext.layout.editor.api.editor.LayoutColumn;
import org.uberfire.ext.layout.editor.api.editor.LayoutComponent;
import org.uberfire.ext.layout.editor.api.editor.LayoutRow;
import org.uberfire.ext.layout.editor.api.editor.LayoutTemplate;

@RunWith(value=MockitoJUnitRunner.class)
public class ExportModelValidationServiceImplTest {
    ExportModelValidationServiceImpl dataTransferExportValidator;
    @Mock
    PerspectivePluginServices perspectivePluginServices;
    @Mock
    DisplayerSettingsJSONMarshaller marshaller;

    @Before
    public void init() {
        this.dataTransferExportValidator = new ExportModelValidationServiceImpl(this.perspectivePluginServices, this.marshaller);
    }

    @Test
    public void testTryingToExportPageWithMissingDataSet() {
        String page1 = "page1";
        String ds1 = "ds1";
        String json1 = "json1";
        DisplayerSettings ds = this.registerDSMock(ds1);
        Mockito.when((Object)this.marshaller.fromJsonString(json1)).thenReturn((Object)ds);
        LayoutTemplate ltForPage1 = this.createTemplate(json1);
        Mockito.when((Object)this.perspectivePluginServices.getLayoutTemplate(page1)).thenReturn((Object)ltForPage1);
        DataTransferExportModel model = new DataTransferExportModel(Collections.emptyList(), Arrays.asList(page1), true);
        Map missingDataSets = this.dataTransferExportValidator.checkMissingDatasets(model);
        Assert.assertTrue((boolean)missingDataSets.containsKey(page1));
        Assert.assertEquals((Object)ds1, ((List)missingDataSets.get(page1)).get(0));
    }

    @Test
    public void testSuccessExportWithAllDatasets() {
        String page1 = "page1";
        String ds1 = "ds1";
        String json1 = "json1";
        DataSetDef def = (DataSetDef)Mockito.mock(DataSetDef.class);
        Mockito.when((Object)def.getUUID()).thenReturn((Object)ds1);
        DisplayerSettings ds = this.registerDSMock(ds1);
        Mockito.when((Object)this.marshaller.fromJsonString(json1)).thenReturn((Object)ds);
        LayoutTemplate ltForPage1 = this.createTemplate(json1);
        Mockito.when((Object)this.perspectivePluginServices.getLayoutTemplate(page1)).thenReturn((Object)ltForPage1);
        DataTransferExportModel model = new DataTransferExportModel(Arrays.asList(def), Arrays.asList(page1), true);
        Map missingDataSets = this.dataTransferExportValidator.checkMissingDatasets(model);
        Assert.assertTrue((boolean)missingDataSets.isEmpty());
        Assert.assertFalse((boolean)missingDataSets.containsKey(page1));
    }

    private DisplayerSettings registerDSMock(String ds1) {
        DataSetLookup lookup = (DataSetLookup)Mockito.mock(DataSetLookup.class);
        Mockito.when((Object)lookup.getDataSetUUID()).thenReturn((Object)ds1);
        DisplayerSettings ds = (DisplayerSettings)Mockito.mock(DisplayerSettings.class);
        Mockito.when((Object)ds.getDataSetLookup()).thenReturn((Object)lookup);
        return ds;
    }

    public LayoutTemplate createTemplate(String ... jsonValues) {
        LayoutRow r1 = new LayoutRow();
        LayoutColumn lc1r1 = new LayoutColumn("");
        LayoutComponent cplc1r1 = new LayoutComponent();
        lc1r1.add(cplc1r1);
        LayoutColumn lc2r1 = new LayoutColumn("");
        LayoutComponent cplc2r1 = new LayoutComponent();
        lc2r1.add(cplc2r1);
        r1.add(lc1r1);
        r1.add(lc2r1);
        ArrayList<LayoutRow> createdRows = new ArrayList<LayoutRow>();
        for (String jsonValue : jsonValues) {
            LayoutRow row = new LayoutRow();
            LayoutColumn lc1r = new LayoutColumn("");
            LayoutComponent cp1lc1r = new LayoutComponent();
            lc1r.add(cp1lc1r);
            LayoutColumn lc2r = new LayoutColumn("");
            LayoutComponent lc2lc2r = new LayoutComponent();
            lc2lc2r.addProperty("json", jsonValue);
            lc2r.add(lc2lc2r);
            row.add(lc1r);
            row.add(lc2r);
            createdRows.add(row);
        }
        LayoutTemplate lt = new LayoutTemplate("");
        lt.addRow(r1);
        createdRows.forEach(arg_0 -> ((LayoutTemplate)lt).addRow(arg_0));
        return lt;
    }
}

