/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.dataset.service;

import java.io.File;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.servlet.ServletContext;
import org.dashbuilder.DataSetCore;
import org.dashbuilder.dataprovider.DataSetProviderType;
import org.dashbuilder.dataset.DataSetDefDeployerCDI;
import org.dashbuilder.dataset.DataSetDefRegistryCDI;
import org.dashbuilder.dataset.def.DataSetDef;
import org.dashbuilder.dataset.service.DataSetDefServices;
import org.dashbuilder.dataset.uuid.UUIDGenerator;
import org.dashbuilder.exception.ExceptionManager;
import org.jboss.errai.bus.server.annotations.Service;
import org.jboss.errai.bus.server.api.RpcContext;
import org.jboss.errai.security.shared.api.identity.User;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
@Service
public class DataSetDefServicesImpl
implements DataSetDefServices {
    protected static Logger log = LoggerFactory.getLogger(DataSetDefServicesImpl.class);
    protected User identity;
    protected ExceptionManager exceptionManager;
    protected UUIDGenerator uuidGenerator;
    protected DataSetDefRegistryCDI dataSetDefRegistry;
    protected DataSetDefDeployerCDI dataSetDefDeployer;

    public DataSetDefServicesImpl() {
    }

    @Inject
    public DataSetDefServicesImpl(User identity, ExceptionManager exceptionManager, DataSetDefRegistryCDI dataSetDefRegistry, DataSetDefDeployerCDI dataSetDefDeployer) {
        this.identity = identity;
        this.uuidGenerator = DataSetCore.get().getUuidGenerator();
        this.dataSetDefRegistry = dataSetDefRegistry;
        this.exceptionManager = exceptionManager;
        this.dataSetDefDeployer = dataSetDefDeployer;
    }

    @PostConstruct
    protected void init() {
        String dir;
        ServletContext servletContext = RpcContext.getHttpSession().getServletContext();
        if (!this.dataSetDefDeployer.isRunning() && servletContext != null && (dir = servletContext.getRealPath("WEB-INF/datasets")) != null && new File(dir).exists()) {
            dir = dir.replaceAll("\\\\", "/");
            this.dataSetDefDeployer.deploy(dir);
        }
    }

    public List<DataSetDef> getPublicDataSetDefs() {
        return this.dataSetDefRegistry.getDataSetDefs(true);
    }

    public DataSetDef createDataSetDef(DataSetProviderType type) {
        DataSetDef result = type != null ? type.createDataSetDef() : new DataSetDef();
        result.setUUID(this.uuidGenerator.newUuid());
        return result;
    }

    public String registerDataSetDef(DataSetDef definition, String comment) {
        if (definition.getUUID() == null) {
            String uuid = this.uuidGenerator.newUuid();
            definition.setUUID(uuid);
        }
        this.dataSetDefRegistry.registerDataSetDef(definition, this.identity != null ? this.identity.getIdentifier() : "---", comment);
        return definition.getUUID();
    }

    public void removeDataSetDef(String uuid, String comment) {
        DataSetDef def = this.dataSetDefRegistry.getDataSetDef(uuid);
        if (def != null) {
            this.dataSetDefRegistry.removeDataSetDef(uuid, this.identity != null ? this.identity.getIdentifier() : "---", comment);
        }
    }
}

