/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.client.widgets.dataset.editor.widgets;

import com.github.gwtbootstrap.client.ui.Button;
import com.github.gwtbootstrap.client.ui.Heading;
import com.github.gwtbootstrap.client.ui.Icon;
import com.github.gwtbootstrap.client.ui.Modal;
import com.github.gwtbootstrap.client.ui.Popover;
import com.github.gwtbootstrap.client.ui.Row;
import com.github.gwtbootstrap.client.ui.Tab;
import com.github.gwtbootstrap.client.ui.TabPanel;
import com.github.gwtbootstrap.client.ui.constants.ButtonType;
import com.github.gwtbootstrap.client.ui.constants.IconType;
import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.Node;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.CloseEvent;
import com.google.gwt.event.logical.shared.CloseHandler;
import com.google.gwt.event.logical.shared.OpenEvent;
import com.google.gwt.event.logical.shared.OpenHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.resources.client.CssResource;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.DisclosurePanel;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.FormPanel;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.enterprise.context.Dependent;
import javax.validation.ConstraintViolation;
import org.dashbuilder.client.widgets.dataset.editor.DataSetDefEditWorkflow;
import org.dashbuilder.client.widgets.dataset.editor.widgets.DataSetEditor;
import org.dashbuilder.client.widgets.dataset.editor.widgets.editors.DataSetAdvancedAttributesEditor;
import org.dashbuilder.client.widgets.dataset.editor.widgets.editors.DataSetBasicAttributesEditor;
import org.dashbuilder.client.widgets.dataset.editor.widgets.editors.DataSetColumnsEditor;
import org.dashbuilder.client.widgets.dataset.editor.widgets.editors.DataSetPreviewEditor;
import org.dashbuilder.client.widgets.dataset.editor.widgets.editors.DataSetProviderTypeEditor;
import org.dashbuilder.client.widgets.dataset.editor.widgets.editors.bean.BeanDataSetDefAttributesEditor;
import org.dashbuilder.client.widgets.dataset.editor.widgets.editors.csv.CSVDataSetDefAttributesEditor;
import org.dashbuilder.client.widgets.dataset.editor.widgets.editors.elasticsearch.ELDataSetDefAttributesEditor;
import org.dashbuilder.client.widgets.dataset.editor.widgets.editors.sql.SQLDataSetDefAttributesEditor;
import org.dashbuilder.client.widgets.resources.i18n.DataSetEditorConstants;
import org.dashbuilder.dataprovider.DataSetProviderType;
import org.dashbuilder.dataset.DataSet;
import org.dashbuilder.dataset.client.DataSetClientServices;
import org.dashbuilder.dataset.client.DataSetExportReadyCallback;
import org.dashbuilder.dataset.def.BeanDataSetDef;
import org.dashbuilder.dataset.def.CSVDataSetDef;
import org.dashbuilder.dataset.def.DataColumnDef;
import org.dashbuilder.dataset.def.DataSetDef;
import org.dashbuilder.dataset.def.ElasticSearchDataSetDef;
import org.dashbuilder.dataset.def.SQLDataSetDef;
import org.dashbuilder.displayer.client.Displayer;
import org.dashbuilder.displayer.client.widgets.filter.DataSetFilterEditor;
import org.uberfire.backend.vfs.Path;
import org.uberfire.ext.widgets.common.client.common.BusyPopup;

@Dependent
public class DataSetEditorView
extends Composite
implements DataSetEditor.View {
    private static final String LOADING_IMAGE_SIZE = "16px";
    private static final int LOADING_SCREEN_TIMEOUT = 60000;
    private static DataSetEditorViewBinder uiBinder = (DataSetEditorViewBinder)GWT.create(DataSetEditorViewBinder.class);
    @UiField
    DataSetEditorViewStyle style;
    @UiField
    FlowPanel mainPanel;
    @UiField
    FlowPanel titlePanel;
    @UiField
    Heading title;
    @UiField
    Modal errorPanel;
    @UiField
    Button errorPanelButton;
    @UiField
    HTML errorMessage;
    @UiField
    HTML errorCause;
    @UiField
    Row errorMessageRow;
    @UiField
    Row errorCauseRow;
    @UiField
    FlowPanel providerSelectionViewPanel;
    @UiField
    DataSetProviderTypeEditor dataSetProviderTypeEditor;
    @UiField
    TabPanel tabPanel;
    @UiField
    FlowPanel tabViewPanel;
    @UiField
    Tab configurationTab;
    @UiField
    Tab previewTab;
    @UiField
    Tab advancedConfigurationTab;
    @UiField
    FlowPanel dataConfigurationPanel;
    @UiField
    FlowPanel basicAttributesEditionViewPanel;
    @UiField
    DataSetBasicAttributesEditor dataSetBasicAttributesEditor;
    @UiField
    FlowPanel specificProviderAttributesPanel;
    @UiField
    FlowPanel sqlAttributesEditionViewPanel;
    @UiField
    SQLDataSetDefAttributesEditor sqlDataSetDefAttributesEditor;
    @UiField
    Button testButton;
    @UiField
    Popover testPopover;
    @UiField
    FlowPanel filterColumnsPreviewTablePanel;
    @UiField
    FlowPanel previewTableEditionViewPanel;
    @UiField
    DataSetPreviewEditor previewTableEditor;
    @UiField
    DisclosurePanel filterAndColumnsEditionDisclosurePanel;
    @UiField
    FlowPanel columnsFilterDisclosurePanelHeader;
    @UiField
    Icon columnsFilterDisclosurePanelButton;
    @UiField
    FlowPanel filterAndColumnsEditionViewPanel;
    @UiField
    TabPanel filterAndColumnsTabPanel;
    @UiField
    Tab columnsTab;
    @UiField
    Tab filterTab;
    @UiField
    DataSetColumnsEditor columnsEditor;
    @UiField
    FlowPanel csvAttributesEditionViewPanel;
    @UiField
    CSVDataSetDefAttributesEditor csvDataSetDefAttributesEditor;
    @UiField
    FlowPanel beanAttributesEditionViewPanel;
    @UiField
    BeanDataSetDefAttributesEditor beanDataSetDefAttributesEditor;
    @UiField
    FlowPanel elAttributesEditionViewPanel;
    @UiField
    ELDataSetDefAttributesEditor elDataSetDefAttributesEditor;
    @UiField
    FlowPanel advancedAttributesEditionViewPanel;
    @UiField
    DataSetAdvancedAttributesEditor dataSetAdvancedAttributesEditor;
    @UiField
    HorizontalPanel buttonsPanel;
    @UiField
    Button cancelButton;
    @UiField
    Button nextButton;
    @UiField
    Popover nextPopover;
    private DataSetDef dataSetDef = null;
    private boolean isEditMode = true;
    private DataSetDefEditWorkflow workflow;
    private HandlerRegistration nextButtonHandlerRegistration = null;
    private HandlerRegistration cancelButtonHandlerRegistration = null;
    private HandlerRegistration testButtonHandlerRegistration = null;
    private HandlerRegistration newDatasetHandlerRegistration = null;
    private HandlerRegistration submitCompleteHandlerRegistration = null;
    private HandlerRegistration columnsChangeHandlerRegistration = null;
    private final DataSetExportReadyCallback exportReadyCallback = new DataSetExportReadyCallback(){

        public void exportReady(Path exportFilePath) {
            String u = DataSetClientServices.get().getDownloadFileUrl(exportFilePath);
            GWT.log((String)("Export URL: " + u));
            Window.open((String)u, (String)"downloading", (String)"resizable=no,scrollbars=yes,status=no");
        }
    };
    private final OpenHandler<DisclosurePanel> openColumnsFilterPanelHandler = new OpenHandler<DisclosurePanel>(){

        public void onOpen(OpenEvent<DisclosurePanel> event) {
            DataSetEditorView.this.columnsFilterDisclosurePanelHeader.setTitle(DataSetEditorConstants.INSTANCE.hideColumnsAndFilter());
            DataSetEditorView.this.columnsFilterDisclosurePanelHeader.addStyleName(DataSetEditorView.this.style.columnsFilterDisclosurePanelHeaderOpen());
            DataSetEditorView.this.columnsFilterDisclosurePanelButton.setType(IconType.STEP_BACKWARD);
            DataSetEditorView.this.columnsFilterDisclosurePanelButton.setTitle(DataSetEditorConstants.INSTANCE.hideColumnsAndFilter());
            DataSetEditorView.this.previewTableEditionViewPanel.removeStyleName(DataSetEditorView.this.style.with100pc());
        }
    };
    private final CloseHandler<DisclosurePanel> closeColumnsFilterPanelHandler = new CloseHandler<DisclosurePanel>(){

        public void onClose(CloseEvent<DisclosurePanel> event) {
            DataSetEditorView.this.columnsFilterDisclosurePanelHeader.setTitle(DataSetEditorConstants.INSTANCE.showColumnsAndFilter());
            DataSetEditorView.this.columnsFilterDisclosurePanelHeader.removeStyleName(DataSetEditorView.this.style.columnsFilterDisclosurePanelHeaderOpen());
            DataSetEditorView.this.columnsFilterDisclosurePanelButton.setType(IconType.STEP_FORWARD);
            DataSetEditorView.this.columnsFilterDisclosurePanelButton.setTitle(DataSetEditorConstants.INSTANCE.showColumnsAndFilter());
            DataSetEditorView.this.previewTableEditionViewPanel.addStyleName(DataSetEditorView.this.style.with100pc());
        }
    };
    private final ClickHandler errorPanelButtonHandler = new ClickHandler(){

        public void onClick(ClickEvent event) {
            DataSetEditorView.this.hideError();
        }
    };

    @Override
    public HandlerRegistration addConfigurationTabClickHandler(ClickHandler handler) {
        return this.configurationTab.addClickHandler(handler);
    }

    @Override
    public HandlerRegistration addPreviewTabClickHandler(ClickHandler handler) {
        return this.previewTab.addClickHandler(handler);
    }

    @Override
    public HandlerRegistration addAdvancedConfigurationTabClickHandler(ClickHandler handler) {
        return this.advancedConfigurationTab.addClickHandler(handler);
    }

    public DataSetEditorView() {
        this.initWidget((Widget)uiBinder.createAndBindUi(this));
        this.filterAndColumnsEditionDisclosurePanel.addOpenHandler(this.openColumnsFilterPanelHandler);
        this.filterAndColumnsEditionDisclosurePanel.addCloseHandler(this.closeColumnsFilterPanelHandler);
        this.hideLoadingView();
        this.errorPanelButton.addClickHandler(this.errorPanelButtonHandler);
        this.showEmptyView();
    }

    @Override
    public DataSetEditor.View setEditMode(boolean editMode) {
        this.isEditMode = editMode;
        return this;
    }

    private void showEmptyView() {
        this.clearView();
    }

    @Override
    public DataSetEditor.View edit(DataSetDef dataSetDef, DataSetDefEditWorkflow workflow) {
        this.dataSetDef = dataSetDef;
        this.workflow = workflow;
        this.clearView();
        this.workflow.clear();
        this.setDataSetDefIntoEditor();
        return this;
    }

    @Override
    public DataSetEditor.View showProviderSelectionView() {
        this.workflow.edit(this.dataSetProviderTypeEditor, this.dataSetDef);
        this.showTitle();
        this.dataSetProviderTypeEditor.setEditMode(!this.isEditMode);
        this.providerSelectionViewPanel.setVisible(true);
        return this;
    }

    private boolean isProviderSelectionViewVisible() {
        return this.providerSelectionViewPanel.isVisible();
    }

    @Override
    public DataSetEditor.View showBasicAttributesEditionView(String uuid) {
        this.workflow.edit(this.dataSetBasicAttributesEditor, this.dataSetDef);
        this.dataSetBasicAttributesEditor.setUUID(uuid);
        this.basicAttributesEditionViewPanel.setVisible(true);
        this.dataSetBasicAttributesEditor.setEditMode(true);
        this.showSpecificProviderAttrsEditionView();
        return this;
    }

    @Override
    public DataSetEditor.View showSQLAttributesEditorView() {
        this.workflow.edit(this.sqlDataSetDefAttributesEditor, (SQLDataSetDef)this.dataSetDef);
        this.sqlAttributesEditionViewPanel.setVisible(true);
        this.sqlDataSetDefAttributesEditor.setEditMode(true);
        this.showSpecificProviderAttrsEditionView();
        return this;
    }

    private boolean isSQLAttributesEditorViewVisible() {
        return this.sqlAttributesEditionViewPanel.isVisible();
    }

    @Override
    public DataSetEditor.View showBeanAttributesEditorView() {
        this.workflow.edit(this.beanDataSetDefAttributesEditor, (BeanDataSetDef)this.dataSetDef);
        this.beanAttributesEditionViewPanel.setVisible(true);
        this.beanDataSetDefAttributesEditor.setEditMode(true);
        this.showSpecificProviderAttrsEditionView();
        return this;
    }

    private boolean isBeanAttributesEditorViewVisible() {
        return this.beanAttributesEditionViewPanel.isVisible();
    }

    @Override
    public DataSetEditor.View showCSVAttributesEditorView(FormPanel.SubmitCompleteHandler submitCompleteHandler) {
        this.workflow.edit(this.csvDataSetDefAttributesEditor, (CSVDataSetDef)this.dataSetDef);
        this.csvAttributesEditionViewPanel.setVisible(true);
        this.csvDataSetDefAttributesEditor.setEditMode(true);
        if (this.submitCompleteHandlerRegistration != null) {
            this.submitCompleteHandlerRegistration.removeHandler();
        }
        this.submitCompleteHandlerRegistration = this.csvDataSetDefAttributesEditor.addSubmitCompleteHandler(submitCompleteHandler);
        this.showSpecificProviderAttrsEditionView();
        return this;
    }

    private boolean isCSVAttributesEditorViewVisible() {
        return this.csvAttributesEditionViewPanel.isVisible();
    }

    @Override
    public DataSetEditor.View showELAttributesEditorView() {
        this.workflow.edit(this.elDataSetDefAttributesEditor, (ElasticSearchDataSetDef)this.dataSetDef);
        this.elAttributesEditionViewPanel.setVisible(true);
        this.elDataSetDefAttributesEditor.setEditMode(true);
        this.showSpecificProviderAttrsEditionView();
        return this;
    }

    private boolean isELAttributesEditorViewVisible() {
        return this.elAttributesEditionViewPanel.isVisible();
    }

    @Override
    public DataSetEditor.View showTestButton(String title, String helpText, ClickHandler testHandler) {
        if (title != null) {
            this.testButton.setText(title);
            this.testPopover.setHeading(title);
            this.testPopover.setText(helpText != null ? helpText : "");
            this.testPopover.reconfigure();
        }
        if (this.testButtonHandlerRegistration != null) {
            this.testButtonHandlerRegistration.removeHandler();
        }
        if (testHandler != null) {
            this.testButtonHandlerRegistration = this.testButton.addClickHandler(testHandler);
        }
        this.testButton.setVisible(true);
        this.buttonsPanel.setVisible(true);
        return this;
    }

    @Override
    public DataSetEditor.View hideTestButton() {
        this.testButton.setVisible(false);
        return this;
    }

    @Override
    public DataSetEditor.View hideCancelButton() {
        this.cancelButton.setVisible(false);
        return this;
    }

    private void showSpecificProviderAttrsEditionView() {
        this.showTab(this.configurationTab);
        this.activeConfigurationTab();
        this.tabViewPanel.setVisible(true);
        this.dataConfigurationPanel.setVisible(true);
    }

    @Override
    public DataSetEditor.View showPreviewTableEditionView(Displayer tableDisplayer) {
        this.hideLoadingView();
        this.previewTableEditor.setVisible(true);
        this.previewTableEditor.setEditMode(true);
        this.previewTableEditor.build(tableDisplayer);
        this.showTab(this.configurationTab);
        this.showTab(this.previewTab);
        this.previewTableEditionViewPanel.setVisible(true);
        this.filterColumnsPreviewTablePanel.setVisible(true);
        this.showFilterColumnsPreviewEditionView();
        return this;
    }

    private boolean isPreviewTableEditionViewVisible() {
        return this.previewTableEditionViewPanel.isVisible();
    }

    @Override
    public DataSetEditor.View showColumnsEditorView(List<DataColumnDef> columns, DataSet dataSet, DataSetColumnsEditor.ColumnsChangedEventHandler columnsChangedEventHandler) {
        this.hideLoadingView();
        this.columnsEditor.setVisible(true);
        boolean isBeanType = DataSetProviderType.BEAN.equals((Object)this.dataSetDef.getProvider());
        this.columnsEditor.setEditMode(!isBeanType);
        this.columnsEditor.build(columns, dataSet, this.workflow);
        if (this.columnsChangeHandlerRegistration != null) {
            this.columnsChangeHandlerRegistration.removeHandler();
        }
        this.columnsChangeHandlerRegistration = this.columnsEditor.addColumnsChangeHandler(columnsChangedEventHandler);
        this.filterAndColumnsEditionViewPanel.setVisible(true);
        this.filterAndColumnsTabPanel.setVisible(true);
        return this;
    }

    private boolean isColumnsEditorViewVisible() {
        return this.filterAndColumnsEditionViewPanel.isVisible();
    }

    @Override
    public DataSetEditor.View showFilterEditionView(DataSet dataSet, DataSetFilterEditor.Listener filterListener) {
        this.filterTab.clear();
        this.hideLoadingView();
        DataSetFilterEditor filterEditor = new DataSetFilterEditor();
        filterEditor.init(dataSet.getMetadata(), this.dataSetDef.getDataSetFilter(), filterListener);
        this.filterTab.add((Widget)filterEditor);
        this.filterAndColumnsEditionViewPanel.setVisible(true);
        this.filterAndColumnsTabPanel.setVisible(true);
        return this;
    }

    private boolean isFilterEditorViewVisible() {
        return this.filterAndColumnsEditionViewPanel.isVisible();
    }

    private void showFilterColumnsPreviewEditionView() {
        this.activePreviewTab();
        this.tabViewPanel.setVisible(true);
        this.showTab(this.configurationTab);
        this.showTab(this.previewTab);
        this.activePreviewTab();
    }

    @Override
    public DataSetEditor.View showAdvancedAttributesEditionView() {
        this.workflow.edit(this.dataSetAdvancedAttributesEditor, this.dataSetDef);
        this.advancedAttributesEditionViewPanel.setVisible(true);
        this.dataSetAdvancedAttributesEditor.setEditMode(true);
        this.showTab(this.configurationTab);
        this.showTab(this.previewTab);
        this.showTab(this.advancedConfigurationTab);
        this.activeAdvancedConfigurationTab();
        this.tabViewPanel.setVisible(true);
        return this;
    }

    private boolean isAdvancedAttributesEditionViewVisible() {
        return this.advancedAttributesEditionViewPanel.isVisible();
    }

    @Override
    public DataSetEditor.View showNextButton(String title, String helpText, ButtonType type, ClickHandler nextHandler) {
        this.nextButton.setVisible(nextHandler != null);
        if (title != null) {
            this.nextButton.setText(title);
            this.nextPopover.setHeading(title);
            this.nextPopover.setText(helpText != null ? helpText : "");
            this.nextPopover.reconfigure();
        }
        ButtonType _type = type != null ? type : ButtonType.PRIMARY;
        this.nextButton.setType(_type);
        if (nextHandler != null) {
            this.removeNextButtonHandler();
            this.nextButtonHandlerRegistration = this.nextButton.addClickHandler(nextHandler);
        }
        this.buttonsPanel.setVisible(true);
        return this;
    }

    @Override
    public DataSetEditor.View enableNextButton(boolean enabled) {
        this.nextButton.setVisible(enabled);
        return this;
    }

    @Override
    public DataSetEditor.View showCancelButton(ClickHandler cancelHandler) {
        this.cancelButton.setVisible(cancelHandler != null);
        if (cancelHandler != null) {
            this.removeCancelButtonHandler();
            this.cancelButtonHandlerRegistration = this.cancelButton.addClickHandler(cancelHandler);
        }
        this.buttonsPanel.setVisible(true);
        return this;
    }

    @Override
    public DataSetEditor.View onSave() {
        this.resetTabErrors();
        DataSetProviderType type = this.dataSetDef.getProvider();
        if (type != null) {
            switch (type) {
                case BEAN: {
                    if (!this.isBeanAttributesEditorViewVisible() || !this.hasViolations(this.beanDataSetDefAttributesEditor.getViolations())) break;
                    this.tabErrors(this.configurationTab);
                    break;
                }
                case CSV: {
                    if (!this.isCSVAttributesEditorViewVisible() || !this.hasViolations(this.csvDataSetDefAttributesEditor.getViolations())) break;
                    this.tabErrors(this.configurationTab);
                    break;
                }
                case SQL: {
                    if (!this.isSQLAttributesEditorViewVisible() || !this.hasViolations(this.sqlDataSetDefAttributesEditor.getViolations())) break;
                    this.tabErrors(this.configurationTab);
                    break;
                }
                case ELASTICSEARCH: {
                    if (!this.isELAttributesEditorViewVisible()) break;
                    this.elDataSetDefAttributesEditor.save();
                    if (!this.hasViolations(this.elDataSetDefAttributesEditor.getViolations())) break;
                    this.tabErrors(this.configurationTab);
                }
            }
        }
        if (this.hasViolations(this.previewTableEditor.getViolations())) {
            this.tabErrors(this.advancedConfigurationTab);
        }
        if (this.hasViolations(this.dataSetAdvancedAttributesEditor.getViolations())) {
            this.tabErrors(this.advancedConfigurationTab);
        }
        if (this.hasViolations(this.columnsEditor.getViolations())) {
            this.tabErrors(this.advancedConfigurationTab);
        }
        return this;
    }

    @Override
    public DataSetEditor.View showLoadingView() {
        BusyPopup.showMessage((String)DataSetEditorConstants.INSTANCE.loading());
        return this;
    }

    @Override
    public DataSetEditor.View hideLoadingView() {
        BusyPopup.close();
        return this;
    }

    @Override
    public DataSetEditor.View showError(String type, String message, String cause) {
        this.errorMessage.setText(message != null ? message : "");
        this.errorMessageRow.setVisible(message != null);
        this.errorCause.setText(cause != null ? cause : "");
        this.errorCauseRow.setVisible(cause != null);
        this.errorPanel.show();
        this.hideLoadingView();
        return this;
    }

    private void hideError() {
        this.errorPanel.hide();
    }

    @Override
    public Set getViolations() {
        LinkedHashSet violations = new LinkedHashSet();
        if (this.dataSetProviderTypeEditor.getViolations() != null) {
            violations.addAll((Collection)this.dataSetProviderTypeEditor.getViolations());
        }
        if (this.dataSetBasicAttributesEditor.getViolations() != null) {
            violations.addAll((Collection)this.dataSetBasicAttributesEditor.getViolations());
        }
        if (this.beanDataSetDefAttributesEditor.getViolations() != null) {
            violations.addAll((Collection)this.beanDataSetDefAttributesEditor.getViolations());
        }
        if (this.csvDataSetDefAttributesEditor.getViolations() != null) {
            violations.addAll((Collection)this.csvDataSetDefAttributesEditor.getViolations());
        }
        if (this.sqlDataSetDefAttributesEditor.getViolations() != null) {
            violations.addAll((Collection)this.sqlDataSetDefAttributesEditor.getViolations());
        }
        if (this.elDataSetDefAttributesEditor.getViolations() != null) {
            violations.addAll(this.elDataSetDefAttributesEditor.getViolations());
        }
        if (this.dataSetAdvancedAttributesEditor.getViolations() != null) {
            violations.addAll((Collection)this.dataSetAdvancedAttributesEditor.getViolations());
        }
        if (this.previewTableEditor.getViolations() != null) {
            violations.addAll((Collection)this.previewTableEditor.getViolations());
        }
        if (this.columnsEditor.getViolations() != null) {
            violations.addAll((Collection)this.columnsEditor.getViolations());
        }
        return violations;
    }

    private boolean hasViolations(Iterable<ConstraintViolation<?>> violations) {
        return violations != null && violations.iterator().hasNext();
    }

    @Override
    public DataSetEditor.View clear() {
        this.clearView();
        this.dataSetProviderTypeEditor.clear();
        this.dataSetBasicAttributesEditor.clear();
        this.beanDataSetDefAttributesEditor.clear();
        this.csvDataSetDefAttributesEditor.clear();
        this.sqlDataSetDefAttributesEditor.clear();
        this.elDataSetDefAttributesEditor.clear();
        this.columnsEditor.clear();
        this.previewTableEditor.clear();
        this.dataSetAdvancedAttributesEditor.clear();
        this.dataSetDef = null;
        this.workflow = null;
        return this;
    }

    private void activeConfigurationTab() {
        this.configurationTab.setActive(true);
        this.previewTab.setActive(false);
        this.advancedConfigurationTab.setActive(false);
    }

    private void activePreviewTab() {
        this.configurationTab.setActive(false);
        this.previewTab.setActive(true);
        this.advancedConfigurationTab.setActive(false);
    }

    private void activeAdvancedConfigurationTab() {
        this.configurationTab.setActive(false);
        this.previewTab.setActive(false);
        this.advancedConfigurationTab.setActive(true);
    }

    private void clearView() {
        this.titlePanel.setVisible(false);
        this.title.setVisible(false);
        this.providerSelectionViewPanel.setVisible(false);
        this.tabViewPanel.setVisible(false);
        this.hideTab(this.configurationTab);
        this.hideTab(this.previewTab);
        this.hideTab(this.advancedConfigurationTab);
        this.advancedAttributesEditionViewPanel.setVisible(false);
        this.sqlAttributesEditionViewPanel.setVisible(false);
        this.csvAttributesEditionViewPanel.setVisible(false);
        this.beanAttributesEditionViewPanel.setVisible(false);
        this.elAttributesEditionViewPanel.setVisible(false);
        this.previewTableEditionViewPanel.setVisible(false);
        this.dataConfigurationPanel.setVisible(false);
        this.filterColumnsPreviewTablePanel.setVisible(false);
        this.testButton.setVisible(false);
        this.nextButton.setVisible(false);
        this.cancelButton.setVisible(false);
        this.buttonsPanel.setVisible(false);
    }

    private void setDataSetDefIntoEditor() {
        this.dataSetProviderTypeEditor.set(this.dataSetDef);
        this.dataSetBasicAttributesEditor.set(this.dataSetDef);
        this.beanDataSetDefAttributesEditor.set(this.dataSetDef);
        this.csvDataSetDefAttributesEditor.set(this.dataSetDef);
        this.sqlDataSetDefAttributesEditor.set(this.dataSetDef);
        this.elDataSetDefAttributesEditor.set(this.dataSetDef);
        this.previewTableEditor.set(this.dataSetDef);
        this.dataSetAdvancedAttributesEditor.set(this.dataSetDef);
    }

    private void showTitle() {
        String _name = null;
        DataSetProviderType _provider = null;
        if (this.dataSetDef != null) {
            if (this.dataSetDef.getName() != null && this.dataSetDef.getName().length() > 0) {
                _name = this.dataSetDef.getName();
            }
            if (this.dataSetDef.getProvider() != null) {
                _provider = this.dataSetDef.getProvider();
            }
            if (_name == null && _provider == null) {
                this.title.setText(DataSetEditorConstants.INSTANCE.newDataSet(""));
            } else if (_provider != null && _name == null) {
                this.title.setText(DataSetEditorConstants.INSTANCE.newDataSet(DataSetEditorView.getProviderName(_provider)));
            } else if (_provider == null) {
                this.title.setText(_name);
            } else {
                this.title.setText(_name + " (" + DataSetEditorView.getProviderName(_provider) + ")");
            }
        }
    }

    public static String getProviderName(DataSetProviderType type) {
        String s = null;
        switch (type) {
            case BEAN: {
                s = DataSetEditorConstants.INSTANCE.bean();
                break;
            }
            case CSV: {
                s = DataSetEditorConstants.INSTANCE.csv();
                break;
            }
            case SQL: {
                s = DataSetEditorConstants.INSTANCE.sql();
                break;
            }
            case ELASTICSEARCH: {
                s = DataSetEditorConstants.INSTANCE.elasticSearch();
            }
        }
        return s;
    }

    private void showTab(Tab tab) {
        tab.asWidget().setVisible(true);
    }

    private void hideTab(Tab tab) {
        tab.asWidget().setVisible(false);
    }

    private void removeNextButtonHandler() {
        if (this.nextButtonHandlerRegistration != null) {
            this.nextButtonHandlerRegistration.removeHandler();
        }
    }

    private void removeCancelButtonHandler() {
        if (this.cancelButtonHandlerRegistration != null) {
            this.cancelButtonHandlerRegistration.removeHandler();
        }
    }

    private void tabErrors(Tab tab) {
        Node first;
        if (tab != null && (first = tab.asWidget().getElement().getFirstChild()).getNodeType() == 1) {
            Element anchor = (Element)first;
            anchor.getStyle().setColor("red");
        }
    }

    private void tabNoErrors(Tab tab) {
        if (tab != null) {
            boolean isActive = tab.isActive();
            Node first = tab.asWidget().getElement().getFirstChild();
            if (first.getNodeType() == 1) {
                Element anchor = (Element)first;
                anchor.getStyle().setColor("#0088CC");
            }
        }
    }

    private void resetTabErrors() {
        this.tabNoErrors(this.configurationTab);
        this.tabNoErrors(this.previewTab);
        this.tabNoErrors(this.advancedConfigurationTab);
    }

    static interface DataSetEditorViewStyle
    extends CssResource {
        public String tabInnerPanel();

        public String columnsFilterDisclosurePanelHeaderOpen();

        public String with100pc();
    }

    static interface DataSetEditorViewBinder
    extends UiBinder<Widget, DataSetEditorView> {
    }
}

