/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.client.widgets.dataset.editor.widgets;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.event.shared.HasHandlers;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import java.util.Collection;
import java.util.List;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.dashbuilder.client.widgets.dataset.editor.widgets.DataSetExplorerView;
import org.dashbuilder.client.widgets.dataset.editor.widgets.events.EditDataSetEventHandler;
import org.dashbuilder.dataprovider.DataSetProviderType;
import org.dashbuilder.dataset.client.DataSetClientServiceError;
import org.dashbuilder.dataset.client.DataSetClientServices;
import org.dashbuilder.dataset.client.DataSetMetadataCallback;
import org.dashbuilder.dataset.def.DataSetDef;
import org.dashbuilder.dataset.events.DataSetDefModifiedEvent;
import org.dashbuilder.dataset.events.DataSetDefRegisteredEvent;
import org.dashbuilder.dataset.events.DataSetDefRemovedEvent;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.uberfire.commons.validation.PortablePreconditions;

@Dependent
public class DataSetExplorer
implements IsWidget {
    DataSetClientServices clientServices;
    View view;
    private final ShowDataSetDefCallback showDataSetDefCallback = new ShowDataSetDefCallback(){

        @Override
        public void getMetadata(DataSetDef def, DataSetMetadataCallback callback) {
            try {
                DataSetClientServices.get().fetchMetadata(def.getUUID(), callback);
            }
            catch (Exception e) {
                DataSetExplorer.this.showError(e);
            }
        }

        @Override
        public boolean isShowBackendCache(DataSetDef def) {
            return def != null && def.getProvider() != null && !DataSetProviderType.BEAN.equals((Object)def.getProvider()) && !DataSetProviderType.CSV.equals((Object)def.getProvider());
        }
    };

    @Inject
    public DataSetExplorer(DataSetClientServices clientServices) {
        this.view = new DataSetExplorerView();
        this.clientServices = clientServices;
        this.init();
    }

    public Widget asWidget() {
        return this.view.asWidget();
    }

    private void init() {
        this.clientServices.getPublicDataSetDefs((RemoteCallback)new RemoteCallback<List<DataSetDef>>(){

            public void callback(List<DataSetDef> dataSetDefs) {
                DataSetExplorer.this.view.set(dataSetDefs);
                DataSetExplorer.this.view.show(DataSetExplorer.this.showDataSetDefCallback);
            }
        });
    }

    private void onDataSetDefRegisteredEvent(@Observes DataSetDefRegisteredEvent event) {
        PortablePreconditions.checkNotNull((String)"event", (Object)event);
        DataSetDef def = event.getDataSetDef();
        if (def != null && def.isPublic()) {
            this.view.add(event.getDataSetDef());
            this.view.show(this.showDataSetDefCallback);
        }
    }

    private void onDataSetDefModifiedEvent(@Observes DataSetDefModifiedEvent event) {
        PortablePreconditions.checkNotNull((String)"event", (Object)event);
        DataSetDef def = event.getNewDataSetDef();
        if (def != null && def.isPublic()) {
            this.view.update(event.getOldDataSetDef(), event.getNewDataSetDef());
            this.view.show(this.showDataSetDefCallback);
        }
    }

    private void onDataSetDefRemovedEvent(@Observes DataSetDefRemovedEvent event) {
        PortablePreconditions.checkNotNull((String)"event", (Object)event);
        this.view.remove(event.getDataSetDef());
        this.view.show(this.showDataSetDefCallback);
    }

    public void showError(DataSetClientServiceError error) {
        String type = error.getThrowable() != null ? error.getThrowable().getClass().getName() : null;
        String message = error.getThrowable() != null ? error.getThrowable().getMessage() : error.getMessage().toString();
        String cause = error.getThrowable() != null && error.getThrowable().getCause() != null ? error.getThrowable().getCause().getMessage() : null;
        this.showError(type, message, cause);
    }

    private void showError(Exception e) {
        this.showError(null, e.getMessage(), null);
    }

    private void showError(String type, String message, String cause) {
        if (type != null) {
            GWT.log((String)("Error type: " + type));
        }
        if (message != null) {
            GWT.log((String)("Error message: " + message));
        }
        if (cause != null) {
            GWT.log((String)("Error cause: " + cause));
        }
        this.view.showError(type, message, cause);
    }

    public HandlerRegistration addEditDataSetEventHandler(EditDataSetEventHandler handler) {
        return this.view.addEditDataSetEventHandler(handler);
    }

    public static interface ShowDataSetDefCallback {
        public void getMetadata(DataSetDef var1, DataSetMetadataCallback var2);

        public boolean isShowBackendCache(DataSetDef var1);
    }

    public static interface View
    extends IsWidget,
    HasHandlers {
        public void set(Collection<DataSetDef> var1);

        public boolean add(DataSetDef var1);

        public void remove(DataSetDef var1);

        public boolean update(DataSetDef var1, DataSetDef var2);

        public void show(ShowDataSetDefCallback var1);

        public void clear();

        public void showError(String var1, String var2, String var3);

        public HandlerRegistration addEditDataSetEventHandler(EditDataSetEventHandler var1);
    }
}

