/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.client.widgets.dataset.editor.widgets;

import com.github.gwtbootstrap.client.ui.Accordion;
import com.github.gwtbootstrap.client.ui.AccordionGroup;
import com.github.gwtbootstrap.client.ui.Button;
import com.github.gwtbootstrap.client.ui.Modal;
import com.github.gwtbootstrap.client.ui.Row;
import com.github.gwtbootstrap.client.ui.event.ShowEvent;
import com.github.gwtbootstrap.client.ui.event.ShowHandler;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.i18n.client.NumberFormat;
import com.google.gwt.resources.client.CssResource;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Panel;
import com.google.gwt.user.client.ui.Widget;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.enterprise.context.Dependent;
import org.dashbuilder.client.widgets.dataset.editor.widgets.DataSetExplorer;
import org.dashbuilder.client.widgets.dataset.editor.widgets.events.EditDataSetEvent;
import org.dashbuilder.client.widgets.dataset.editor.widgets.events.EditDataSetEventHandler;
import org.dashbuilder.client.widgets.resources.i18n.DataSetExplorerConstants;
import org.dashbuilder.dataset.DataSetMetadata;
import org.dashbuilder.dataset.client.DataSetClientServiceError;
import org.dashbuilder.dataset.client.DataSetMetadataCallback;
import org.dashbuilder.dataset.client.resources.bundles.DataSetClientImages;
import org.dashbuilder.dataset.client.resources.bundles.DataSetClientResources;
import org.dashbuilder.dataset.def.DataSetDef;

@Dependent
public class DataSetExplorerView
extends Composite
implements DataSetExplorer.View {
    private static final String WHITESPACE = " ";
    private static final String ICONS_SIZE = "16px";
    private static final String ESTIMATIONS_FORMAT = "#,###.0";
    private static final NumberFormat rowsFormat = NumberFormat.getFormat((String)"##0");
    private static DataSetExplorerViewBinder uiBinder = (DataSetExplorerViewBinder)GWT.create(DataSetExplorerViewBinder.class);
    @UiField
    DataSetExplorerViewStyle style;
    @UiField
    Modal errorPanel;
    @UiField
    Button errorPanelButton;
    @UiField
    HTML errorType;
    @UiField
    HTML errorMessage;
    @UiField
    HTML errorCause;
    @UiField
    Row errorTypeRow;
    @UiField
    Row errorMessageRow;
    @UiField
    Row errorCauseRow;
    @UiField
    Accordion dataSetsAccordion;
    @UiField
    Label label;
    private Set<DataSetDef> dataSets;
    private final ClickHandler errorPanelButtonHandler = new ClickHandler(){

        public void onClick(ClickEvent event) {
            DataSetExplorerView.this.hideError();
        }
    };

    public DataSetExplorerView() {
        this.initWidget((Widget)uiBinder.createAndBindUi(this));
        this.dataSets = new LinkedHashSet<DataSetDef>();
        this.errorPanelButton.addClickHandler(this.errorPanelButtonHandler);
    }

    @Override
    public void set(Collection<DataSetDef> dataSetDefs) {
        this.dataSets = new LinkedHashSet<DataSetDef>(dataSetDefs);
    }

    @Override
    public boolean add(DataSetDef dataSetDef) {
        return this.dataSets.add(dataSetDef);
    }

    @Override
    public void remove(DataSetDef dataSetDef) {
        if (this.dataSets != null && dataSetDef != null && dataSetDef.getUUID() != null) {
            this.remove(dataSetDef.getUUID());
        }
    }

    @Override
    public boolean update(DataSetDef oldDataSetDef, DataSetDef newDataSetDef) {
        this.remove(oldDataSetDef.getUUID());
        return this.dataSets.add(newDataSetDef);
    }

    private void remove(String uuid) {
        if (this.dataSets != null) {
            Iterator<DataSetDef> it = this.dataSets.iterator();
            while (it.hasNext()) {
                DataSetDef def = it.next();
                if (!def.getUUID().equals(uuid)) continue;
                it.remove();
            }
        }
    }

    @Override
    public void clear() {
        this.dataSets.clear();
        this.clearView();
    }

    private void clearView() {
        this.label.setText("");
        this.label.setVisible(false);
        this.dataSetsAccordion.clear();
    }

    @Override
    public void show(DataSetExplorer.ShowDataSetDefCallback callback) {
        this.clearView();
        if (!this.dataSets.isEmpty()) {
            this.label.setVisible(false);
            for (DataSetDef dataSetDef : this.dataSets) {
                AccordionGroup accordionGroup = this.buildDataSetAccordionGroup(dataSetDef, callback);
                this.dataSetsAccordion.add((Widget)accordionGroup);
            }
        } else {
            this.label.setText(DataSetExplorerConstants.INSTANCE.noDataSets());
            this.label.setVisible(true);
        }
        this.dataSetsAccordion.setVisible(true);
    }

    private AccordionGroup buildDataSetAccordionGroup(final DataSetDef dataSetDef, final DataSetExplorer.ShowDataSetDefCallback callback) {
        final AccordionGroup accordionGroup = new AccordionGroup();
        accordionGroup.setHeading(dataSetDef.getName());
        Image typeIcon = this.buildTypeIcon(dataSetDef);
        if (typeIcon != null) {
            accordionGroup.addCustomTrigger((Widget)typeIcon);
        }
        accordionGroup.addShowHandler(new ShowHandler(){

            public void onShow(ShowEvent showEvent) {
                DataSetExplorerView.this.buildDescription(dataSetDef, (Panel)accordionGroup, callback);
            }
        });
        return accordionGroup;
    }

    private Image buildTypeIcon(DataSetDef dataSetDef) {
        Image typeIcon = null;
        switch (dataSetDef.getProvider()) {
            case BEAN: {
                typeIcon = new Image(DataSetClientResources.INSTANCE.images().javaIcon32().getSafeUri());
                typeIcon.setAltText(DataSetExplorerConstants.INSTANCE.bean());
                typeIcon.setTitle(DataSetExplorerConstants.INSTANCE.bean());
                break;
            }
            case CSV: {
                typeIcon = new Image(DataSetClientResources.INSTANCE.images().csvIcon32().getSafeUri());
                typeIcon.setAltText(DataSetExplorerConstants.INSTANCE.csv());
                typeIcon.setTitle(DataSetExplorerConstants.INSTANCE.csv());
                break;
            }
            case SQL: {
                typeIcon = new Image(DataSetClientResources.INSTANCE.images().sqlIcon32().getSafeUri());
                typeIcon.setAltText(DataSetExplorerConstants.INSTANCE.sql());
                typeIcon.setTitle(DataSetExplorerConstants.INSTANCE.sql());
                break;
            }
            case ELASTICSEARCH: {
                typeIcon = new Image(DataSetClientResources.INSTANCE.images().elIcon32().getSafeUri());
                typeIcon.setAltText(DataSetExplorerConstants.INSTANCE.el());
                typeIcon.setTitle(DataSetExplorerConstants.INSTANCE.el());
            }
        }
        typeIcon.setSize(ICONS_SIZE, ICONS_SIZE);
        return typeIcon;
    }

    private void buildDescription(final DataSetDef dataSetDef, Panel parent, DataSetExplorer.ShowDataSetDefCallback callback) {
        if (parent != null) {
            parent.clear();
            DataSetClientImages images = DataSetClientResources.INSTANCE.images();
            HTML statusText = new HTML(DataSetExplorerConstants.INSTANCE.currentStatus());
            statusText.addStyleName(this.style.statusTextTitle());
            boolean isCacheEnabled = dataSetDef.isCacheEnabled();
            FlowPanel cachePanel = null;
            if (callback.isShowBackendCache(dataSetDef)) {
                cachePanel = new FlowPanel();
                com.github.gwtbootstrap.client.ui.Image cacheEnabled = new com.github.gwtbootstrap.client.ui.Image(isCacheEnabled ? images.okIconSmall() : images.cancelIconSmall());
                String _cache = isCacheEnabled ? DataSetExplorerConstants.INSTANCE.enabled() : DataSetExplorerConstants.INSTANCE.disabled();
                cacheEnabled.setTitle(_cache);
                cacheEnabled.setAltText(_cache);
                cacheEnabled.addStyleName(this.style.statusIcon());
                HTML cacheText = new HTML(DataSetExplorerConstants.INSTANCE.cache());
                cacheText.addStyleName(this.style.statusText());
                cachePanel.add((Widget)cacheEnabled);
                cachePanel.add((Widget)cacheText);
            }
            boolean isPushEnabled = dataSetDef.isPushEnabled();
            FlowPanel pushPanel = new FlowPanel();
            com.github.gwtbootstrap.client.ui.Image pushEnabled = new com.github.gwtbootstrap.client.ui.Image(isPushEnabled ? images.okIconSmall() : images.cancelIconSmall());
            String _push = isPushEnabled ? DataSetExplorerConstants.INSTANCE.enabled() : DataSetExplorerConstants.INSTANCE.disabled();
            pushEnabled.setTitle(_push);
            pushEnabled.setAltText(_push);
            pushEnabled.addStyleName(this.style.statusIcon());
            HTML pushText = new HTML(DataSetExplorerConstants.INSTANCE.push());
            pushText.addStyleName(this.style.statusText());
            pushPanel.add((Widget)pushEnabled);
            pushPanel.add((Widget)pushText);
            boolean isRefreshEnabled = dataSetDef.getRefreshTime() != null;
            FlowPanel refreshPanel = new FlowPanel();
            com.github.gwtbootstrap.client.ui.Image refreshEnabled = new com.github.gwtbootstrap.client.ui.Image(isRefreshEnabled ? images.okIconSmall() : images.cancelIconSmall());
            String _refresh = isRefreshEnabled ? DataSetExplorerConstants.INSTANCE.enabled() : DataSetExplorerConstants.INSTANCE.disabled();
            refreshEnabled.setTitle(_refresh);
            refreshEnabled.setAltText(_refresh);
            refreshEnabled.addStyleName(this.style.statusIcon());
            HTML refreshText = new HTML(DataSetExplorerConstants.INSTANCE.refresh());
            refreshText.addStyleName(this.style.statusText());
            refreshPanel.add((Widget)refreshEnabled);
            refreshPanel.add((Widget)refreshText);
            FlowPanel statusPanel = new FlowPanel();
            statusPanel.addStyleName(this.style.statusPanel());
            statusPanel.add((Widget)statusText);
            if (cachePanel != null) {
                statusPanel.add((Widget)cachePanel);
            }
            statusPanel.add((Widget)pushPanel);
            statusPanel.add((Widget)refreshPanel);
            final FlowPanel estimationsPanel = new FlowPanel();
            estimationsPanel.addStyleName(this.style.estimationsPanel());
            HTML currentSizeText = new HTML(DataSetExplorerConstants.INSTANCE.currentSize());
            currentSizeText.addStyleName(this.style.statusTextTitle());
            estimationsPanel.add((Widget)currentSizeText);
            final com.github.gwtbootstrap.client.ui.Image loadingIcon = new com.github.gwtbootstrap.client.ui.Image(DataSetClientResources.INSTANCE.images().loadingIcon().getSafeUri());
            loadingIcon.setTitle(DataSetExplorerConstants.INSTANCE.loading());
            loadingIcon.setAltText(DataSetExplorerConstants.INSTANCE.loading());
            estimationsPanel.add((Widget)loadingIcon);
            callback.getMetadata(dataSetDef, new DataSetMetadataCallback(){

                public void callback(DataSetMetadata metadata) {
                    estimationsPanel.clear();
                    int estimatedSize = metadata.getEstimatedSize();
                    int rowCount = metadata.getNumberOfRows();
                    HTML currentSizeText = new HTML(DataSetExplorerConstants.INSTANCE.currentSize());
                    currentSizeText.addStyleName(DataSetExplorerView.this.style.statusTextTitle());
                    HTML estimatedSizeText = new HTML(DataSetExplorerView.this.humanReadableByteCount(estimatedSize));
                    estimatedSizeText.addStyleName(DataSetExplorerView.this.style.statusText());
                    HTML estimatedRowsText = new HTML(DataSetExplorerView.this.humanReadableRowCount(rowCount) + DataSetExplorerView.WHITESPACE + DataSetExplorerConstants.INSTANCE.rows());
                    estimatedRowsText.addStyleName(DataSetExplorerView.this.style.statusText());
                    estimationsPanel.add((Widget)currentSizeText);
                    estimationsPanel.add((Widget)estimatedRowsText);
                    estimationsPanel.add((Widget)estimatedSizeText);
                }

                public void notFound() {
                    this.error();
                    DataSetExplorerView.this.showError(DataSetExplorerConstants.INSTANCE.notFound());
                }

                public boolean onError(DataSetClientServiceError error) {
                    this.error();
                    DataSetExplorerView.this.showError(error);
                    return false;
                }

                private void error() {
                    loadingIcon.setUrl(DataSetClientResources.INSTANCE.images().cancelIconSmall().getSafeUri());
                    loadingIcon.setTitle(DataSetExplorerConstants.INSTANCE.error());
                    loadingIcon.setAltText(DataSetExplorerConstants.INSTANCE.error());
                }
            });
            FlowPanel columnsPanel = new FlowPanel();
            columnsPanel.addStyleName(this.style.columnsPanel());
            columnsPanel.add((Widget)statusPanel);
            columnsPanel.add((Widget)estimationsPanel);
            parent.add((Widget)columnsPanel);
            FlowPanel buttonsPanel = new FlowPanel();
            Button editButton = new Button(DataSetExplorerConstants.INSTANCE.edit());
            boolean isPublic = dataSetDef.isPublic();
            editButton.setEnabled(isPublic);
            editButton.addStyleName(this.style.button());
            editButton.addClickHandler(new ClickHandler(){

                public void onClick(ClickEvent event) {
                    DataSetExplorerView.this.fireEvent(new EditDataSetEvent(dataSetDef));
                }
            });
            buttonsPanel.addStyleName(this.style.buttonsPanel());
            buttonsPanel.add((Widget)editButton);
            parent.add((Widget)buttonsPanel);
        }
    }

    private void showError(String message) {
        this.showError(null, message, null);
    }

    private void showError(Exception e) {
        this.showError(null, e.getMessage(), null);
    }

    private void showError(DataSetClientServiceError error) {
        String type = error.getThrowable() != null ? error.getThrowable().getClass().getName() : null;
        String message = error.getThrowable() != null ? error.getThrowable().getMessage() : error.getMessage().toString();
        String cause = error.getThrowable() != null && error.getThrowable().getCause() != null ? error.getThrowable().getCause().getMessage() : null;
        this.showError(type, message, cause);
    }

    @Override
    public void showError(String type, String message, String cause) {
        if (type != null) {
            GWT.log((String)("Error type: " + type));
        }
        if (message != null) {
            GWT.log((String)("Error message: " + message));
        }
        if (cause != null) {
            GWT.log((String)("Error cause: " + cause));
        }
        this.errorType.setText(type != null ? type : "");
        this.errorTypeRow.setVisible(type != null);
        this.errorMessage.setText(message != null ? message : "");
        this.errorMessageRow.setVisible(message != null);
        this.errorCause.setText(cause != null ? cause : "");
        this.errorCauseRow.setVisible(cause != null);
        this.errorPanel.show();
    }

    private void hideError() {
        this.errorPanel.hide();
    }

    public String humanReadableByteCount(long bytes) {
        String _b = WHITESPACE + DataSetExplorerConstants.INSTANCE.bytes();
        int unit = 1024;
        if (bytes < (long)unit) {
            return Long.toString(bytes) + _b;
        }
        int exp = (int)(Math.log(bytes) / Math.log(unit));
        String pre = "KMGTPE".charAt(exp - 1) + _b;
        return NumberFormat.getFormat((String)ESTIMATIONS_FORMAT).format((double)bytes / Math.pow(unit, exp)) + pre;
    }

    public String humanReadableRowCount(long rows) {
        int unit = 1000;
        if (rows < (long)unit) {
            return Long.toString(rows);
        }
        int exp = (int)(Math.log(rows) / Math.log(unit));
        String pre = "KMGTPE".charAt(exp - 1) + "";
        return NumberFormat.getFormat((String)ESTIMATIONS_FORMAT).format((double)rows / Math.pow(unit, exp)) + pre;
    }

    @Override
    public HandlerRegistration addEditDataSetEventHandler(EditDataSetEventHandler handler) {
        return this.addHandler(handler, EditDataSetEvent.TYPE);
    }

    static interface DataSetExplorerViewStyle
    extends CssResource {
        public String columnsPanel();

        public String statusPanel();

        public String statusIcon();

        public String statusText();

        public String statusTextTitle();

        public String estimationsPanel();

        public String buttonsPanel();

        public String button();

        public String slidingPanel();

        public String deleteText();
    }

    static interface DataSetExplorerViewBinder
    extends UiBinder<Widget, DataSetExplorerView> {
    }
}

