/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.client.widgets.dataset.editor.widgets.editors.datacolumn;

import com.github.gwtbootstrap.client.ui.Image;
import java.util.EnumMap;
import java.util.Map;
import org.dashbuilder.client.widgets.resources.i18n.DataSetEditorConstants;
import org.dashbuilder.common.client.validation.editors.DropDownImageListEditor;
import org.dashbuilder.dataset.ColumnType;
import org.dashbuilder.dataset.client.resources.bundles.DataSetClientResources;

public class DataColumnTypeEditor
extends DropDownImageListEditor<ColumnType> {
    private ColumnType originalType;

    public DataColumnTypeEditor() {
        this.fireEvents = true;
        this.setAcceptableValues(DataColumnTypeEditor.buildAcceptableValues(null));
    }

    public void setOriginalType(ColumnType originalType) {
        this.originalType = originalType;
        Map<ColumnType, Image> acceptableValues = DataColumnTypeEditor.buildAcceptableValues(originalType);
        this.setAcceptableValues(acceptableValues);
    }

    public ColumnType getOriginalType() {
        return this.originalType;
    }

    public static Map<ColumnType, Image> buildAcceptableValues(ColumnType type) {
        EnumMap<ColumnType, Image> providerEditorValues = new EnumMap<ColumnType, Image>(ColumnType.class);
        if (type != null) {
            if (ColumnType.DATE.equals((Object)type)) {
                Image dateImage = DataColumnTypeEditor.buildTypeSelectorWidget(ColumnType.DATE);
                providerEditorValues.put(ColumnType.DATE, dateImage);
            } else if (ColumnType.LABEL.equals((Object)type)) {
                Image textImage = DataColumnTypeEditor.buildTypeSelectorWidget(ColumnType.TEXT);
                Image labelImage = DataColumnTypeEditor.buildTypeSelectorWidget(ColumnType.LABEL);
                providerEditorValues.put(ColumnType.TEXT, textImage);
                providerEditorValues.put(ColumnType.LABEL, labelImage);
            } else if (ColumnType.TEXT.equals((Object)type)) {
                Image textImage = DataColumnTypeEditor.buildTypeSelectorWidget(ColumnType.TEXT);
                providerEditorValues.put(ColumnType.TEXT, textImage);
            } else if (ColumnType.NUMBER.equals((Object)type)) {
                Image numberImage = DataColumnTypeEditor.buildTypeSelectorWidget(ColumnType.NUMBER);
                Image labelImage = DataColumnTypeEditor.buildTypeSelectorWidget(ColumnType.LABEL);
                providerEditorValues.put(ColumnType.NUMBER, numberImage);
                providerEditorValues.put(ColumnType.LABEL, labelImage);
            }
        }
        return providerEditorValues;
    }

    public static Image buildTypeSelectorWidget(ColumnType type) {
        Image typeIcon = null;
        switch (type) {
            case LABEL: {
                typeIcon = new Image(DataSetClientResources.INSTANCE.images().labelIcon32().getSafeUri());
                typeIcon.setAltText(DataSetEditorConstants.INSTANCE.label());
                typeIcon.setTitle(DataSetEditorConstants.INSTANCE.label());
                break;
            }
            case TEXT: {
                typeIcon = new Image(DataSetClientResources.INSTANCE.images().textIcon32().getSafeUri());
                typeIcon.setAltText(DataSetEditorConstants.INSTANCE.text());
                typeIcon.setTitle(DataSetEditorConstants.INSTANCE.text());
                break;
            }
            case NUMBER: {
                typeIcon = new Image(DataSetClientResources.INSTANCE.images().numberIcon32V3().getSafeUri());
                typeIcon.setAltText(DataSetEditorConstants.INSTANCE.number());
                typeIcon.setTitle(DataSetEditorConstants.INSTANCE.number());
                break;
            }
            case DATE: {
                typeIcon = new Image(DataSetClientResources.INSTANCE.images().dateIcon32().getSafeUri());
                typeIcon.setAltText(DataSetEditorConstants.INSTANCE.date());
                typeIcon.setTitle(DataSetEditorConstants.INSTANCE.date());
            }
        }
        return typeIcon;
    }
}

