/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.client.widgets.dataset.editor.widgets.editors.elasticsearch;

import com.google.gwt.core.client.GWT;
import com.google.gwt.editor.client.Editor;
import com.google.gwt.editor.client.EditorError;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.validation.client.impl.ConstraintViolationImpl;
import com.google.gwt.validation.client.impl.PathImpl;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import javax.enterprise.context.Dependent;
import javax.validation.ConstraintViolation;
import javax.validation.Path;
import org.dashbuilder.client.widgets.dataset.editor.widgets.editors.AbstractDataSetDefEditor;
import org.dashbuilder.common.client.validation.editors.ValueBoxEditorDecorator;
import org.dashbuilder.dataset.client.validation.editors.ELDataSetDefEditor;
import org.dashbuilder.dataset.def.ElasticSearchDataSetDef;
import org.dashbuilder.dataset.validation.DataSetValidationMessages;

@Dependent
public class ELDataSetDefAttributesEditor
extends AbstractDataSetDefEditor
implements ELDataSetDefEditor {
    private static ELDataSetDefAttributesEditorBinder uiBinder = (ELDataSetDefAttributesEditorBinder)GWT.create(ELDataSetDefAttributesEditorBinder.class);
    @UiField
    FlowPanel elAttributesPanel;
    @UiField
    ValueBoxEditorDecorator<String> serverURL;
    @UiField
    ValueBoxEditorDecorator<String> clusterName;
    @UiField
    @Editor.Ignore
    ValueBoxEditorDecorator<String> index;
    @UiField
    @Editor.Ignore
    ValueBoxEditorDecorator<String> type;
    private boolean isEditMode;
    private final ValueChangeHandler<String> indexValueChangeHandler = new ValueChangeHandler<String>(){

        public void onValueChange(ValueChangeEvent<String> event) {
            String _index = (String)event.getValue();
            ELDataSetDefAttributesEditor.this.saveIndex(_index);
        }
    };
    private final ValueChangeHandler<String> typeValueChangeHandler = new ValueChangeHandler<String>(){

        public void onValueChange(ValueChangeEvent<String> event) {
            String _type = (String)event.getValue();
            ELDataSetDefAttributesEditor.this.saveType(_type);
        }
    };

    public ELDataSetDefAttributesEditor() {
        this.initWidget((Widget)uiBinder.createAndBindUi((Object)this));
        this.index.addValueChangeHandler(this.indexValueChangeHandler);
        this.type.addValueChangeHandler(this.typeValueChangeHandler);
    }

    public final void save() {
        this.saveIndex();
        this.saveType();
    }

    private final void saveIndex() {
        this.saveIndex((String)this.index.asEditor().getValue());
    }

    private final void saveIndex(String _index) {
        if (_index == null || _index.trim().length() == 0) {
            this.index.showErrors(this.createErrorList("index", DataSetValidationMessages.INSTANCE.dataSetApi_elDataSetDef_index_notNull(), (Editor<?>)this.index.asEditor()));
            this.createViolation("index", DataSetValidationMessages.INSTANCE.dataSetApi_elDataSetDef_index_notNull(), (Editor<?>)this.index.asEditor());
        } else {
            LinkedList<String> l = new LinkedList<String>();
            l.add(_index);
            this.getDataSetDef().setIndex(l);
        }
    }

    private void createViolation(String path, String message, Editor<?> editor) {
        Iterable violations = this.getViolations();
        ConstraintViolationImpl violation = ConstraintViolationImpl.builder().setPropertyPath((Path)new PathImpl().append(path)).setMessage(message).build();
        violations.add(violation);
    }

    public Collection<ConstraintViolation<?>> getViolations() {
        if (super.getViolations() == null) {
            this.violations = new LinkedList();
        }
        return (Collection)this.violations;
    }

    private final void saveType() {
        this.saveType((String)this.type.asEditor().getValue());
    }

    private final void saveType(String _type) {
        if (_type == null || _type.trim().length() == 0) {
            this.type.showErrors(this.createErrorList("type", DataSetValidationMessages.INSTANCE.dataSetApi_elDataSetDef_type_notNull(), (Editor<?>)this.type.asEditor()));
            this.createViolation("type", DataSetValidationMessages.INSTANCE.dataSetApi_elDataSetDef_type_notNull(), (Editor<?>)this.type.asEditor());
        } else {
            LinkedList<String> l = new LinkedList<String>();
            l.add(_type);
            this.getDataSetDef().setType(l);
        }
    }

    private List<EditorError> createErrorList(String path, String message, Editor<?> editor) {
        EditorError editorError = this.createError(path, message, editor);
        LinkedList<EditorError> result = new LinkedList<EditorError>();
        result.add(editorError);
        return result;
    }

    private EditorError createError(final String path, final String message, final Editor<?> editor) {
        return new EditorError(){
            private boolean consumed = false;

            public String getAbsolutePath() {
                return path;
            }

            public Editor<?> getEditor() {
                return editor;
            }

            public String getMessage() {
                return message;
            }

            public String getPath() {
                return null;
            }

            public Object getUserData() {
                return null;
            }

            public Object getValue() {
                return null;
            }

            public boolean isConsumed() {
                return this.consumed;
            }

            public void setConsumed(boolean consumed) {
                this.consumed = consumed;
            }
        };
    }

    private ElasticSearchDataSetDef getDataSetDef() {
        return (ElasticSearchDataSetDef)this.dataSetDef;
    }

    public boolean isEditMode() {
        return this.isEditMode;
    }

    public void setEditMode(boolean isEditMode) {
        this.isEditMode = isEditMode;
    }

    public void showErrors(List<EditorError> errors) {
        this.consumeErrors(errors);
    }

    @Override
    public void clear() {
        super.clear();
        this.serverURL.clear();
        this.clusterName.clear();
        this.index.clear();
        this.type.clear();
    }

    static interface ELDataSetDefAttributesEditorBinder
    extends UiBinder<Widget, ELDataSetDefAttributesEditor> {
    }
}

