/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.client.widgets.dataset.editor.widgets.editors;

import com.github.gwtbootstrap.client.ui.CheckBox;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.resources.client.CssResource;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.Panel;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.enterprise.context.Dependent;
import javax.validation.ConstraintViolation;
import org.dashbuilder.client.widgets.dataset.editor.DataSetDefEditWorkflow;
import org.dashbuilder.client.widgets.dataset.editor.widgets.editors.AbstractEditor;
import org.dashbuilder.client.widgets.dataset.editor.widgets.editors.datacolumn.DataColumnBasicEditor;
import org.dashbuilder.dataset.ColumnType;
import org.dashbuilder.dataset.DataColumn;
import org.dashbuilder.dataset.DataSet;
import org.dashbuilder.dataset.def.DataColumnDef;

@Dependent
public class DataSetColumnsEditor
extends AbstractEditor {
    private static DataSetColumnsEditorBinder uiBinder = (DataSetColumnsEditorBinder)GWT.create(DataSetColumnsEditorBinder.class);
    @UiField
    DataSetColumnsEditorStyle style;
    @UiField
    FlowPanel columnsPanel;
    private List<DataColumnDef> originalColumns;
    private boolean isEditMode;
    private final Map<DataColumnDef, DataColumnBasicEditor> columnEditors = new LinkedHashMap<DataColumnDef, DataColumnBasicEditor>();
    private final List<DataColumnDef> columns = new LinkedList<DataColumnDef>();
    private final ValueChangeHandler<ColumnType> columnTypeChangeHandler = new ValueChangeHandler<ColumnType>(){

        public void onValueChange(ValueChangeEvent<ColumnType> event) {
            DataSetColumnsEditor.this.fireColumnsChanged();
        }
    };

    public DataSetColumnsEditor() {
        this.initWidget((Widget)uiBinder.createAndBindUi((Object)this));
    }

    public boolean isEditMode() {
        return this.isEditMode;
    }

    public void setEditMode(boolean isEditMode) {
        this.isEditMode = isEditMode;
    }

    public HandlerRegistration addColumnsChangeHandler(ColumnsChangedEventHandler handler) {
        return this.addHandler(handler, ColumnsChangedEvent.TYPE);
    }

    public void build(List<DataColumnDef> columns, DataSet dataSet, DataSetDefEditWorkflow workflow) {
        this.clear();
        if (columns != null && workflow != null) {
            this.originalColumns = new LinkedList<DataColumnDef>(columns);
            workflow.removeAllColumns();
            for (DataColumnDef _column : columns) {
                boolean enabled;
                DataColumnDef column = _column.clone();
                DataColumn dataSetColumn = this.hasColumn(column, dataSet.getColumns());
                boolean bl = enabled = dataSetColumn != null;
                if (enabled) {
                    column.setColumnType(dataSetColumn.getColumnType());
                }
                DataColumnBasicEditor columnEditor = new DataColumnBasicEditor();
                columnEditor.addValueChangeHandler(this.columnTypeChangeHandler);
                columnEditor.setEditorId(column.getId());
                columnEditor.setOriginalType(_column.getColumnType());
                this.columnEditors.put(column, columnEditor);
                workflow.edit(columnEditor, column);
                columnEditor.setEditMode(this.isEditMode() && enabled);
                boolean canRemove = dataSet != null && dataSet.getColumns().size() > 1;
                Panel columnPanel = this.createColumn(column, columnEditor, workflow, enabled, canRemove);
                if (enabled) {
                    this.columns.add(column);
                }
                this.columnsPanel.add((Widget)columnPanel);
                FlowPanel separator = new FlowPanel();
                separator.addStyleName(this.style.clear());
                this.columnsPanel.add((Widget)separator);
            }
        }
    }

    private DataColumn hasColumn(DataColumnDef def, List<DataColumn> columns) {
        if (columns == null || def == null) {
            return null;
        }
        for (DataColumn c : columns) {
            if (!c.getId().equals(def.getId())) continue;
            return c;
        }
        return null;
    }

    private Panel createColumn(final DataColumnDef column, final DataColumnBasicEditor editor, final DataSetDefEditWorkflow workflow, boolean enabled, final boolean canRemove) {
        FlowPanel columnPanel = new FlowPanel();
        CheckBox columnStatus = new CheckBox();
        columnStatus.setValue(Boolean.valueOf(enabled));
        columnStatus.addStyleName(this.style.left());
        columnStatus.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<Boolean>(){

            public void onValueChange(ValueChangeEvent<Boolean> event) {
                boolean isChecked = (Boolean)event.getValue();
                if (isChecked) {
                    DataSetColumnsEditor.this.addColumn(column, workflow);
                } else if (canRemove) {
                    DataSetColumnsEditor.this.removeColumn(editor, column, workflow);
                }
            }
        });
        columnPanel.add((Widget)columnStatus);
        editor.addStyleName(this.style.left());
        columnPanel.add((Widget)editor);
        return columnPanel;
    }

    private void removeColumn(DataColumnBasicEditor editor, DataColumnDef column, DataSetDefEditWorkflow workflow) {
        editor.setEditMode(false);
        this.columns.remove(column);
        this.fireColumnsChanged();
    }

    private void addColumn(DataColumnDef column, DataSetDefEditWorkflow workflow) {
        DataColumnBasicEditor columnEditor = this.getEditor(column);
        assert (columnEditor != null);
        columnEditor.setEditMode(this.isEditMode());
        this.columns.add(column);
        this.fireColumnsChanged();
    }

    private DataColumnBasicEditor getEditor(DataColumnDef columnDef) {
        if (!this.columnEditors.isEmpty()) {
            for (Map.Entry<DataColumnDef, DataColumnBasicEditor> entry : this.columnEditors.entrySet()) {
                DataColumnDef _c = entry.getKey();
                if (_c == null || !_c.equals((Object)columnDef)) continue;
                return entry.getValue();
            }
        }
        return null;
    }

    private void fireColumnsChanged() {
        if (this.columns != null) {
            ArrayList<DataColumnDef> result = new ArrayList<DataColumnDef>();
            for (DataColumnDef column : this.originalColumns) {
                int _ci = this.columns.indexOf(column);
                if (_ci <= -1) continue;
                DataColumnDef _c = this.columns.get(_ci);
                result.add(_c);
            }
            this.fireEvent(new ColumnsChangedEvent(new LinkedList<DataColumnDef>(result)));
        }
    }

    @Override
    public Iterable<ConstraintViolation<?>> getViolations() {
        LinkedHashSet violations = new LinkedHashSet();
        if (!this.columnEditors.isEmpty()) {
            for (DataColumnBasicEditor editor : this.columnEditors.values()) {
                Iterable<ConstraintViolation<?>> editorViolations = editor.getViolations();
                if (editorViolations == null) continue;
                for (ConstraintViolation<?> violation : editorViolations) {
                    violations.add(violation);
                }
            }
        }
        return violations;
    }

    @Override
    public void setViolations(Iterable<ConstraintViolation<?>> violations) {
        super.setViolations(violations);
        if (!this.columnEditors.isEmpty()) {
            for (DataColumnBasicEditor editor : this.columnEditors.values()) {
                editor.setViolations(violations);
            }
        }
    }

    @Override
    public void clear() {
        super.clear();
        this.columnEditors.clear();
        this.columnsPanel.clear();
        this.columns.clear();
        this.originalColumns = null;
    }

    public static class ColumnsChangedEvent
    extends GwtEvent<ColumnsChangedEventHandler> {
        public static GwtEvent.Type<ColumnsChangedEventHandler> TYPE = new GwtEvent.Type();
        private List<DataColumnDef> columns;

        public ColumnsChangedEvent(List<DataColumnDef> columns) {
            this.columns = columns;
        }

        public GwtEvent.Type getAssociatedType() {
            return TYPE;
        }

        protected void dispatch(ColumnsChangedEventHandler handler) {
            handler.onColumnsChanged(this);
        }

        public List<DataColumnDef> getColumns() {
            return this.columns;
        }
    }

    public static interface ColumnsChangedEventHandler
    extends EventHandler {
        public void onColumnsChanged(ColumnsChangedEvent var1);
    }

    static interface DataSetColumnsEditorStyle
    extends CssResource {
        public String mainPanel();

        public String left();

        public String clear();
    }

    static interface DataSetColumnsEditorBinder
    extends UiBinder<Widget, DataSetColumnsEditor> {
    }
}

