/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.client.widgets.dataset.editor.widgets.editors;

import com.github.gwtbootstrap.client.ui.Image;
import com.google.gwt.core.client.GWT;
import com.google.gwt.editor.client.EditorError;
import com.google.gwt.resources.client.CssResource;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.ui.Widget;
import java.util.EnumMap;
import java.util.List;
import javax.enterprise.context.Dependent;
import org.dashbuilder.client.widgets.dataset.editor.widgets.editors.AbstractDataSetDefEditor;
import org.dashbuilder.client.widgets.resources.i18n.DataSetEditorConstants;
import org.dashbuilder.common.client.validation.editors.ImageListEditor;
import org.dashbuilder.dataprovider.DataSetProviderType;
import org.dashbuilder.dataset.client.resources.bundles.DataSetClientResources;
import org.dashbuilder.dataset.client.validation.editors.DataSetDefEditor;

@Dependent
public class DataSetProviderTypeEditor
extends AbstractDataSetDefEditor
implements DataSetDefEditor {
    private static final int ICONS_SIZE = 160;
    private static DataSetProviderTypeEditorBinder uiBinder = (DataSetProviderTypeEditorBinder)GWT.create(DataSetProviderTypeEditorBinder.class);
    @UiField
    ImageListEditor<DataSetProviderType> provider;
    @UiField
    DataSetProviderTypeEditorStyle style;
    private boolean isEditMode;

    public void showErrors(List<EditorError> errors) {
        this.consumeErrors(errors);
    }

    public DataSetProviderTypeEditor() {
        this.initWidget((Widget)uiBinder.createAndBindUi((Object)this));
        EnumMap<DataSetProviderType, ImageListEditor.Entry> providerEditorValues = new EnumMap<DataSetProviderType, ImageListEditor.Entry>(DataSetProviderType.class);
        for (DataSetProviderType type : DataSetProviderType.values()) {
            if (DataSetProviderType.SQL == type) continue;
            Image _image = this.buildTypeSelectorWidget(type);
            String _heading = this.buildTypeSelectorHeading(type);
            String _text = this.buildTypeSelectorText(type);
            if (_image == null) continue;
            providerEditorValues.put(type, new ImageListEditor.Entry(_image, _heading, _text));
        }
        this.provider.setSize(160, 160);
        this.provider.setImageStyle(this.style.providerIcon());
        this.provider.setAcceptableValues(providerEditorValues);
    }

    private String buildTypeSelectorHeading(DataSetProviderType type) {
        return type.name();
    }

    private String buildTypeSelectorText(DataSetProviderType type) {
        String description = null;
        switch (type) {
            case BEAN: {
                description = DataSetEditorConstants.INSTANCE.bean_description();
                break;
            }
            case CSV: {
                description = DataSetEditorConstants.INSTANCE.csv_description();
                break;
            }
            case SQL: {
                description = DataSetEditorConstants.INSTANCE.sql_description();
                break;
            }
            case ELASTICSEARCH: {
                description = DataSetEditorConstants.INSTANCE.elasticSearch_description();
            }
        }
        return description;
    }

    private Image buildTypeSelectorWidget(DataSetProviderType type) {
        Image typeIcon = null;
        switch (type) {
            case BEAN: {
                typeIcon = new Image(DataSetClientResources.INSTANCE.images().javaIcon160().getSafeUri());
                typeIcon.setAltText(DataSetEditorConstants.INSTANCE.bean());
                typeIcon.setTitle(DataSetEditorConstants.INSTANCE.bean());
                break;
            }
            case CSV: {
                typeIcon = new Image(DataSetClientResources.INSTANCE.images().csvIcon160().getSafeUri());
                typeIcon.setAltText(DataSetEditorConstants.INSTANCE.csv());
                typeIcon.setTitle(DataSetEditorConstants.INSTANCE.csv());
                break;
            }
            case SQL: {
                typeIcon = new Image(DataSetClientResources.INSTANCE.images().sqlIcon160().getSafeUri());
                typeIcon.setAltText(DataSetEditorConstants.INSTANCE.sql());
                typeIcon.setTitle(DataSetEditorConstants.INSTANCE.sql());
                break;
            }
            case ELASTICSEARCH: {
                typeIcon = new Image(DataSetClientResources.INSTANCE.images().elIcon160().getSafeUri());
                typeIcon.setAltText(DataSetEditorConstants.INSTANCE.elasticSearch());
                typeIcon.setTitle(DataSetEditorConstants.INSTANCE.elasticSearch());
            }
        }
        return typeIcon;
    }

    public boolean isEditMode() {
        return this.isEditMode;
    }

    public void setEditMode(boolean isEditMode) {
        this.isEditMode = isEditMode;
        this.provider.setEditMode(isEditMode);
    }

    @Override
    public void clear() {
        super.clear();
        this.provider.clear();
    }

    static interface DataSetProviderTypeEditorStyle
    extends CssResource {
        public String providerIcon();
    }

    static interface DataSetProviderTypeEditorBinder
    extends UiBinder<Widget, DataSetProviderTypeEditor> {
    }
}

