/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.client.widgets.dataset.editor.widgets;

import com.github.gwtbootstrap.client.ui.constants.ButtonType;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.event.shared.HasHandlers;
import com.google.gwt.user.client.ui.FormPanel;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.dashbuilder.client.widgets.dataset.editor.DataSetDefEditWorkflow;
import org.dashbuilder.client.widgets.dataset.editor.widgets.DataSetDefValidationCallback;
import org.dashbuilder.client.widgets.dataset.editor.widgets.DataSetEditorView;
import org.dashbuilder.client.widgets.dataset.editor.widgets.editors.DataSetColumnsEditor;
import org.dashbuilder.client.widgets.dataset.editor.widgets.events.SaveDataSetEvent;
import org.dashbuilder.client.widgets.dataset.editor.widgets.events.SaveDataSetEventHandler;
import org.dashbuilder.client.widgets.resources.i18n.DataSetEditorConstants;
import org.dashbuilder.common.client.error.ClientRuntimeError;
import org.dashbuilder.dataset.DataColumn;
import org.dashbuilder.dataset.DataSet;
import org.dashbuilder.dataset.DataSetLookup;
import org.dashbuilder.dataset.backend.EditDataSetDef;
import org.dashbuilder.dataset.client.DataSetClientServices;
import org.dashbuilder.dataset.client.DataSetReadyCallback;
import org.dashbuilder.dataset.def.DataColumnDef;
import org.dashbuilder.dataset.def.DataSetDef;
import org.dashbuilder.dataset.filter.DataSetFilter;
import org.dashbuilder.displayer.DisplayerSettings;
import org.dashbuilder.displayer.DisplayerSettingsFactory;
import org.dashbuilder.displayer.TableDisplayerSettingsBuilder;
import org.dashbuilder.displayer.client.AbstractDisplayerListener;
import org.dashbuilder.displayer.client.DataSetHandler;
import org.dashbuilder.displayer.client.DataSetHandlerImpl;
import org.dashbuilder.displayer.client.Displayer;
import org.dashbuilder.displayer.client.DisplayerHelper;
import org.dashbuilder.displayer.client.DisplayerListener;
import org.dashbuilder.displayer.client.widgets.filter.DataSetFilterEditor;
import org.dashbuilder.displayer.impl.TableDisplayerSettingsBuilderImpl;
import org.jboss.errai.common.client.api.RemoteCallback;

@Dependent
public class DataSetEditor
implements IsWidget {
    private static final int PREVIEW_TABLE_PAGE_SIZE = 6;
    final DataSetDefEditWorkflow workflow = new DataSetDefEditWorkflow();
    protected final View view = new DataSetEditorView();
    protected DataSetClientServices clientServices;
    protected DataSetDef dataSetDef;
    protected List<DataColumnDef> originalColumns;
    protected boolean updateColumnsView = false;
    protected Displayer tableDisplayer;
    protected WorkflowView currentWfView;
    protected boolean editMode = false;
    protected DataSetDefValidationCallback validationCallback = null;
    private final RemoteCallback<DataSetDef> createBrandNewDataSetDefCallback = new RemoteCallback<DataSetDef>(){

        public void callback(DataSetDef dataSetDef) {
            DataSetEditor.this.dataSetDef = dataSetDef;
            DataSetEditor.this.edit();
            DataSetEditor.this.currentWfView = WorkflowView.DATA_CONF;
            DataSetEditor.this.showBasicAttributesEditionView();
            DataSetEditor.this.showCancelButton();
            DataSetEditor.this.showTestButton();
            DataSetEditor.this.showProviderSpecificAttributesEditionView(false);
        }
    };
    private final ClickHandler providerScreenNextButtonHandler = new ClickHandler(){

        public void onClick(ClickEvent event) {
            Set violations = DataSetEditor.this.save();
            if (DataSetEditor.this.isValid(violations)) {
                try {
                    DataSetEditor.this.clientServices.newDataSet(DataSetEditor.this.dataSetDef.getProvider(), DataSetEditor.this.createBrandNewDataSetDefCallback);
                }
                catch (Exception e) {
                    DataSetEditor.this.showError(e);
                }
            }
        }
    };
    private final ClickHandler testButtonHandler = new ClickHandler(){

        public void onClick(ClickEvent event) {
            Set violations = DataSetEditor.this.save();
            if (DataSetEditor.this.isValid(violations)) {
                DataSetEditor.this.dataSetDef.setAllColumnsEnabled(true);
                DataSetEditor.this.dataSetDef.setColumns(null);
                DataSetEditor.this.dataSetDef.setDataSetFilter(null);
                DataSetEditor.this.originalColumns = null;
                DataSetEditor.this.updateColumnsView = true;
                DataSetEditor.this.updateTableDisplayer();
            }
        }
    };
    private final ClickHandler configurationTabClickHandler = new ClickHandler(){

        public void onClick(ClickEvent event) {
            DataSetEditor.this.showTestButton();
        }
    };
    private final ClickHandler previewTabClickHandler = new ClickHandler(){

        public void onClick(ClickEvent event) {
            DataSetEditor.this.hideTestButton();
            DataSetEditor.this.view.enableNextButton(!DataSetEditor.this.editMode);
        }
    };
    private final ClickHandler advancedConfigurationTabClickHandler = new ClickHandler(){

        public void onClick(ClickEvent event) {
            DataSetEditor.this.hideTestButton();
            DataSetEditor.this.view.enableNextButton(!DataSetEditor.this.editMode);
        }
    };
    private final ClickHandler saveButtonHandler = new ClickHandler(){

        public void onClick(ClickEvent event) {
            DataSetEditor.this.checkValid(new DataSetDefValidationCallback(){

                @Override
                public void valid(DataSetDef def, DataSet dataSet) {
                    DataSetEditor.this.onSave();
                }

                @Override
                public void invalid(ClientRuntimeError error) {
                    DataSetEditor.this.showError(error);
                }
            });
        }
    };
    private SaveDataSetEventHandler saveCallbackHandler = null;
    private final FormPanel.SubmitCompleteHandler submitCompleteHandler = new FormPanel.SubmitCompleteHandler(){

        public void onSubmitComplete(FormPanel.SubmitCompleteEvent event) {
            GWT.log((String)("DataSetEditor#submitCompleteHandler: " + event.getResults()));
        }
    };
    private final ClickHandler cancelHandler = new ClickHandler(){

        public void onClick(ClickEvent event) {
            DataSetEditor.this.newDataSetDef();
        }
    };
    private final DataSetColumnsEditor.ColumnsChangedEventHandler columnsChangedEventHandler = new DataSetColumnsEditor.ColumnsChangedEventHandler(){

        @Override
        public void onColumnsChanged(DataSetColumnsEditor.ColumnsChangedEvent event) {
            DataSetEditor.this.updateDataSetDefColumns(event.getColumns());
            DataSetEditor.this.updateTableDisplayer();
        }
    };
    private final DataSetFilterEditor.Listener filterListener = new DataSetFilterEditor.Listener(){

        public void filterChanged(DataSetFilter filter) {
            DataSetEditor.this.dataSetDef.setDataSetFilter(filter);
            DataSetEditor.this.updateTableDisplayer();
        }
    };
    private final DisplayerListener tablePreviewListener = new AbstractDisplayerListener(){

        public void onDraw(Displayer displayer) {
            DataSet dataSet;
            if (displayer != null && (dataSet = displayer.getDataSetHandler().getLastDataSet()) != null) {
                List dataSetColumns;
                boolean isFillColumns;
                DataSetEditor.this.currentWfView = WorkflowView.PREVIEW_AND_ADVANCED;
                if (DataSetEditor.this.dataSetDef.getUUID() == null) {
                    DataSetEditor.this.dataSetDef.setUUID(dataSet.getUUID());
                }
                boolean bl = isFillColumns = DataSetEditor.this.originalColumns == null;
                if (isFillColumns && (dataSetColumns = dataSet.getColumns()) != null) {
                    LinkedList<DataColumnDef> cDefs = new LinkedList<DataColumnDef>();
                    for (DataColumn column : dataSetColumns) {
                        DataColumnDef cDef = new DataColumnDef(column.getId(), column.getColumnType());
                        cDefs.add(cDef);
                    }
                    DataSetEditor.this.originalColumns = new LinkedList<DataColumnDef>(cDefs);
                    DataSetEditor.this.updateDataSetDefColumns(cDefs);
                }
                DataSetEditor.this.showBasicAttributesEditionView();
                DataSetEditor.this.showAdvancedAttributesEditionView();
                DataSetEditor.this.showPreviewTableEditionView();
                if (DataSetEditor.this.updateColumnsView) {
                    DataSetEditor.this.showColumnsEditorView(dataSet);
                    DataSetEditor.this.showFilterEditorView(dataSet);
                }
                DataSetEditor.this.hideTestButton();
                DataSetEditor.this.showSaveButton();
                if (DataSetEditor.this.validationCallback != null) {
                    DataSetEditor.this.validationCallback.valid(DataSetEditor.this.dataSetDef, dataSet);
                    DataSetEditor.this.validationCallback = null;
                }
            }
        }

        public void onError(Displayer displayer, ClientRuntimeError error) {
            DataSetEditor.this.showError(error);
            if (DataSetEditor.this.validationCallback != null) {
                DataSetEditor.this.validationCallback.invalid(error);
                DataSetEditor.this.validationCallback = null;
            }
        }
    };

    @Inject
    public DataSetEditor(DataSetClientServices clientServices) {
        this.clientServices = clientServices;
        this.init();
    }

    private void init() {
        this.view.addConfigurationTabClickHandler(this.configurationTabClickHandler);
        this.view.addPreviewTabClickHandler(this.previewTabClickHandler);
        this.view.addAdvancedConfigurationTabClickHandler(this.advancedConfigurationTabClickHandler);
    }

    public DataSetEditor setWidth(String w) {
        ((DataSetEditorView)this.view).setWidth(w);
        return this;
    }

    public DataSetEditor newDataSetDef() {
        this.clear();
        this.dataSetDef = new DataSetDef();
        this.originalColumns = null;
        this.updateColumnsView = true;
        this.editMode = false;
        this.view.setEditMode(false);
        this.edit();
        this.currentWfView = WorkflowView.PROVIDER_SELECTION;
        this.showProviderSelectionView();
        this.showNextButton();
        this.hideCancelButton();
        return this;
    }

    public void editDataSetDef(EditDataSetDef editDataSetDef) {
        this.clear();
        this.dataSetDef = editDataSetDef.getDefinition();
        this.originalColumns = editDataSetDef.getColumns();
        this.updateColumnsView = true;
        if (this.dataSetDef == null) {
            this.showError(DataSetEditorConstants.INSTANCE.defNotFound());
            return;
        }
        this.edit();
        this.editMode = true;
        this.view.setEditMode(true);
        this.showBasicAttributesEditionView();
        this.showProviderSpecificAttributesEditionView(true);
        this.hideTestButton();
        this.updateTableDisplayer();
    }

    private void updateTableDisplayer() {
        if (this.dataSetDef != null) {
            TableDisplayerSettingsBuilder tableDisplayerSettingsBuilder = (TableDisplayerSettingsBuilder)((TableDisplayerSettingsBuilderImpl)((TableDisplayerSettingsBuilderImpl)((TableDisplayerSettingsBuilderImpl)DisplayerSettingsFactory.newTableSettings().dataset(this.dataSetDef.getUUID())).renderer("default")).titleVisible(false)).tablePageSize(6).tableOrderEnabled(true).filterOn(true, false, false);
            List columns = this.dataSetDef.getColumns();
            if (columns != null && !columns.isEmpty()) {
                for (DataColumnDef column : columns) {
                    tableDisplayerSettingsBuilder.column(column.getId());
                }
            }
            DataSetDef editCloneWithoutCacheSettings = this.dataSetDef.clone();
            editCloneWithoutCacheSettings.setCacheEnabled(false);
            DisplayerSettings settings = tableDisplayerSettingsBuilder.buildSettings();
            this.tableDisplayer = DisplayerHelper.lookupDisplayer((DisplayerSettings)settings);
            this.tableDisplayer.setDataSetHandler((DataSetHandler)new DataSetHandlerForEdit(settings.getDataSetLookup(), editCloneWithoutCacheSettings));
            this.tableDisplayer.addListener(new DisplayerListener[]{this.tablePreviewListener});
            if (this.tableDisplayer != null) {
                this.tableDisplayer.draw();
            }
            this.view.showLoadingView();
        }
    }

    public void checkValid(DataSetDefValidationCallback callback) {
        Set violations = this.save();
        if (!this.isValid(violations)) {
            callback.invalid(null);
        } else {
            this.validationCallback = callback;
            this.updateTableDisplayer();
        }
    }

    private boolean isValid(Set violations) {
        return violations.isEmpty();
    }

    private void onSave() {
        this.dataSetDef.setPublic(true);
        this.dataSetDef.setAllColumnsEnabled(false);
        if (this.saveCallbackHandler != null) {
            this.saveCallbackHandler.onSaveDataSet(new SaveDataSetEvent(this.dataSetDef));
        }
    }

    public void addSaveDataSetEventHandler(SaveDataSetEventHandler handler) {
        this.saveCallbackHandler = handler;
    }

    public Widget asWidget() {
        return this.view.asWidget();
    }

    public void showError(Throwable e) {
        this.showError(new ClientRuntimeError(e));
    }

    public void showError(ClientRuntimeError error) {
        this.view.showError(error.getMessage(), error.getCause());
    }

    public void showError(String message) {
        this.view.showError(message, null);
    }

    private void showProviderSelectionView() {
        this.view.showProviderSelectionView();
    }

    private void showBasicAttributesEditionView() {
        String _uuid = this.dataSetDef.getUUID();
        this.view.showBasicAttributesEditionView(_uuid);
    }

    private void showProviderSpecificAttributesEditionView(boolean isEdit) {
        switch (this.dataSetDef.getProvider()) {
            case SQL: {
                this.view.showSQLAttributesEditorView();
                break;
            }
            case CSV: {
                this.view.showCSVAttributesEditorView(this.submitCompleteHandler);
                break;
            }
            case BEAN: {
                this.view.showBeanAttributesEditorView();
                break;
            }
            case ELASTICSEARCH: {
                this.view.showELAttributesEditorView();
            }
        }
    }

    private void showColumnsEditorView(DataSet dataSet) {
        this.view.showColumnsEditorView(this.originalColumns, dataSet, this.columnsChangedEventHandler);
        this.updateColumnsView = false;
    }

    private void showFilterEditorView(DataSet dataSet) {
        this.view.showFilterEditionView(dataSet, this.filterListener);
    }

    private void showPreviewTableEditionView() {
        this.view.showPreviewTableEditionView(this.tableDisplayer);
    }

    private void showAdvancedAttributesEditionView() {
        this.view.showAdvancedAttributesEditionView();
    }

    private View edit() {
        return this.view.edit(this.dataSetDef, this.workflow);
    }

    private Set save() {
        this.workflow.save();
        this.view.onSave();
        return this.view.getViolations();
    }

    private void updateDataSetDefColumns(List<DataColumnDef> columns) {
        this.dataSetDef.setAllColumnsEnabled(false);
        this.dataSetDef.setColumns(columns);
    }

    private void showNextButton() {
        this.view.enableNextButton(true);
        this.view.showNextButton(DataSetEditorConstants.INSTANCE.next(), DataSetEditorConstants.INSTANCE.next_description(), ButtonType.PRIMARY, this.providerScreenNextButtonHandler);
    }

    private void showSaveButton() {
        this.view.enableNextButton(!this.editMode);
        if (!this.editMode) {
            this.view.showNextButton(DataSetEditorConstants.INSTANCE.save(), DataSetEditorConstants.INSTANCE.save_description(), ButtonType.SUCCESS, this.saveButtonHandler);
        }
    }

    private void showTestButton() {
        this.view.enableNextButton(false);
        if (this.editMode) {
            this.view.showTestButton(DataSetEditorConstants.INSTANCE.test(), DataSetEditorConstants.INSTANCE.updateTest_description(), this.testButtonHandler);
        } else {
            this.view.showTestButton(DataSetEditorConstants.INSTANCE.test(), DataSetEditorConstants.INSTANCE.test_description(), this.testButtonHandler);
        }
    }

    private void showCancelButton() {
        this.view.showCancelButton(this.cancelHandler);
    }

    private void hideTestButton() {
        this.view.hideTestButton();
    }

    private void hideCancelButton() {
        this.view.hideCancelButton();
    }

    private void clear() {
        this.dataSetDef = null;
        this.originalColumns = null;
        this.updateColumnsView = false;
        this.tableDisplayer = null;
        this.view.clear();
    }

    private class DataSetHandlerForEdit
    extends DataSetHandlerImpl {
        private DataSetDef defEdit;

        public DataSetHandlerForEdit(DataSetLookup lookup, DataSetDef defEdit) {
            super(lookup);
            this.defEdit = defEdit;
        }

        public void lookupDataSet(final DataSetReadyCallback callback) throws Exception {
            this.lookupCurrent.setTestMode(true);
            DataSetEditor.this.clientServices.lookupDataSet(this.defEdit, this.lookupCurrent, new DataSetReadyCallback(){

                public void callback(DataSet dataSet) {
                    DataSetHandlerForEdit.this.lastLookedUpDataSet = dataSet;
                    callback.callback(dataSet);
                }

                public void notFound() {
                    callback.notFound();
                }

                public boolean onError(ClientRuntimeError error) {
                    return callback.onError(error);
                }
            });
        }
    }

    private static enum WorkflowView {
        PROVIDER_SELECTION,
        DATA_CONF,
        PREVIEW_AND_ADVANCED;

    }

    public static interface View
    extends IsWidget,
    HasHandlers {
        public View edit(DataSetDef var1, DataSetDefEditWorkflow var2);

        public Set getViolations();

        public View setEditMode(boolean var1);

        public View showProviderSelectionView();

        public View showBasicAttributesEditionView(String var1);

        public View showSQLAttributesEditorView();

        public View showBeanAttributesEditorView();

        public View showCSVAttributesEditorView(FormPanel.SubmitCompleteHandler var1);

        public View showELAttributesEditorView();

        public View showPreviewTableEditionView(Displayer var1);

        public View showColumnsEditorView(List<DataColumnDef> var1, DataSet var2, DataSetColumnsEditor.ColumnsChangedEventHandler var3);

        public View showFilterEditionView(DataSet var1, DataSetFilterEditor.Listener var2);

        public View showAdvancedAttributesEditionView();

        public View showTestButton(String var1, String var2, ClickHandler var3);

        public View hideTestButton();

        public View showNextButton(String var1, String var2, ButtonType var3, ClickHandler var4);

        public View enableNextButton(boolean var1);

        public View showCancelButton(ClickHandler var1);

        public View hideCancelButton();

        public HandlerRegistration addConfigurationTabClickHandler(ClickHandler var1);

        public HandlerRegistration addPreviewTabClickHandler(ClickHandler var1);

        public HandlerRegistration addAdvancedConfigurationTabClickHandler(ClickHandler var1);

        public View onSave();

        public View showLoadingView();

        public View hideLoadingView();

        public View showError(String var1, String var2);

        public View clear();
    }
}

