/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.client.widgets.dataset.editor.widgets.editors.csv;

import com.github.gwtbootstrap.client.ui.Button;
import com.github.gwtbootstrap.client.ui.Row;
import com.google.gwt.core.client.GWT;
import com.google.gwt.editor.client.EditorError;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.FormPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.List;
import javax.enterprise.context.Dependent;
import org.dashbuilder.client.widgets.dataset.editor.widgets.editors.AbstractDataSetDefEditor;
import org.dashbuilder.common.client.validation.editors.FileUploadEditor;
import org.dashbuilder.common.client.validation.editors.ValueBoxEditorDecorator;
import org.dashbuilder.dataset.client.DataSetClientServices;
import org.dashbuilder.dataset.client.resources.bundles.DataSetClientResources;
import org.dashbuilder.dataset.client.validation.editors.CSVDataSetDefEditor;
import org.dashbuilder.dataset.def.CSVDataSetDef;
import org.dashbuilder.dataset.def.DataSetDef;

@Dependent
public class CSVDataSetDefAttributesEditor
extends AbstractDataSetDefEditor
implements CSVDataSetDefEditor {
    private static CSVDataSetDefAttributesEditorBinder uiBinder = (CSVDataSetDefAttributesEditorBinder)GWT.create(CSVDataSetDefAttributesEditorBinder.class);
    @UiField
    FlowPanel csvAttributesPanel;
    @UiField
    Row filePathRow;
    @UiField
    FileUploadEditor filePath;
    @UiField
    Row fileURLRow;
    @UiField
    ValueBoxEditorDecorator<String> fileURL;
    @UiField
    Button useFilePathButton;
    @UiField
    Button useFileURLButton;
    @UiField
    ValueBoxEditorDecorator<Character> separatorChar;
    @UiField
    ValueBoxEditorDecorator<Character> quoteChar;
    @UiField
    ValueBoxEditorDecorator<Character> escapeChar;
    @UiField
    ValueBoxEditorDecorator<String> datePattern;
    @UiField
    ValueBoxEditorDecorator<String> numberPattern;
    private boolean isEditMode;

    public CSVDataSetDefAttributesEditor() {
        this.initWidget((Widget)uiBinder.createAndBindUi((Object)this));
        ClickHandler useFilePathButtonHandler = new ClickHandler(){

            public void onClick(ClickEvent event) {
                CSVDataSetDefAttributesEditor.this.showFilePath();
            }
        };
        ClickHandler useFileURLButtonHandler = new ClickHandler(){

            public void onClick(ClickEvent event) {
                CSVDataSetDefAttributesEditor.this.showFileURL();
            }
        };
        this.useFilePathButton.addClickHandler(useFilePathButtonHandler);
        this.useFileURLButton.addClickHandler(useFileURLButtonHandler);
        this.filePath.setLoadingImageUri(DataSetClientResources.INSTANCE.images().loadingIcon().getSafeUri());
        this.filePath.setCallback(new FileUploadEditor.FileUploadEditorCallback(){

            public String getUploadFileName() {
                return CSVDataSetDefAttributesEditor.this.dataSetDef.getUUID() + ".csv";
            }

            public String getUploadFileUrl() {
                String csvPath = "default://master@datasets/tmp/" + CSVDataSetDefAttributesEditor.this.dataSetDef.getUUID() + ".csv";
                return DataSetClientServices.get().getUploadFileUrl(csvPath);
            }
        });
        this.showFilePath();
    }

    public HandlerRegistration addSubmitCompleteHandler(FormPanel.SubmitCompleteHandler submitCompleteHandler) {
        return this.filePath.addSubmitCompleteHandler(submitCompleteHandler);
    }

    public boolean isEditMode() {
        return this.isEditMode;
    }

    public void setEditMode(boolean isEditMode) {
        this.isEditMode = isEditMode;
    }

    @Override
    public void set(DataSetDef dataSetDef) {
        super.set(dataSetDef);
        if (this.getDefinition() != null && this.getDefinition().getFileURL() != null) {
            this.showFileURL();
        } else {
            this.showFilePath();
        }
    }

    private CSVDataSetDef getDefinition() {
        if (this.dataSetDef instanceof CSVDataSetDef) {
            return (CSVDataSetDef)this.dataSetDef;
        }
        return null;
    }

    public void showErrors(List<EditorError> errors) {
        this.consumeErrors(errors);
    }

    private void showFilePath() {
        this.fileURLRow.setVisible(false);
        this.filePathRow.setVisible(true);
    }

    private void showFileURL() {
        this.fileURLRow.setVisible(true);
        this.filePathRow.setVisible(false);
    }

    public boolean isUsingFilePath() {
        return this.filePathRow.isVisible();
    }

    public boolean isUsingFileURL() {
        return this.fileURLRow.isVisible();
    }

    @Override
    public void clear() {
        super.clear();
        this.filePath.clear();
        this.fileURL.clear();
        this.separatorChar.clear();
        this.quoteChar.clear();
        this.escapeChar.clear();
        this.datePattern.clear();
        this.numberPattern.clear();
    }

    static interface CSVDataSetDefAttributesEditorBinder
    extends UiBinder<Widget, CSVDataSetDefAttributesEditor> {
    }
}

