/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.client.widgets.dataset.editor;

import com.google.gwt.core.client.GWT;
import com.google.gwt.editor.client.Editor;
import com.google.gwt.editor.client.SimpleBeanEditorDriver;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validator;
import javax.validation.groups.Default;
import org.dashbuilder.client.widgets.dataset.editor.widgets.editors.AbstractEditor;
import org.dashbuilder.client.widgets.dataset.editor.widgets.editors.DataSetAdvancedAttributesEditor;
import org.dashbuilder.client.widgets.dataset.editor.widgets.editors.DataSetBasicAttributesEditor;
import org.dashbuilder.client.widgets.dataset.editor.widgets.editors.DataSetProviderTypeEditor;
import org.dashbuilder.client.widgets.dataset.editor.widgets.editors.bean.BeanDataSetDefAttributesEditor;
import org.dashbuilder.client.widgets.dataset.editor.widgets.editors.csv.CSVDataSetDefAttributesEditor;
import org.dashbuilder.client.widgets.dataset.editor.widgets.editors.datacolumn.DataColumnBasicEditor;
import org.dashbuilder.client.widgets.dataset.editor.widgets.editors.elasticsearch.ELDataSetDefAttributesEditor;
import org.dashbuilder.client.widgets.dataset.editor.widgets.editors.sql.SQLDataSetDefAttributesEditor;
import org.dashbuilder.dataset.def.BeanDataSetDef;
import org.dashbuilder.dataset.def.CSVDataSetDef;
import org.dashbuilder.dataset.def.DataColumnDef;
import org.dashbuilder.dataset.def.DataSetDef;
import org.dashbuilder.dataset.def.ElasticSearchDataSetDef;
import org.dashbuilder.dataset.def.SQLDataSetDef;
import org.dashbuilder.dataset.validation.groups.CSVDataSetDefFilePathValidation;
import org.dashbuilder.dataset.validation.groups.CSVDataSetDefFileURLValidation;
import org.dashbuilder.dataset.validation.groups.DataSetDefCacheRowsValidation;
import org.dashbuilder.dataset.validation.groups.DataSetDefPushSizeValidation;
import org.dashbuilder.dataset.validation.groups.DataSetDefRefreshIntervalValidation;
import org.dashbuilder.dataset.validation.groups.SQLDataSetDefDbSQLValidation;
import org.dashbuilder.dataset.validation.groups.SQLDataSetDefDbTableValidation;
import org.dashbuilder.validations.ValidatorFactory;

public final class DataSetDefEditWorkflow {
    public final BasicAttributesDriver basicAttributesDriver = (BasicAttributesDriver)GWT.create(BasicAttributesDriver.class);
    public final ProviderTypeAttributesDriver providerTypeAttributesDriver = (ProviderTypeAttributesDriver)GWT.create(ProviderTypeAttributesDriver.class);
    public final AdvancedAttributesDriver advancedAttributesDriver = (AdvancedAttributesDriver)GWT.create(AdvancedAttributesDriver.class);
    public final List<DataColumnDriver> columnDrivers = new LinkedList<DataColumnDriver>();
    public final SQLAttributesDriver sqlAttributesDriver = (SQLAttributesDriver)GWT.create(SQLAttributesDriver.class);
    public final CSVAttributesDriver csvAttributesDriver = (CSVAttributesDriver)GWT.create(CSVAttributesDriver.class);
    public final BeanAttributesDriver beanAttributesDriver = (BeanAttributesDriver)GWT.create(BeanAttributesDriver.class);
    public final ELAttributesDriver elAttributesDriver = (ELAttributesDriver)GWT.create(ELAttributesDriver.class);
    private DataSetBasicAttributesEditor basicAttributesEditor = null;
    private DataSetProviderTypeEditor providerTypeAttributeEditor = null;
    private DataSetAdvancedAttributesEditor advancedAttributesEditor = null;
    private final List<DataColumnBasicEditor> columnEditors = new LinkedList<DataColumnBasicEditor>();
    private SQLDataSetDefAttributesEditor sqlAttributesEditor = null;
    private BeanDataSetDefAttributesEditor beanAttributesEditor = null;
    private CSVDataSetDefAttributesEditor csvAttributesEditor = null;
    private ELDataSetDefAttributesEditor elasticSearchAttributesEditor = null;

    public DataSetDefEditWorkflow edit(DataSetBasicAttributesEditor view, DataSetDef p) {
        this.basicAttributesDriver.initialize((Editor)view);
        this.basicAttributesDriver.edit(p);
        this.basicAttributesEditor = view;
        return this;
    }

    public DataSetDefEditWorkflow edit(DataSetProviderTypeEditor view, DataSetDef p) {
        this.providerTypeAttributesDriver.initialize((Editor)view);
        this.providerTypeAttributesDriver.edit(p);
        this.providerTypeAttributeEditor = view;
        return this;
    }

    public DataSetDefEditWorkflow edit(DataSetAdvancedAttributesEditor view, DataSetDef p) {
        this.advancedAttributesDriver.initialize((Editor)view);
        this.advancedAttributesDriver.edit(p);
        this.advancedAttributesEditor = view;
        return this;
    }

    public DataSetDefEditWorkflow edit(DataColumnBasicEditor view, DataColumnDef d) {
        if (!this.columnEditors.contains((Object)view)) {
            DataColumnDriver driver = (DataColumnDriver)GWT.create(DataColumnDriver.class);
            driver.initialize((Editor)view);
            driver.edit(d);
            this.columnDrivers.add(driver);
            this.columnEditors.add(view);
        }
        return this;
    }

    public DataSetDefEditWorkflow remove(DataColumnBasicEditor view, DataColumnDef d) {
        int i = this.columnEditors.indexOf((Object)view);
        if (i > -1) {
            this.columnEditors.remove(i);
            this.columnDrivers.remove(i);
        }
        return this;
    }

    public DataSetDefEditWorkflow removeAllColumns() {
        this.columnEditors.clear();
        this.columnDrivers.clear();
        return this;
    }

    public DataSetDefEditWorkflow edit(SQLDataSetDefAttributesEditor view, SQLDataSetDef p) {
        this.sqlAttributesDriver.initialize((Editor)view);
        this.sqlAttributesDriver.edit(p);
        this.sqlAttributesEditor = view;
        return this;
    }

    public DataSetDefEditWorkflow edit(CSVDataSetDefAttributesEditor view, CSVDataSetDef p) {
        this.csvAttributesDriver.initialize((Editor)view);
        this.csvAttributesDriver.edit(p);
        this.csvAttributesEditor = view;
        return this;
    }

    public DataSetDefEditWorkflow edit(BeanDataSetDefAttributesEditor view, BeanDataSetDef p) {
        this.beanAttributesDriver.initialize((Editor)view);
        this.beanAttributesDriver.edit(p);
        this.beanAttributesEditor = view;
        return this;
    }

    public DataSetDefEditWorkflow edit(ELDataSetDefAttributesEditor view, ElasticSearchDataSetDef p) {
        this.elAttributesDriver.initialize((Editor)view);
        this.elAttributesDriver.edit(p);
        this.elasticSearchAttributesEditor = view;
        return this;
    }

    public DataSetDefEditWorkflow save() {
        if (this.basicAttributesEditor != null) {
            this.saveBasicAttributes();
        }
        if (this.providerTypeAttributeEditor != null) {
            this.saveProviderTypeAttribute();
        }
        if (this.advancedAttributesEditor != null) {
            this.saveAdvancedAttributes();
        }
        if (this.sqlAttributesEditor != null) {
            this.saveSQLAttributes();
        }
        if (this.csvAttributesEditor != null) {
            this.saveCSVAttributes();
        }
        if (this.beanAttributesEditor != null) {
            this.saveBeanAttributes();
        }
        if (this.elasticSearchAttributesEditor != null) {
            this.saveELAttributes();
        }
        if (!this.columnEditors.isEmpty()) {
            this.saveColumns();
        }
        return this;
    }

    private DataSetDefEditWorkflow saveBasicAttributes() {
        DataSetDef edited = (DataSetDef)this.basicAttributesDriver.flush();
        return this.validate(edited, this.basicAttributesEditor, this.basicAttributesDriver);
    }

    private DataSetDefEditWorkflow saveProviderTypeAttribute() {
        DataSetDef edited = (DataSetDef)this.providerTypeAttributesDriver.flush();
        return this.validate(edited, this.providerTypeAttributeEditor, this.providerTypeAttributesDriver);
    }

    private DataSetDefEditWorkflow saveAdvancedAttributes() {
        DataSetDef edited = (DataSetDef)this.advancedAttributesDriver.flush();
        LinkedList<Class> groups = new LinkedList<Class>();
        if (edited.isCacheEnabled()) {
            groups.add(DataSetDefCacheRowsValidation.class);
        }
        if (edited.isPushEnabled()) {
            groups.add(DataSetDefPushSizeValidation.class);
        }
        if (edited.getRefreshTime() != null) {
            groups.add(DataSetDefRefreshIntervalValidation.class);
        }
        if (!groups.isEmpty()) {
            groups.add(Default.class);
            this.validate(edited, this.advancedAttributesEditor, this.advancedAttributesDriver, groups.toArray(new Class[groups.size()]));
        } else {
            this.validate(edited, this.advancedAttributesEditor, this.advancedAttributesDriver);
        }
        return this;
    }

    private DataSetDefEditWorkflow saveColumns() {
        for (int x = 0; x < this.columnDrivers.size(); ++x) {
            DataColumnDriver driver = this.columnDrivers.get(x);
            DataColumnBasicEditor editor = this.columnEditors.get(x);
            DataColumnDef edited = (DataColumnDef)driver.flush();
            this.validateDataColumn(edited, editor, driver);
        }
        return this;
    }

    private DataSetDefEditWorkflow saveSQLAttributes() {
        SQLDataSetDef edited = (SQLDataSetDef)this.sqlAttributesDriver.flush();
        LinkedList<Class<Default>> groups = new LinkedList<Class<Default>>();
        if (this.sqlAttributesEditor.isUsingTable()) {
            edited.setDbSQL(null);
            groups.add(SQLDataSetDefDbTableValidation.class);
        } else {
            edited.setDbTable(null);
            groups.add(SQLDataSetDefDbSQLValidation.class);
        }
        if (!groups.isEmpty()) {
            groups.add(Default.class);
            return this.validateSQL(edited, this.sqlAttributesEditor, this.sqlAttributesDriver, groups.toArray(new Class[groups.size()]));
        }
        return this.validateSQL(edited, this.sqlAttributesEditor, this.sqlAttributesDriver, new Class[0]);
    }

    private DataSetDefEditWorkflow saveCSVAttributes() {
        CSVDataSetDef edited = (CSVDataSetDef)this.csvAttributesDriver.flush();
        LinkedList<Class> groups = new LinkedList<Class>();
        if (this.csvAttributesEditor.isUsingFilePath()) {
            edited.setFileURL(null);
            groups.add(CSVDataSetDefFilePathValidation.class);
        } else if (this.csvAttributesEditor.isUsingFileURL()) {
            edited.setFilePath(null);
            groups.add(CSVDataSetDefFileURLValidation.class);
        }
        return this.validateCSV(edited, this.csvAttributesEditor, this.csvAttributesDriver, groups.toArray(new Class[groups.size()]));
    }

    private DataSetDefEditWorkflow saveELAttributes() {
        ElasticSearchDataSetDef edited = (ElasticSearchDataSetDef)this.elAttributesDriver.flush();
        return this.validateEL(edited, this.elasticSearchAttributesEditor, this.elAttributesDriver);
    }

    private DataSetDefEditWorkflow saveBeanAttributes() {
        BeanDataSetDef edited = (BeanDataSetDef)this.beanAttributesDriver.flush();
        return this.validateBean(edited, this.beanAttributesEditor, this.beanAttributesDriver);
    }

    private DataSetDefEditWorkflow validateDataColumn(DataColumnDef dataColumn, AbstractEditor editor, SimpleBeanEditorDriver driver) {
        Set violations;
        Validator validator = ValidatorFactory.getDashbuilderValidator();
        Set test = violations = validator.validate((Object)dataColumn, new Class[0]);
        this.setViolations(editor, driver, test);
        return this;
    }

    private DataSetDefEditWorkflow validateSQL(SQLDataSetDef def, AbstractEditor editor, SimpleBeanEditorDriver driver, Class<?> ... groups) {
        Set violations;
        Validator validator = ValidatorFactory.getDashbuilderValidator();
        Set test = violations = groups != null ? validator.validate((Object)def, (Class[])groups) : validator.validate((Object)def, new Class[0]);
        this.setViolations(editor, driver, test);
        return this;
    }

    private DataSetDefEditWorkflow validateCSV(CSVDataSetDef def, AbstractEditor editor, SimpleBeanEditorDriver driver, Class<?> ... groups) {
        Set violations;
        Validator validator = ValidatorFactory.getDashbuilderValidator();
        Set test = violations = groups != null ? validator.validate((Object)def, (Class[])groups) : validator.validate((Object)def, new Class[0]);
        this.setViolations(editor, driver, test);
        return this;
    }

    private DataSetDefEditWorkflow validateEL(ElasticSearchDataSetDef def, AbstractEditor editor, SimpleBeanEditorDriver driver) {
        Set violations;
        Validator validator = ValidatorFactory.getDashbuilderValidator();
        Set test = violations = validator.validate((Object)def, new Class[0]);
        this.setViolations(editor, driver, test);
        return this;
    }

    private DataSetDefEditWorkflow validateBean(BeanDataSetDef def, AbstractEditor editor, SimpleBeanEditorDriver driver) {
        Set violations;
        Validator validator = ValidatorFactory.getDashbuilderValidator();
        Set test = violations = validator.validate((Object)def, new Class[0]);
        this.setViolations(editor, driver, test);
        return this;
    }

    private DataSetDefEditWorkflow validate(DataSetDef def, AbstractEditor editor, SimpleBeanEditorDriver driver) {
        Set violations;
        Validator validator = ValidatorFactory.getDashbuilderValidator();
        Set test = violations = validator.validate((Object)def, new Class[0]);
        this.setViolations(editor, driver, test);
        return null;
    }

    private DataSetDefEditWorkflow validate(DataSetDef def, AbstractEditor editor, SimpleBeanEditorDriver driver, Class<?> ... groups) {
        Set violations;
        Validator validator = ValidatorFactory.getDashbuilderValidator();
        Set test = violations = groups != null ? validator.validate((Object)def, (Class[])groups) : validator.validate((Object)def, new Class[0]);
        this.setViolations(editor, driver, test);
        return this;
    }

    private void setViolations(AbstractEditor editor, SimpleBeanEditorDriver driver, Iterable<ConstraintViolation<?>> violations) {
        driver.setConstraintViolations(violations);
        if (driver.hasErrors()) {
            editor.setViolations(violations);
        } else {
            editor.setViolations(null);
        }
    }

    public DataSetDefEditWorkflow clear() {
        this.basicAttributesEditor = null;
        this.providerTypeAttributeEditor = null;
        this.advancedAttributesEditor = null;
        this.sqlAttributesEditor = null;
        this.csvAttributesEditor = null;
        this.beanAttributesEditor = null;
        this.elasticSearchAttributesEditor = null;
        this.columnEditors.clear();
        this.columnDrivers.clear();
        return this;
    }

    static interface ELAttributesDriver
    extends SimpleBeanEditorDriver<ElasticSearchDataSetDef, ELDataSetDefAttributesEditor> {
    }

    static interface BeanAttributesDriver
    extends SimpleBeanEditorDriver<BeanDataSetDef, BeanDataSetDefAttributesEditor> {
    }

    static interface CSVAttributesDriver
    extends SimpleBeanEditorDriver<CSVDataSetDef, CSVDataSetDefAttributesEditor> {
    }

    static interface SQLAttributesDriver
    extends SimpleBeanEditorDriver<SQLDataSetDef, SQLDataSetDefAttributesEditor> {
    }

    static interface DataColumnDriver
    extends SimpleBeanEditorDriver<DataColumnDef, DataColumnBasicEditor> {
    }

    static interface AdvancedAttributesDriver
    extends SimpleBeanEditorDriver<DataSetDef, DataSetAdvancedAttributesEditor> {
    }

    static interface ProviderTypeAttributesDriver
    extends SimpleBeanEditorDriver<DataSetDef, DataSetProviderTypeEditor> {
    }

    static interface BasicAttributesDriver
    extends SimpleBeanEditorDriver<DataSetDef, DataSetBasicAttributesEditor> {
    }
}

