/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.client.widgets.dataset.editor.widgets.editors;

import com.github.gwtbootstrap.client.ui.CheckBox;
import com.github.gwtbootstrap.client.ui.ListBox;
import com.github.gwtbootstrap.client.ui.Row;
import com.google.gwt.core.client.GWT;
import com.google.gwt.editor.client.Editor;
import com.google.gwt.editor.client.EditorError;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.Arrays;
import java.util.List;
import javax.enterprise.context.Dependent;
import org.dashbuilder.client.widgets.dataset.editor.widgets.editors.AbstractDataSetDefEditor;
import org.dashbuilder.common.client.validation.editors.BooleanSwitchEditor;
import org.dashbuilder.common.client.validation.editors.ValueBoxEditorDecorator;
import org.dashbuilder.common.client.widgets.slider.TriangleSlider;
import org.dashbuilder.common.client.widgets.slider.event.BarValueChangedEvent;
import org.dashbuilder.common.client.widgets.slider.event.BarValueChangedHandler;
import org.dashbuilder.dataprovider.DataSetProviderType;
import org.dashbuilder.dataset.client.resources.i18n.DateIntervalTypeConstants;
import org.dashbuilder.dataset.client.validation.editors.DataSetDefEditor;
import org.dashbuilder.dataset.def.DataSetDef;
import org.dashbuilder.dataset.group.DateIntervalType;

@Dependent
public class DataSetAdvancedAttributesEditor
extends AbstractDataSetDefEditor
implements DataSetDefEditor {
    private static final double DEFAULT_REFRESH_QUANTITY = 1.0;
    private static final DateIntervalType DEFAULT_INTERVAL_TYPE = DateIntervalType.HOUR;
    private static List<DateIntervalType> ALLOWED_TYPES = Arrays.asList(DateIntervalType.SECOND, DateIntervalType.MINUTE, DateIntervalType.HOUR, DateIntervalType.DAY, DateIntervalType.MONTH, DateIntervalType.YEAR);
    private static DataSetAdvancedAttributesEditorBinder uiBinder = (DataSetAdvancedAttributesEditorBinder)GWT.create(DataSetAdvancedAttributesEditorBinder.class);
    @UiField
    FlowPanel advancedAttributesPanel;
    @UiField
    Row backendCacheRow;
    @UiField
    @Editor.Path(value="cacheEnabled")
    BooleanSwitchEditor attributeBackendCacheStatus;
    @UiField
    @Editor.Path(value="cacheMaxRows")
    ValueBoxEditorDecorator<Integer> attributeMaxRows;
    @UiField
    FlowPanel attributeMaxRowsSliderPanel;
    @UiField
    @Editor.Path(value="pushEnabled")
    BooleanSwitchEditor attributeClientCacheStatus;
    @UiField
    @Editor.Path(value="pushMaxSize")
    ValueBoxEditorDecorator<Integer> attributeMaxBytes;
    @UiField
    FlowPanel attributeMaxBytesSliderPanel;
    @UiField
    @Editor.Ignore
    BooleanSwitchEditor attributeRefreshStatus;
    @UiField
    @Editor.Ignore
    ValueBoxEditorDecorator<Integer> attributeRefreshInterval;
    @UiField
    @Editor.Ignore
    ListBox intervalType;
    @UiField
    @Editor.Ignore
    CheckBox onStaleCheckbox;
    final TriangleSlider backendCacheSlider = this.createSlider(10000, 200);
    final TriangleSlider clientCacheSlider = this.createSlider(4096, 200);
    private boolean isEditMode;
    private final ValueChangeHandler<Integer> refreshTimeQuantityValueChangeHandler = new ValueChangeHandler<Integer>(){

        public void onValueChange(ValueChangeEvent<Integer> event) {
            DataSetAdvancedAttributesEditor.this.switchRefresh(true);
        }
    };
    private final ValueChangeHandler<Boolean> attributeClientCacheStatusHandler = new ValueChangeHandler<Boolean>(){

        public void onValueChange(ValueChangeEvent<Boolean> event) {
            DataSetAdvancedAttributesEditor.this.attributeMaxBytes.setEnabled(((Boolean)event.getValue()).booleanValue());
        }
    };
    private final ValueChangeHandler<Boolean> attributeBackendCacheStatusHandler = new ValueChangeHandler<Boolean>(){

        public void onValueChange(ValueChangeEvent<Boolean> event) {
            DataSetAdvancedAttributesEditor.this.attributeMaxRows.setEnabled(((Boolean)event.getValue()).booleanValue());
        }
    };
    private final ValueChangeHandler<Boolean> refreshStatusHandler = new ValueChangeHandler<Boolean>(){

        public void onValueChange(ValueChangeEvent<Boolean> event) {
            DataSetAdvancedAttributesEditor.this.switchRefresh((Boolean)event.getValue());
        }
    };
    private final BarValueChangedHandler backendCacheSliderHandler = new BarValueChangedHandler(){

        public void onBarValueChanged(BarValueChangedEvent event) {
            DataSetAdvancedAttributesEditor.this.attributeMaxRows.asEditor().setValue((Object)event.getValue());
        }
    };
    private final BarValueChangedHandler clientCacheSliderHandler = new BarValueChangedHandler(){

        public void onBarValueChanged(BarValueChangedEvent event) {
            DataSetAdvancedAttributesEditor.this.attributeMaxBytes.asEditor().setValue((Object)event.getValue());
        }
    };
    private final ValueChangeHandler<Integer> attributeMaxRowsChangeHandler = new ValueChangeHandler<Integer>(){

        public void onValueChange(ValueChangeEvent<Integer> event) {
            DataSetAdvancedAttributesEditor.this.backendCacheSlider.setValue(((Integer)event.getValue()).intValue());
        }
    };
    private final ValueChangeHandler<Integer> attributeMaxBytesChangeHandler = new ValueChangeHandler<Integer>(){

        public void onValueChange(ValueChangeEvent<Integer> event) {
            DataSetAdvancedAttributesEditor.this.clientCacheSlider.setValue(((Integer)event.getValue()).intValue());
        }
    };

    public DataSetAdvancedAttributesEditor() {
        this.initWidget((Widget)uiBinder.createAndBindUi((Object)this));
        this.attributeRefreshInterval.addValueChangeHandler(this.refreshTimeQuantityValueChangeHandler);
        for (DateIntervalType dateInterval : ALLOWED_TYPES) {
            String s = this.getIntervalTypeText(dateInterval);
            this.intervalType.addItem(s);
        }
        this.intervalType.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                DataSetAdvancedAttributesEditor.this.switchRefresh(true);
            }
        });
        this.onStaleCheckbox.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                DataSetAdvancedAttributesEditor.this.switchRefresh(true);
            }
        });
        this.attributeMaxRowsSliderPanel.add((Widget)this.backendCacheSlider);
        this.backendCacheSlider.addBarValueChangedHandler(this.backendCacheSliderHandler);
        this.attributeMaxBytesSliderPanel.add((Widget)this.clientCacheSlider);
        this.clientCacheSlider.addBarValueChangedHandler(this.clientCacheSliderHandler);
        this.attributeMaxRows.addValueChangeHandler(this.attributeMaxRowsChangeHandler);
        this.attributeMaxBytes.addValueChangeHandler(this.attributeMaxBytesChangeHandler);
        this.attributeClientCacheStatus.addValueChangeHandler(this.attributeClientCacheStatusHandler);
        this.attributeBackendCacheStatus.addValueChangeHandler(this.attributeBackendCacheStatusHandler);
        this.attributeRefreshStatus.addValueChangeHandler(this.refreshStatusHandler);
    }

    private void switchRefresh(boolean on) {
        if (this.dataSetDef != null) {
            if (on) {
                Integer quantity = (Integer)this.attributeRefreshInterval.asEditor().getValue();
                if (quantity != null) {
                    DateIntervalType type = this.getSelectedIntervalType();
                    String rTime = quantity + type.name();
                    this.dataSetDef.setRefreshTime(rTime);
                }
                this.dataSetDef.setRefreshAlways(this.onStaleCheckbox.getValue() == false);
            } else {
                this.dataSetDef.setRefreshTime(null);
            }
        }
        this.setRefreshUIValues(on);
    }

    public boolean isShowBackendCache(DataSetDef def) {
        return def != null && def.getProvider() != null && !DataSetProviderType.BEAN.equals((Object)def.getProvider()) && !DataSetProviderType.CSV.equals((Object)def.getProvider());
    }

    private DateIntervalType getSelectedIntervalType() {
        return ALLOWED_TYPES.get(this.intervalType.getSelectedIndex());
    }

    private int getIntervalTypeIndex(DateIntervalType type) {
        for (int i = 0; i < ALLOWED_TYPES.size(); ++i) {
            if (!ALLOWED_TYPES.get(i).equals((Object)type)) continue;
            return i;
        }
        return 0;
    }

    public boolean isEditMode() {
        return this.isEditMode;
    }

    public void setEditMode(boolean isEditMode) {
        this.isEditMode = isEditMode;
    }

    public void showErrors(List<EditorError> errors) {
        this.consumeErrors(errors);
    }

    @Override
    public void set(DataSetDef dataSetDef) {
        super.set(dataSetDef);
        this.init();
    }

    private void init() {
        this.backendCacheSlider.setValue(this.dataSetDef.getCacheMaxRows().intValue());
        this.clientCacheSlider.setValue(this.dataSetDef.getPushMaxSize().intValue());
        if (this.isShowBackendCache(this.dataSetDef)) {
            this.backendCacheRow.setVisible(true);
        } else {
            this.backendCacheRow.setVisible(false);
        }
        this.attributeMaxRows.setEnabled(this.dataSetDef.isCacheEnabled());
        this.attributeMaxBytes.setEnabled(this.dataSetDef.isPushEnabled());
        boolean isRefreshOn = this.dataSetDef.getRefreshTime() != null;
        this.attributeRefreshStatus.setValue(Boolean.valueOf(isRefreshOn));
        this.setRefreshUIValues(isRefreshOn);
    }

    private void setRefreshUIValues(boolean refreshEnabled) {
        this.attributeRefreshInterval.setEnabled(refreshEnabled);
        this.intervalType.setEnabled(refreshEnabled);
        this.onStaleCheckbox.setEnabled(refreshEnabled);
        if (this.dataSetDef != null && refreshEnabled) {
            if (this.dataSetDef.getRefreshTime() != null) {
                double quantity = this.dataSetDef.getRefreshTimeAmount().getQuantity();
                DateIntervalType dType = this.dataSetDef.getRefreshTimeAmount().getType();
                this.attributeRefreshInterval.asEditor().setValue((Object)((int)quantity));
                this.intervalType.setSelectedIndex(this.getIntervalTypeIndex(dType));
                this.onStaleCheckbox.setValue(Boolean.valueOf(!this.dataSetDef.isRefreshAlways()));
            } else {
                this.attributeRefreshInterval.asEditor().setValue((Object)1);
                this.intervalType.setSelectedIndex(this.getIntervalTypeIndex(DEFAULT_INTERVAL_TYPE));
                this.onStaleCheckbox.setValue(Boolean.valueOf(!this.dataSetDef.isRefreshAlways()));
            }
        }
    }

    private String getIntervalTypeText(DateIntervalType type) {
        if (type == null) {
            return null;
        }
        return DateIntervalTypeConstants.INSTANCE.getString(type.name());
    }

    private TriangleSlider createSlider(int maxValue, int width) {
        TriangleSlider slider = new TriangleSlider(maxValue, width, true);
        slider.drawMarks("white", 6);
        slider.setMinMarkStep(3);
        slider.setNotSelectedInFocus();
        return slider;
    }

    @Override
    public void clear() {
        super.clear();
        this.attributeBackendCacheStatus.clear();
        this.attributeMaxRows.clear();
        this.attributeClientCacheStatus.clear();
        this.attributeMaxBytes.clear();
        this.attributeRefreshStatus.clear();
    }

    static interface DataSetAdvancedAttributesEditorBinder
    extends UiBinder<Widget, DataSetAdvancedAttributesEditor> {
    }
}

